/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcChannel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.RawAsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.procedure2.LockInfo;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class AsyncHBaseAdmin
implements AsyncAdmin {
    private static final Log LOG = LogFactory.getLog(AsyncHBaseAdmin.class);
    private final RawAsyncHBaseAdmin rawAdmin;
    private final ExecutorService pool;

    AsyncHBaseAdmin(RawAsyncHBaseAdmin rawAdmin, ExecutorService pool) {
        this.rawAdmin = rawAdmin;
        this.pool = pool;
    }

    private <T> CompletableFuture<T> wrap(CompletableFuture<T> future) {
        CompletableFuture asyncFuture = new CompletableFuture();
        future.whenCompleteAsync((r, e) -> {
            if (e != null) {
                asyncFuture.completeExceptionally((Throwable)e);
            } else {
                asyncFuture.complete(r);
            }
        }, (Executor)this.pool);
        return asyncFuture;
    }

    @Override
    public CompletableFuture<Boolean> tableExists(TableName tableName) {
        return this.wrap(this.rawAdmin.tableExists(tableName));
    }

    @Override
    public CompletableFuture<List<TableDescriptor>> listTables(Optional<Pattern> pattern, boolean includeSysTables) {
        return this.wrap(this.rawAdmin.listTables(pattern, includeSysTables));
    }

    @Override
    public CompletableFuture<List<TableName>> listTableNames(Optional<Pattern> pattern, boolean includeSysTables) {
        return this.wrap(this.rawAdmin.listTableNames(pattern, includeSysTables));
    }

    @Override
    public CompletableFuture<TableDescriptor> getTableDescriptor(TableName tableName) {
        return this.wrap(this.rawAdmin.getTableDescriptor(tableName));
    }

    @Override
    public CompletableFuture<Void> createTable(TableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) {
        return this.wrap(this.rawAdmin.createTable(desc, startKey, endKey, numRegions));
    }

    @Override
    public CompletableFuture<Void> createTable(TableDescriptor desc, Optional<byte[][]> splitKeys) {
        return this.wrap(this.rawAdmin.createTable(desc, splitKeys));
    }

    @Override
    public CompletableFuture<Void> deleteTable(TableName tableName) {
        return this.wrap(this.rawAdmin.deleteTable(tableName));
    }

    @Override
    public CompletableFuture<List<TableDescriptor>> deleteTables(Pattern pattern) {
        return this.wrap(this.rawAdmin.deleteTables(pattern));
    }

    @Override
    public CompletableFuture<Void> truncateTable(TableName tableName, boolean preserveSplits) {
        return this.wrap(this.rawAdmin.truncateTable(tableName, preserveSplits));
    }

    @Override
    public CompletableFuture<Void> enableTable(TableName tableName) {
        return this.wrap(this.rawAdmin.enableTable(tableName));
    }

    @Override
    public CompletableFuture<List<TableDescriptor>> enableTables(Pattern pattern) {
        return this.wrap(this.rawAdmin.enableTables(pattern));
    }

    @Override
    public CompletableFuture<Void> disableTable(TableName tableName) {
        return this.wrap(this.rawAdmin.disableTable(tableName));
    }

    @Override
    public CompletableFuture<List<TableDescriptor>> disableTables(Pattern pattern) {
        return this.wrap(this.rawAdmin.disableTables(pattern));
    }

    @Override
    public CompletableFuture<Boolean> isTableEnabled(TableName tableName) {
        return this.wrap(this.rawAdmin.isTableEnabled(tableName));
    }

    @Override
    public CompletableFuture<Boolean> isTableDisabled(TableName tableName) {
        return this.wrap(this.rawAdmin.isTableDisabled(tableName));
    }

    @Override
    public CompletableFuture<Boolean> isTableAvailable(TableName tableName, byte[][] splitKeys) {
        return this.wrap(this.rawAdmin.isTableAvailable(tableName, splitKeys));
    }

    @Override
    public CompletableFuture<Pair<Integer, Integer>> getAlterStatus(TableName tableName) {
        return this.wrap(this.rawAdmin.getAlterStatus(tableName));
    }

    @Override
    public CompletableFuture<Void> addColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) {
        return this.wrap(this.rawAdmin.addColumnFamily(tableName, columnFamily));
    }

    @Override
    public CompletableFuture<Void> deleteColumnFamily(TableName tableName, byte[] columnFamily) {
        return this.wrap(this.rawAdmin.deleteColumnFamily(tableName, columnFamily));
    }

    @Override
    public CompletableFuture<Void> modifyColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) {
        return this.wrap(this.rawAdmin.modifyColumnFamily(tableName, columnFamily));
    }

    @Override
    public CompletableFuture<Void> createNamespace(NamespaceDescriptor descriptor) {
        return this.wrap(this.rawAdmin.createNamespace(descriptor));
    }

    @Override
    public CompletableFuture<Void> modifyNamespace(NamespaceDescriptor descriptor) {
        return this.wrap(this.rawAdmin.modifyNamespace(descriptor));
    }

    @Override
    public CompletableFuture<Void> deleteNamespace(String name) {
        return this.wrap(this.rawAdmin.deleteNamespace(name));
    }

    @Override
    public CompletableFuture<NamespaceDescriptor> getNamespaceDescriptor(String name) {
        return this.wrap(this.rawAdmin.getNamespaceDescriptor(name));
    }

    @Override
    public CompletableFuture<List<NamespaceDescriptor>> listNamespaceDescriptors() {
        return this.wrap(this.rawAdmin.listNamespaceDescriptors());
    }

    @Override
    public CompletableFuture<Boolean> closeRegion(byte[] regionName, Optional<ServerName> unused) {
        return this.wrap(this.rawAdmin.closeRegion(regionName, unused));
    }

    @Override
    public CompletableFuture<List<HRegionInfo>> getOnlineRegions(ServerName serverName) {
        return this.wrap(this.rawAdmin.getOnlineRegions(serverName));
    }

    @Override
    public CompletableFuture<List<HRegionInfo>> getTableRegions(TableName tableName) {
        return this.wrap(this.rawAdmin.getTableRegions(tableName));
    }

    @Override
    public CompletableFuture<Void> flush(TableName tableName) {
        return this.wrap(this.rawAdmin.flush(tableName));
    }

    @Override
    public CompletableFuture<Void> flushRegion(byte[] regionName) {
        return this.wrap(this.rawAdmin.flushRegion(regionName));
    }

    @Override
    public CompletableFuture<Void> compact(TableName tableName, Optional<byte[]> columnFamily) {
        return this.wrap(this.rawAdmin.compact(tableName, columnFamily));
    }

    @Override
    public CompletableFuture<Void> compactRegion(byte[] regionName, Optional<byte[]> columnFamily) {
        return this.wrap(this.rawAdmin.compactRegion(regionName, columnFamily));
    }

    @Override
    public CompletableFuture<Void> majorCompact(TableName tableName, Optional<byte[]> columnFamily) {
        return this.wrap(this.rawAdmin.majorCompact(tableName, columnFamily));
    }

    @Override
    public CompletableFuture<Void> majorCompactRegion(byte[] regionName, Optional<byte[]> columnFamily) {
        return this.wrap(this.rawAdmin.majorCompactRegion(regionName, columnFamily));
    }

    @Override
    public CompletableFuture<Void> compactRegionServer(ServerName serverName) {
        return this.wrap(this.rawAdmin.compactRegionServer(serverName));
    }

    @Override
    public CompletableFuture<Void> majorCompactRegionServer(ServerName serverName) {
        return this.wrap(this.rawAdmin.majorCompactRegionServer(serverName));
    }

    @Override
    public CompletableFuture<Boolean> setMergeOn(boolean on) {
        return this.wrap(this.rawAdmin.setMergeOn(on));
    }

    @Override
    public CompletableFuture<Boolean> isMergeOn() {
        return this.wrap(this.rawAdmin.isMergeOn());
    }

    @Override
    public CompletableFuture<Boolean> setSplitOn(boolean on) {
        return this.wrap(this.rawAdmin.setSplitOn(on));
    }

    @Override
    public CompletableFuture<Boolean> isSplitOn() {
        return this.wrap(this.rawAdmin.isSplitOn());
    }

    @Override
    public CompletableFuture<Void> mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) {
        return this.wrap(this.rawAdmin.mergeRegions(nameOfRegionA, nameOfRegionB, forcible));
    }

    @Override
    public CompletableFuture<Void> split(TableName tableName) {
        return this.wrap(this.rawAdmin.split(tableName));
    }

    @Override
    public CompletableFuture<Void> split(TableName tableName, byte[] splitPoint) {
        return this.wrap(this.rawAdmin.split(tableName, splitPoint));
    }

    @Override
    public CompletableFuture<Void> splitRegion(byte[] regionName, Optional<byte[]> splitPoint) {
        return this.wrap(this.rawAdmin.splitRegion(regionName, splitPoint));
    }

    @Override
    public CompletableFuture<Void> assign(byte[] regionName) {
        return this.wrap(this.rawAdmin.assign(regionName));
    }

    @Override
    public CompletableFuture<Void> unassign(byte[] regionName, boolean forcible) {
        return this.wrap(this.rawAdmin.unassign(regionName, forcible));
    }

    @Override
    public CompletableFuture<Void> offline(byte[] regionName) {
        return this.wrap(this.rawAdmin.offline(regionName));
    }

    @Override
    public CompletableFuture<Void> move(byte[] regionName, Optional<ServerName> destServerName) {
        return this.wrap(this.rawAdmin.move(regionName, destServerName));
    }

    @Override
    public CompletableFuture<Void> setQuota(QuotaSettings quota) {
        return this.wrap(this.rawAdmin.setQuota(quota));
    }

    @Override
    public CompletableFuture<List<QuotaSettings>> getQuota(QuotaFilter filter) {
        return this.wrap(this.rawAdmin.getQuota(filter));
    }

    @Override
    public CompletableFuture<Void> addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig) {
        return this.wrap(this.rawAdmin.addReplicationPeer(peerId, peerConfig));
    }

    @Override
    public CompletableFuture<Void> removeReplicationPeer(String peerId) {
        return this.wrap(this.rawAdmin.removeReplicationPeer(peerId));
    }

    @Override
    public CompletableFuture<Void> enableReplicationPeer(String peerId) {
        return this.wrap(this.rawAdmin.enableReplicationPeer(peerId));
    }

    @Override
    public CompletableFuture<Void> disableReplicationPeer(String peerId) {
        return this.wrap(this.rawAdmin.disableReplicationPeer(peerId));
    }

    @Override
    public CompletableFuture<ReplicationPeerConfig> getReplicationPeerConfig(String peerId) {
        return this.wrap(this.rawAdmin.getReplicationPeerConfig(peerId));
    }

    @Override
    public CompletableFuture<Void> updateReplicationPeerConfig(String peerId, ReplicationPeerConfig peerConfig) {
        return this.wrap(this.rawAdmin.updateReplicationPeerConfig(peerId, peerConfig));
    }

    @Override
    public CompletableFuture<Void> appendReplicationPeerTableCFs(String peerId, Map<TableName, ? extends Collection<String>> tableCfs) {
        return this.wrap(this.rawAdmin.appendReplicationPeerTableCFs(peerId, tableCfs));
    }

    @Override
    public CompletableFuture<Void> removeReplicationPeerTableCFs(String peerId, Map<TableName, ? extends Collection<String>> tableCfs) {
        return this.wrap(this.rawAdmin.removeReplicationPeerTableCFs(peerId, tableCfs));
    }

    @Override
    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers(Optional<Pattern> pattern) {
        return this.wrap(this.rawAdmin.listReplicationPeers(pattern));
    }

    @Override
    public CompletableFuture<List<TableCFs>> listReplicatedTableCFs() {
        return this.wrap(this.rawAdmin.listReplicatedTableCFs());
    }

    @Override
    public CompletableFuture<Void> snapshot(SnapshotDescription snapshot) {
        return this.wrap(this.rawAdmin.snapshot(snapshot));
    }

    @Override
    public CompletableFuture<Boolean> isSnapshotFinished(SnapshotDescription snapshot) {
        return this.wrap(this.rawAdmin.isSnapshotFinished(snapshot));
    }

    @Override
    public CompletableFuture<Void> restoreSnapshot(String snapshotName) {
        return this.wrap(this.rawAdmin.restoreSnapshot(snapshotName));
    }

    @Override
    public CompletableFuture<Void> restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) {
        return this.wrap(this.rawAdmin.restoreSnapshot(snapshotName, takeFailSafeSnapshot));
    }

    @Override
    public CompletableFuture<Void> cloneSnapshot(String snapshotName, TableName tableName) {
        return this.wrap(this.rawAdmin.cloneSnapshot(snapshotName, tableName));
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listSnapshots(Optional<Pattern> pattern) {
        return this.wrap(this.rawAdmin.listSnapshots(pattern));
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        return this.wrap(this.rawAdmin.listTableSnapshots(tableNamePattern, snapshotNamePattern));
    }

    @Override
    public CompletableFuture<Void> deleteSnapshot(String snapshotName) {
        return this.wrap(this.rawAdmin.deleteSnapshot(snapshotName));
    }

    @Override
    public CompletableFuture<Void> deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        return this.wrap(this.rawAdmin.deleteTableSnapshots(tableNamePattern, snapshotNamePattern));
    }

    @Override
    public CompletableFuture<Void> execProcedure(String signature, String instance, Map<String, String> props) {
        return this.wrap(this.rawAdmin.execProcedure(signature, instance, props));
    }

    @Override
    public CompletableFuture<byte[]> execProcedureWithRet(String signature, String instance, Map<String, String> props) {
        return this.wrap(this.rawAdmin.execProcedureWithRet(signature, instance, props));
    }

    @Override
    public CompletableFuture<Boolean> isProcedureFinished(String signature, String instance, Map<String, String> props) {
        return this.wrap(this.rawAdmin.isProcedureFinished(signature, instance, props));
    }

    @Override
    public CompletableFuture<Boolean> abortProcedure(long procId, boolean mayInterruptIfRunning) {
        return this.wrap(this.rawAdmin.abortProcedure(procId, mayInterruptIfRunning));
    }

    @Override
    public CompletableFuture<List<ProcedureInfo>> listProcedures() {
        return this.wrap(this.rawAdmin.listProcedures());
    }

    @Override
    public CompletableFuture<List<LockInfo>> listProcedureLocks() {
        return this.wrap(this.rawAdmin.listProcedureLocks());
    }

    @Override
    public CompletableFuture<Void> drainRegionServers(List<ServerName> servers) {
        return this.wrap(this.rawAdmin.drainRegionServers(servers));
    }

    @Override
    public CompletableFuture<List<ServerName>> listDrainingRegionServers() {
        return this.wrap(this.rawAdmin.listDrainingRegionServers());
    }

    @Override
    public CompletableFuture<Void> removeDrainFromRegionServers(List<ServerName> servers) {
        return this.wrap(this.rawAdmin.removeDrainFromRegionServers(servers));
    }

    @Override
    public CompletableFuture<ClusterStatus> getClusterStatus() {
        return this.getClusterStatus(ClusterStatus.Options.getDefaultOptions());
    }

    @Override
    public CompletableFuture<ClusterStatus> getClusterStatus(ClusterStatus.Options options) {
        return this.wrap(this.rawAdmin.getClusterStatus(options));
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        return this.wrap(this.rawAdmin.shutdown());
    }

    @Override
    public CompletableFuture<Void> stopMaster() {
        return this.wrap(this.rawAdmin.stopMaster());
    }

    @Override
    public CompletableFuture<Void> stopRegionServer(ServerName serverName) {
        return this.wrap(this.rawAdmin.stopRegionServer(serverName));
    }

    @Override
    public CompletableFuture<Void> updateConfiguration(ServerName serverName) {
        return this.wrap(this.rawAdmin.updateConfiguration(serverName));
    }

    @Override
    public CompletableFuture<Void> updateConfiguration() {
        return this.wrap(this.rawAdmin.updateConfiguration());
    }

    @Override
    public CompletableFuture<Void> rollWALWriter(ServerName serverName) {
        return this.wrap(this.rawAdmin.rollWALWriter(serverName));
    }

    @Override
    public CompletableFuture<Void> clearCompactionQueues(ServerName serverName, Set<String> queues) {
        return this.wrap(this.rawAdmin.clearCompactionQueues(serverName, queues));
    }

    @Override
    public CompletableFuture<List<SecurityCapability>> getSecurityCapabilities() {
        return this.wrap(this.rawAdmin.getSecurityCapabilities());
    }

    @Override
    public CompletableFuture<List<RegionLoad>> getRegionLoads(ServerName serverName, Optional<TableName> tableName) {
        return this.wrap(this.rawAdmin.getRegionLoads(serverName, tableName));
    }

    @Override
    public CompletableFuture<Boolean> isMasterInMaintenanceMode() {
        return this.wrap(this.rawAdmin.isMasterInMaintenanceMode());
    }

    @Override
    public CompletableFuture<CompactionState> getCompactionState(TableName tableName) {
        return this.wrap(this.rawAdmin.getCompactionState(tableName));
    }

    @Override
    public CompletableFuture<CompactionState> getCompactionStateForRegion(byte[] regionName) {
        return this.wrap(this.rawAdmin.getCompactionStateForRegion(regionName));
    }

    @Override
    public CompletableFuture<Optional<Long>> getLastMajorCompactionTimestamp(TableName tableName) {
        return this.wrap(this.rawAdmin.getLastMajorCompactionTimestamp(tableName));
    }

    @Override
    public CompletableFuture<Optional<Long>> getLastMajorCompactionTimestampForRegion(byte[] regionName) {
        return this.wrap(this.rawAdmin.getLastMajorCompactionTimestampForRegion(regionName));
    }

    @Override
    public CompletableFuture<Boolean> setBalancerOn(boolean on) {
        return this.wrap(this.rawAdmin.setBalancerOn(on));
    }

    @Override
    public CompletableFuture<Boolean> balance(boolean forcible) {
        return this.wrap(this.rawAdmin.balance(forcible));
    }

    @Override
    public CompletableFuture<Boolean> isBalancerOn() {
        return this.wrap(this.rawAdmin.isBalancerOn());
    }

    @Override
    public CompletableFuture<Boolean> setNormalizerOn(boolean on) {
        return this.wrap(this.rawAdmin.setNormalizerOn(on));
    }

    @Override
    public CompletableFuture<Boolean> isNormalizerOn() {
        return this.wrap(this.rawAdmin.isNormalizerOn());
    }

    @Override
    public CompletableFuture<Boolean> normalize() {
        return this.wrap(this.rawAdmin.normalize());
    }

    @Override
    public CompletableFuture<Boolean> setCleanerChoreOn(boolean enabled) {
        return this.wrap(this.rawAdmin.setCleanerChoreOn(enabled));
    }

    @Override
    public CompletableFuture<Boolean> isCleanerChoreOn() {
        return this.wrap(this.rawAdmin.isCleanerChoreOn());
    }

    @Override
    public CompletableFuture<Boolean> runCleanerChore() {
        return this.wrap(this.rawAdmin.runCleanerChore());
    }

    @Override
    public CompletableFuture<Boolean> setCatalogJanitorOn(boolean enabled) {
        return this.wrap(this.rawAdmin.setCatalogJanitorOn(enabled));
    }

    @Override
    public CompletableFuture<Boolean> isCatalogJanitorOn() {
        return this.wrap(this.rawAdmin.isCatalogJanitorOn());
    }

    @Override
    public CompletableFuture<Integer> runCatalogJanitor() {
        return this.wrap(this.rawAdmin.runCatalogJanitor());
    }

    @Override
    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> stubMaker, RawAsyncTable.CoprocessorCallable<S, R> callable) {
        return this.wrap(this.rawAdmin.coprocessorService(stubMaker, callable));
    }

    @Override
    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> stubMaker, RawAsyncTable.CoprocessorCallable<S, R> callable, ServerName serverName) {
        return this.wrap(this.rawAdmin.coprocessorService(stubMaker, callable, serverName));
    }
}

