/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCaller;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.io.netty.util.HashedWheelTimer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;

@InterfaceAudience.Private
public class AsyncMasterRequestRpcRetryingCaller<T>
extends AsyncRpcRetryingCaller<T> {
    private final Callable<T> callable;

    public AsyncMasterRequestRpcRetryingCaller(HashedWheelTimer retryTimer, AsyncConnectionImpl conn, Callable<T> callable, long pauseNs, int maxRetries, long operationTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt) {
        super(retryTimer, conn, pauseNs, maxRetries, operationTimeoutNs, rpcTimeoutNs, startLogErrorsCnt);
        this.callable = callable;
    }

    @Override
    protected void doCall() {
        this.conn.getMasterStub().whenComplete((stub, error) -> {
            if (error != null) {
                this.onError((Throwable)error, () -> "Get async master stub failed", err -> {});
                return;
            }
            this.resetCallTimeout();
            this.callable.call(this.controller, (MasterProtos.MasterService.Interface)stub).whenComplete((result, error2) -> {
                if (error2 != null) {
                    this.onError((Throwable)error2, () -> "Call to master failed", err -> {});
                    return;
                }
                this.future.complete(result);
            });
        });
    }

    @Override
    public CompletableFuture<T> call() {
        this.doCall();
        return this.future;
    }

    @FunctionalInterface
    public static interface Callable<T> {
        public CompletableFuture<T> call(HBaseRpcController var1, MasterProtos.MasterService.Interface var2);
    }
}

