/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCaller;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.io.netty.util.HashedWheelTimer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
class AsyncSingleRequestRpcRetryingCaller<T>
extends AsyncRpcRetryingCaller<T> {
    private final TableName tableName;
    private final byte[] row;
    private final RegionLocateType locateType;
    private final Callable<T> callable;

    public AsyncSingleRequestRpcRetryingCaller(HashedWheelTimer retryTimer, AsyncConnectionImpl conn, TableName tableName, byte[] row, RegionLocateType locateType, Callable<T> callable, long pauseNs, int maxAttempts, long operationTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt) {
        super(retryTimer, conn, pauseNs, maxAttempts, operationTimeoutNs, rpcTimeoutNs, startLogErrorsCnt);
        this.tableName = tableName;
        this.row = row;
        this.locateType = locateType;
        this.callable = callable;
    }

    private void call(HRegionLocation loc) {
        ClientProtos.ClientService.Interface stub;
        try {
            stub = this.conn.getRegionServerStub(loc.getServerName());
        }
        catch (IOException e) {
            this.onError(e, () -> "Get async stub to " + loc.getServerName() + " for '" + Bytes.toStringBinary((byte[])this.row) + "' in " + loc.getRegionInfo().getEncodedName() + " of " + this.tableName + " failed", err -> this.conn.getLocator().updateCachedLocation(loc, (Throwable)err));
            return;
        }
        this.resetCallTimeout();
        this.callable.call(this.controller, loc, stub).whenComplete((result, error) -> {
            if (error != null) {
                this.onError((Throwable)error, () -> "Call to " + loc.getServerName() + " for '" + Bytes.toStringBinary((byte[])this.row) + "' in " + loc.getRegionInfo().getEncodedName() + " of " + this.tableName + " failed", err -> this.conn.getLocator().updateCachedLocation(loc, (Throwable)err));
                return;
            }
            this.future.complete(result);
        });
    }

    @Override
    protected void doCall() {
        long locateTimeoutNs;
        if (this.operationTimeoutNs > 0L) {
            locateTimeoutNs = this.remainingTimeNs();
            if (locateTimeoutNs <= 0L) {
                this.completeExceptionally();
                return;
            }
        } else {
            locateTimeoutNs = -1L;
        }
        this.conn.getLocator().getRegionLocation(this.tableName, this.row, this.locateType, locateTimeoutNs).whenComplete((loc, error) -> {
            if (error != null) {
                this.onError((Throwable)error, () -> "Locate '" + Bytes.toStringBinary((byte[])this.row) + "' in " + this.tableName + " failed", err -> {});
                return;
            }
            this.call((HRegionLocation)loc);
        });
    }

    @Override
    public CompletableFuture<T> call() {
        this.doCall();
        return this.future;
    }

    @FunctionalInterface
    public static interface Callable<T> {
        public CompletableFuture<T> call(HBaseRpcController var1, HRegionLocation var2, ClientProtos.ClientService.Interface var3);
    }
}

