/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
public interface AsyncTableBase {
    public TableName getName();

    public Configuration getConfiguration();

    public long getRpcTimeout(TimeUnit var1);

    public long getReadRpcTimeout(TimeUnit var1);

    public long getWriteRpcTimeout(TimeUnit var1);

    public long getOperationTimeout(TimeUnit var1);

    public long getScanTimeout(TimeUnit var1);

    default public CompletableFuture<Boolean> exists(Get get) {
        return this.get(ConnectionUtils.toCheckExistenceOnly(get)).thenApply(r -> r.getExists());
    }

    public CompletableFuture<Result> get(Get var1);

    public CompletableFuture<Void> put(Put var1);

    public CompletableFuture<Void> delete(Delete var1);

    public CompletableFuture<Result> append(Append var1);

    public CompletableFuture<Result> increment(Increment var1);

    default public CompletableFuture<Long> incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) {
        return this.incrementColumnValue(row, family, qualifier, amount, Durability.SYNC_WAL);
    }

    default public CompletableFuture<Long> incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) {
        Preconditions.checkNotNull((Object)row, (Object)"row is null");
        Preconditions.checkNotNull((Object)family, (Object)"family is null");
        return this.increment(new Increment(row).addColumn(family, qualifier, amount).setDurability(durability)).thenApply(r -> Bytes.toLong((byte[])r.getValue(family, qualifier)));
    }

    default public CompletableFuture<Boolean> checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) {
        return this.checkAndPut(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, put);
    }

    public CompletableFuture<Boolean> checkAndPut(byte[] var1, byte[] var2, byte[] var3, CompareFilter.CompareOp var4, byte[] var5, Put var6);

    default public CompletableFuture<Boolean> checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) {
        return this.checkAndDelete(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, delete);
    }

    public CompletableFuture<Boolean> checkAndDelete(byte[] var1, byte[] var2, byte[] var3, CompareFilter.CompareOp var4, byte[] var5, Delete var6);

    public CompletableFuture<Void> mutateRow(RowMutations var1);

    default public CompletableFuture<Boolean> checkAndMutate(byte[] row, byte[] family, byte[] qualifier, byte[] value, RowMutations mutation) {
        return this.checkAndMutate(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, mutation);
    }

    public CompletableFuture<Boolean> checkAndMutate(byte[] var1, byte[] var2, byte[] var3, CompareFilter.CompareOp var4, byte[] var5, RowMutations var6);

    public CompletableFuture<List<Result>> scanAll(Scan var1);

    default public List<CompletableFuture<Boolean>> exists(List<Get> gets) {
        return this.get(ConnectionUtils.toCheckExistenceOnly(gets)).stream().map(f -> f.thenApply(r -> r.getExists())).collect(Collectors.toList());
    }

    default public CompletableFuture<List<Boolean>> existsAll(List<Get> gets) {
        return ConnectionUtils.allOf(this.exists(gets));
    }

    public List<CompletableFuture<Result>> get(List<Get> var1);

    default public CompletableFuture<List<Result>> getAll(List<Get> gets) {
        return ConnectionUtils.allOf(this.get(gets));
    }

    public List<CompletableFuture<Void>> put(List<Put> var1);

    default public CompletableFuture<Void> putAll(List<Put> puts) {
        return ConnectionUtils.allOf(this.put(puts)).thenApply(r -> null);
    }

    public List<CompletableFuture<Void>> delete(List<Delete> var1);

    default public CompletableFuture<Void> deleteAll(List<Delete> deletes) {
        return ConnectionUtils.allOf(this.delete(deletes)).thenApply(r -> null);
    }

    public <T> List<CompletableFuture<T>> batch(List<? extends Row> var1);

    default public <T> CompletableFuture<List<T>> batchAll(List<? extends Row> actions) {
        return ConnectionUtils.allOf(this.batch(actions));
    }
}

