/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Comparator;
import java.util.Map;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.MobCompactPartitionPolicy;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
public interface ColumnFamilyDescriptor {
    @InterfaceAudience.Private
    public static final Comparator<ColumnFamilyDescriptor> COMPARATOR = (lhs, rhs) -> {
        int result = Bytes.compareTo((byte[])lhs.getName(), (byte[])rhs.getName());
        if (result != 0) {
            return result;
        }
        result = lhs.getValues().hashCode() - rhs.getValues().hashCode();
        if (result != 0) {
            return result;
        }
        return lhs.getConfiguration().hashCode() - rhs.getConfiguration().hashCode();
    };

    public int getBlocksize();

    public BloomType getBloomFilterType();

    public Compression.Algorithm getCompactionCompressionType();

    public Compression.Algorithm getCompressionType();

    public Map<String, String> getConfiguration();

    public String getConfigurationValue(String var1);

    public short getDFSReplication();

    public DataBlockEncoding getDataBlockEncoding();

    public byte[] getEncryptionKey();

    public String getEncryptionType();

    public MemoryCompactionPolicy getInMemoryCompaction();

    public KeepDeletedCells getKeepDeletedCells();

    public int getMaxVersions();

    public int getMinVersions();

    public MobCompactPartitionPolicy getMobCompactPartitionPolicy();

    public long getMobThreshold();

    public byte[] getName();

    public String getNameAsString();

    public int getScope();

    public String getStoragePolicy();

    public int getTimeToLive();

    public Bytes getValue(Bytes var1);

    public byte[] getValue(byte[] var1);

    public Map<Bytes, Bytes> getValues();

    public boolean isBlockCacheEnabled();

    public boolean isCacheBloomsOnWrite();

    public boolean isCacheDataInL1();

    public boolean isCacheDataOnWrite();

    public boolean isCacheIndexesOnWrite();

    public boolean isCompressTags();

    public boolean isEvictBlocksOnClose();

    public boolean isInMemory();

    public boolean isMobEnabled();

    public boolean isPrefetchBlocksOnOpen();

    public String toStringCustomizedValues();

    public boolean isNewVersionBehavior();
}

