/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.WrongRowIOException;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
public class Delete
extends Mutation
implements Comparable<Row> {
    public Delete(byte[] row) {
        this(row, Long.MAX_VALUE);
    }

    public Delete(byte[] row, long timestamp) {
        this(row, 0, row.length, timestamp);
    }

    public Delete(byte[] row, int rowOffset, int rowLength) {
        this(row, rowOffset, rowLength, Long.MAX_VALUE);
    }

    public Delete(byte[] row, int rowOffset, int rowLength, long timestamp) {
        Delete.checkRow(row, rowOffset, rowLength);
        this.row = Bytes.copy((byte[])row, (int)rowOffset, (int)rowLength);
        this.setTimestamp(timestamp);
    }

    public Delete(Delete d) {
        this.row = d.getRow();
        this.ts = d.getTimeStamp();
        this.familyMap.putAll(d.getFamilyCellMap());
        this.durability = d.durability;
        for (Map.Entry<String, byte[]> entry : d.getAttributesMap().entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
        super.setPriority(d.getPriority());
    }

    @Deprecated
    public Delete addDeleteMarker(Cell kv) throws IOException {
        return this.add(kv);
    }

    public Delete add(Cell kv) throws IOException {
        if (!CellUtil.isDelete((Cell)kv)) {
            throw new IOException("The recently added KeyValue is not of type delete. Rowkey: " + Bytes.toStringBinary((byte[])this.row));
        }
        if (!CellUtil.matchingRow((Cell)kv, (byte[])this.row)) {
            throw new WrongRowIOException("The row in " + kv.toString() + " doesn't match the original one " + Bytes.toStringBinary((byte[])this.row));
        }
        byte[] family = CellUtil.cloneFamily((Cell)kv);
        ArrayList<Cell> list = (ArrayList<Cell>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<Cell>(1);
            this.familyMap.put(family, list);
        }
        list.add(kv);
        return this;
    }

    public Delete addFamily(byte[] family) {
        this.addFamily(family, this.ts);
        return this;
    }

    public Delete addFamily(byte[] family, long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>(1);
            this.familyMap.put(family, list);
        } else if (!list.isEmpty()) {
            list.clear();
        }
        KeyValue kv = new KeyValue(this.row, family, null, timestamp, KeyValue.Type.DeleteFamily);
        list.add(kv);
        return this;
    }

    public Delete addFamilyVersion(byte[] family, long timestamp) {
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>(1);
            this.familyMap.put(family, list);
        }
        list.add(new KeyValue(this.row, family, null, timestamp, KeyValue.Type.DeleteFamilyVersion));
        return this;
    }

    public Delete addColumns(byte[] family, byte[] qualifier) {
        this.addColumns(family, qualifier, this.ts);
        return this;
    }

    public Delete addColumns(byte[] family, byte[] qualifier, long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>(1);
            this.familyMap.put(family, list);
        }
        list.add(new KeyValue(this.row, family, qualifier, timestamp, KeyValue.Type.DeleteColumn));
        return this;
    }

    public Delete addColumn(byte[] family, byte[] qualifier) {
        this.addColumn(family, qualifier, this.ts);
        return this;
    }

    public Delete addColumn(byte[] family, byte[] qualifier, long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>(1);
            this.familyMap.put(family, list);
        }
        KeyValue kv = new KeyValue(this.row, family, qualifier, timestamp, KeyValue.Type.Delete);
        list.add(kv);
        return this;
    }

    public Delete setTimestamp(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        this.ts = timestamp;
        return this;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = super.toMap(maxCols);
        map.put("ts", this.ts);
        return map;
    }

    @Override
    public Delete setAttribute(String name, byte[] value) {
        return (Delete)super.setAttribute(name, value);
    }

    @Override
    public Delete setId(String id) {
        return (Delete)super.setId(id);
    }

    @Override
    public Delete setDurability(Durability d) {
        return (Delete)super.setDurability(d);
    }

    @Override
    public Delete setFamilyCellMap(NavigableMap<byte[], List<Cell>> map) {
        return (Delete)super.setFamilyCellMap(map);
    }

    @Override
    public Delete setClusterIds(List<UUID> clusterIds) {
        return (Delete)super.setClusterIds(clusterIds);
    }

    @Override
    public Delete setCellVisibility(CellVisibility expression) {
        return (Delete)super.setCellVisibility(expression);
    }

    @Override
    public Delete setACL(String user, Permission perms) {
        return (Delete)super.setACL(user, perms);
    }

    @Override
    public Delete setACL(Map<String, Permission> perms) {
        return (Delete)super.setACL(perms);
    }

    @Override
    public Delete setTTL(long ttl) {
        throw new UnsupportedOperationException("Setting TTLs on Deletes is not supported");
    }

    @Override
    public Delete setPriority(int priority) {
        return (Delete)super.setPriority(priority);
    }
}

