/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.AsyncProcessTask;
import org.apache.hadoop.hbase.client.AsyncRequestFuture;
import org.apache.hadoop.hbase.client.CancellableRegionServerCallable;
import org.apache.hadoop.hbase.client.ClientAsyncPrefetchScanner;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.ClientSimpleScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hadoop.hbase.client.ImmutableHTableDescriptor;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.NoncedRegionServerCallable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionCoprocessorRpcChannel;
import org.apache.hadoop.hbase.client.RegionCoprocessorServiceExec;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RetryingTimeTracker;
import org.apache.hadoop.hbase.client.ReversedClientScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCallerWithReadReplicas;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SingleResponse;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilderBase;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class HTable
implements Table {
    private static final Log LOG = LogFactory.getLog(HTable.class);
    private static final Consistency DEFAULT_CONSISTENCY = Consistency.STRONG;
    private final ClusterConnection connection;
    private final TableName tableName;
    private final Configuration configuration;
    private final ConnectionConfiguration connConfiguration;
    private boolean closed = false;
    private final int scannerCaching;
    private final long scannerMaxResultSize;
    private final ExecutorService pool;
    private int operationTimeout;
    private final int rpcTimeout;
    private int readRpcTimeout;
    private int writeRpcTimeout;
    private final boolean cleanupPoolOnClose;
    private final HRegionLocator locator;
    @VisibleForTesting
    AsyncProcess multiAp;
    private final RpcRetryingCallerFactory rpcCallerFactory;
    private final RpcControllerFactory rpcControllerFactory;

    @InterfaceAudience.Private
    public static ThreadPoolExecutor getDefaultExecutor(Configuration conf) {
        int maxThreads = conf.getInt("hbase.htable.threads.max", Integer.MAX_VALUE);
        if (maxThreads == 0) {
            maxThreads = 1;
        }
        int corePoolSize = conf.getInt("hbase.htable.threads.coresize", 1);
        long keepAliveTime = conf.getLong("hbase.htable.threads.keepalivetime", 60L);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(corePoolSize, maxThreads, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory((String)"htable"));
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    @InterfaceAudience.Private
    protected HTable(ClusterConnection connection, TableBuilderBase builder, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, ExecutorService pool) {
        if (connection == null || connection.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.connection = connection;
        this.configuration = connection.getConfiguration();
        this.connConfiguration = connection.getConnectionConfiguration();
        if (pool == null) {
            this.pool = HTable.getDefaultExecutor(this.configuration);
            this.cleanupPoolOnClose = true;
        } else {
            this.pool = pool;
            this.cleanupPoolOnClose = false;
        }
        this.rpcCallerFactory = rpcCallerFactory == null ? connection.getNewRpcRetryingCallerFactory(this.configuration) : rpcCallerFactory;
        this.rpcControllerFactory = rpcControllerFactory == null ? RpcControllerFactory.instantiate(this.configuration) : rpcControllerFactory;
        this.tableName = builder.tableName;
        this.operationTimeout = builder.operationTimeout;
        this.rpcTimeout = builder.rpcTimeout;
        this.readRpcTimeout = builder.readRpcTimeout;
        this.writeRpcTimeout = builder.writeRpcTimeout;
        this.scannerCaching = this.connConfiguration.getScannerCaching();
        this.scannerMaxResultSize = this.connConfiguration.getScannerMaxResultSize();
        this.multiAp = this.connection.getAsyncProcess();
        this.locator = new HRegionLocator(this.tableName, connection);
    }

    public static int getMaxKeyValueSize(Configuration conf) {
        return conf.getInt("hbase.client.keyvalue.maxsize", -1);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @VisibleForTesting
    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    public HTableDescriptor getTableDescriptor() throws IOException {
        HTableDescriptor htd = HBaseAdmin.getHTableDescriptor(this.tableName, this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.operationTimeout, this.readRpcTimeout);
        if (htd != null) {
            return new ImmutableHTableDescriptor(htd);
        }
        return null;
    }

    @Override
    public TableDescriptor getDescriptor() throws IOException {
        HTableDescriptor htd = HBaseAdmin.getHTableDescriptor(this.tableName, this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.operationTimeout, this.readRpcTimeout);
        if (htd != null) {
            return new ImmutableHTableDescriptor(htd);
        }
        return null;
    }

    private Pair<List<byte[]>, List<HRegionLocation>> getKeysAndRegionsInRange(byte[] startKey, byte[] endKey, boolean includeEndKey) throws IOException {
        return this.getKeysAndRegionsInRange(startKey, endKey, includeEndKey, false);
    }

    private Pair<List<byte[]>, List<HRegionLocation>> getKeysAndRegionsInRange(byte[] startKey, byte[] endKey, boolean includeEndKey, boolean reload) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])startKey) + " > " + Bytes.toStringBinary((byte[])endKey));
        }
        ArrayList<byte[]> keysInRange = new ArrayList<byte[]>();
        ArrayList<HRegionLocation> regionsInRange = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            regionLocation = this.getRegionLocator().getRegionLocation(currentKey, reload);
            keysInRange.add(currentKey);
            regionsInRange.add(regionLocation);
        } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0 || includeEndKey && Bytes.compareTo((byte[])currentKey, (byte[])endKey) == 0));
        return new Pair(keysInRange, regionsInRange);
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        Boolean async;
        if (scan.getCaching() <= 0) {
            scan.setCaching(this.scannerCaching);
        }
        if (scan.getMaxResultSize() <= 0L) {
            scan.setMaxResultSize(this.scannerMaxResultSize);
        }
        if (scan.getMvccReadPoint() > 0L) {
            scan.resetMvccReadPoint();
        }
        if ((async = scan.isAsyncPrefetch()) == null) {
            async = this.connConfiguration.isClientScannerAsyncPrefetch();
        }
        if (scan.isReversed()) {
            return new ReversedClientScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.connConfiguration.getReplicaCallTimeoutMicroSecondScan());
        }
        if (async.booleanValue()) {
            return new ClientAsyncPrefetchScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.connConfiguration.getReplicaCallTimeoutMicroSecondScan());
        }
        return new ClientSimpleScanner(this.getConfiguration(), scan, this.getName(), this.connection, this.rpcCallerFactory, this.rpcControllerFactory, this.pool, this.connConfiguration.getReplicaCallTimeoutMicroSecondScan());
    }

    @Override
    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    @Override
    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    @Override
    public Result get(Get get) throws IOException {
        return this.get(get, get.isCheckExistenceOnly());
    }

    private Result get(Get get, boolean checkExistenceOnly) throws IOException {
        if (get.isCheckExistenceOnly() != checkExistenceOnly || get.getConsistency() == null) {
            get = (Get)ReflectionUtils.newInstance(get.getClass(), (Object[])new Object[]{get});
            get.setCheckExistenceOnly(checkExistenceOnly);
            if (get.getConsistency() == null) {
                get.setConsistency(DEFAULT_CONSISTENCY);
            }
        }
        if (get.getConsistency() == Consistency.STRONG) {
            final Get configuredGet = get;
            ClientServiceCallable<Result> callable = new ClientServiceCallable<Result>((Connection)this.connection, this.getName(), get.getRow(), (RpcController)this.rpcControllerFactory.newController(), get.getPriority()){

                @Override
                protected Result rpcCall() throws Exception {
                    ClientProtos.GetRequest request = RequestConverter.buildGetRequest(this.getLocation().getRegionInfo().getRegionName(), configuredGet);
                    ClientProtos.GetResponse response = this.doGet(request);
                    return response == null ? null : org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toResult(response.getResult(), this.getRpcControllerCellScanner());
                }
            };
            return this.rpcCallerFactory.newCaller(this.readRpcTimeout).callWithRetries(callable, this.operationTimeout);
        }
        RpcRetryingCallerWithReadReplicas callable = new RpcRetryingCallerWithReadReplicas(this.rpcControllerFactory, this.tableName, this.connection, get, this.pool, this.connConfiguration.getRetriesNumber(), this.operationTimeout, this.readRpcTimeout, this.connConfiguration.getPrimaryCallTimeoutMicroSecond());
        return callable.call(this.operationTimeout);
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        if (gets.size() == 1) {
            return new Result[]{this.get(gets.get(0))};
        }
        try {
            Object[] r1 = new Object[gets.size()];
            this.batch(gets, r1, this.readRpcTimeout);
            Result[] results = new Result[r1.length];
            int i = 0;
            for (Object obj : r1) {
                results[i++] = (Result)obj;
            }
            return results;
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
    }

    @Override
    public void batch(List<? extends Row> actions, Object[] results) throws InterruptedException, IOException {
        int rpcTimeout = this.writeRpcTimeout;
        boolean hasRead = false;
        boolean hasWrite = false;
        for (Row row : actions) {
            if (row instanceof Mutation) {
                hasWrite = true;
            } else {
                hasRead = true;
            }
            if (!hasRead || !hasWrite) continue;
            break;
        }
        if (hasRead && !hasWrite) {
            rpcTimeout = this.readRpcTimeout;
        }
        this.batch(actions, results, rpcTimeout);
    }

    public void batch(List<? extends Row> actions, Object[] results, int rpcTimeout) throws InterruptedException, IOException {
        AsyncProcessTask task = AsyncProcessTask.newBuilder().setPool(this.pool).setTableName(this.tableName).setRowAccess(actions).setResults(results).setRpcTimeout(rpcTimeout).setOperationTimeout(this.operationTimeout).setSubmittedRows(AsyncProcessTask.SubmittedRows.ALL).build();
        AsyncRequestFuture ars = this.multiAp.submit(task);
        ars.waitUntilDone();
        if (ars.hasError()) {
            throw ars.getErrors();
        }
    }

    @Override
    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        HTable.doBatchWithCallback(actions, results, callback, this.connection, this.pool, this.tableName);
    }

    public static <R> void doBatchWithCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback, ClusterConnection connection, ExecutorService pool, TableName tableName) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        int operationTimeout = connection.getConnectionConfiguration().getOperationTimeout();
        int writeTimeout = connection.getConfiguration().getInt("hbase.rpc.write.timeout", connection.getConfiguration().getInt("hbase.rpc.timeout", 60000));
        AsyncProcessTask<R> task = AsyncProcessTask.newBuilder(callback).setPool(pool).setTableName(tableName).setRowAccess(actions).setResults(results).setOperationTimeout(operationTimeout).setRpcTimeout(writeTimeout).setSubmittedRows(AsyncProcessTask.SubmittedRows.ALL).build();
        AsyncRequestFuture ars = connection.getAsyncProcess().submit(task);
        ars.waitUntilDone();
        if (ars.hasError()) {
            throw ars.getErrors();
        }
    }

    @Override
    public void delete(final Delete delete) throws IOException {
        CancellableRegionServerCallable<SingleResponse> callable = new CancellableRegionServerCallable<SingleResponse>((Connection)this.connection, this.getName(), delete.getRow(), (RpcController)this.rpcControllerFactory.newController(), this.writeRpcTimeout, new RetryingTimeTracker().start(), delete.getPriority()){

            @Override
            protected SingleResponse rpcCall() throws Exception {
                ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), delete);
                ClientProtos.MutateResponse response = this.doMutate(request);
                return ResponseConverter.getResult(request, response, this.getRpcControllerCellScanner());
            }
        };
        List<Delete> rows = Collections.singletonList(delete);
        AsyncProcessTask task = AsyncProcessTask.newBuilder().setPool(this.pool).setTableName(this.tableName).setRowAccess(rows).setCallable(callable).setRpcTimeout(this.writeRpcTimeout).setOperationTimeout(this.operationTimeout).setSubmittedRows(AsyncProcessTask.SubmittedRows.ALL).build();
        AsyncRequestFuture ars = this.multiAp.submit(task);
        ars.waitUntilDone();
        if (ars.hasError()) {
            throw ars.getErrors();
        }
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        Object[] results = new Object[deletes.size()];
        try {
            this.batch(deletes, results, this.writeRpcTimeout);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        finally {
            for (int i = results.length - 1; i >= 0; --i) {
                if (!(results[i] instanceof Result)) continue;
                deletes.remove(i);
            }
        }
    }

    @Override
    public void put(final Put put) throws IOException {
        this.validatePut(put);
        ClientServiceCallable<Void> callable = new ClientServiceCallable<Void>((Connection)this.connection, this.getName(), put.getRow(), (RpcController)this.rpcControllerFactory.newController(), put.getPriority()){

            @Override
            protected Void rpcCall() throws Exception {
                ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), put);
                this.doMutate(request);
                return null;
            }
        };
        this.rpcCallerFactory.newCaller(this.writeRpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        for (Put put : puts) {
            this.validatePut(put);
        }
        Object[] results = new Object[puts.size()];
        try {
            this.batch(puts, results, this.writeRpcTimeout);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
    }

    @Override
    public void mutateRow(final RowMutations rm) throws IOException {
        CancellableRegionServerCallable<MultiResponse> callable = new CancellableRegionServerCallable<MultiResponse>((Connection)this.connection, this.getName(), rm.getRow(), (RpcController)this.rpcControllerFactory.newController(), this.writeRpcTimeout, new RetryingTimeTracker().start(), rm.getMaxPriority()){

            @Override
            protected MultiResponse rpcCall() throws Exception {
                ClientProtos.RegionAction.Builder regionMutationBuilder = RequestConverter.buildRegionAction(this.getLocation().getRegionInfo().getRegionName(), rm);
                regionMutationBuilder.setAtomic(true);
                ClientProtos.MultiRequest request = ClientProtos.MultiRequest.newBuilder().addRegionAction(regionMutationBuilder.build()).build();
                ClientProtos.MultiResponse response = this.doMulti(request);
                ClientProtos.RegionActionResult res = (ClientProtos.RegionActionResult)response.getRegionActionResultList().get(0);
                if (res.hasException()) {
                    Throwable ex = org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toException(res.getException());
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    throw new IOException("Failed to mutate row: " + Bytes.toStringBinary((byte[])rm.getRow()), ex);
                }
                return ResponseConverter.getResults(request, response, this.getRpcControllerCellScanner());
            }
        };
        AsyncProcessTask task = AsyncProcessTask.newBuilder().setPool(this.pool).setTableName(this.tableName).setRowAccess(rm.getMutations()).setCallable(callable).setRpcTimeout(this.writeRpcTimeout).setOperationTimeout(this.operationTimeout).setSubmittedRows(AsyncProcessTask.SubmittedRows.ALL).build();
        AsyncRequestFuture ars = this.multiAp.submit(task);
        ars.waitUntilDone();
        if (ars.hasError()) {
            throw ars.getErrors();
        }
    }

    @Override
    public Result append(final Append append) throws IOException {
        ConnectionUtils.checkHasFamilies(append);
        NoncedRegionServerCallable<Result> callable = new NoncedRegionServerCallable<Result>((Connection)this.connection, this.getName(), append.getRow(), this.rpcControllerFactory.newController(), append.getPriority()){

            @Override
            protected Result rpcCall() throws Exception {
                ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), append, this.getNonceGroup(), this.getNonce());
                ClientProtos.MutateResponse response = this.doMutate(request);
                if (!response.hasResult()) {
                    return null;
                }
                return org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toResult(response.getResult(), this.getRpcControllerCellScanner());
            }
        };
        return this.rpcCallerFactory.newCaller(this.writeRpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public Result increment(final Increment increment) throws IOException {
        ConnectionUtils.checkHasFamilies(increment);
        NoncedRegionServerCallable<Result> callable = new NoncedRegionServerCallable<Result>((Connection)this.connection, this.getName(), increment.getRow(), this.rpcControllerFactory.newController(), increment.getPriority()){

            @Override
            protected Result rpcCall() throws Exception {
                ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), increment, this.getNonceGroup(), this.getNonce());
                ClientProtos.MutateResponse response = this.doMutate(request);
                return org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toResult(response.getResult(), this.getRpcControllerCellScanner());
            }
        };
        return this.rpcCallerFactory.newCaller(this.writeRpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, Durability.SYNC_WAL);
    }

    @Override
    public long incrementColumnValue(final byte[] row, final byte[] family, final byte[] qualifier, final long amount, final Durability durability) throws IOException {
        NullPointerException npe = null;
        if (row == null) {
            npe = new NullPointerException("row is null");
        } else if (family == null) {
            npe = new NullPointerException("family is null");
        }
        if (npe != null) {
            throw new IOException("Invalid arguments to incrementColumnValue", npe);
        }
        NoncedRegionServerCallable<Long> callable = new NoncedRegionServerCallable<Long>((Connection)this.connection, this.getName(), row, this.rpcControllerFactory.newController(), -1){

            @Override
            protected Long rpcCall() throws Exception {
                ClientProtos.MutateRequest request = RequestConverter.buildIncrementRequest(this.getLocation().getRegionInfo().getRegionName(), row, family, qualifier, amount, durability, this.getNonceGroup(), this.getNonce());
                ClientProtos.MutateResponse response = this.doMutate(request);
                Result result = org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toResult(response.getResult(), this.getRpcControllerCellScanner());
                return Bytes.toLong((byte[])result.getValue(family, qualifier));
            }
        };
        return this.rpcCallerFactory.newCaller(this.writeRpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public boolean checkAndPut(final byte[] row, final byte[] family, final byte[] qualifier, final byte[] value, final Put put) throws IOException {
        ClientServiceCallable<Boolean> callable = new ClientServiceCallable<Boolean>((Connection)this.connection, this.getName(), row, (RpcController)this.rpcControllerFactory.newController(), put.getPriority()){

            @Override
            protected Boolean rpcCall() throws Exception {
                ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), HBaseProtos.CompareType.EQUAL, put);
                ClientProtos.MutateResponse response = this.doMutate(request);
                return response.getProcessed();
            }
        };
        return this.rpcCallerFactory.newCaller(this.writeRpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public boolean checkAndPut(final byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp compareOp, final byte[] value, final Put put) throws IOException {
        ClientServiceCallable<Boolean> callable = new ClientServiceCallable<Boolean>((Connection)this.connection, this.getName(), row, (RpcController)this.rpcControllerFactory.newController(), put.getPriority()){

            @Override
            protected Boolean rpcCall() throws Exception {
                HBaseProtos.CompareType compareType = HBaseProtos.CompareType.valueOf((String)compareOp.name());
                ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), compareType, put);
                ClientProtos.MutateResponse response = this.doMutate(request);
                return response.getProcessed();
            }
        };
        return this.rpcCallerFactory.newCaller(this.writeRpcTimeout).callWithRetries(callable, this.operationTimeout);
    }

    @Override
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.checkAndDelete(row, family, qualifier, CompareFilter.CompareOp.EQUAL, value, delete);
    }

    @Override
    public boolean checkAndDelete(final byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp compareOp, final byte[] value, final Delete delete) throws IOException {
        CancellableRegionServerCallable<SingleResponse> callable = new CancellableRegionServerCallable<SingleResponse>((Connection)this.connection, this.getName(), row, (RpcController)this.rpcControllerFactory.newController(), this.writeRpcTimeout, new RetryingTimeTracker().start(), delete.getPriority()){

            @Override
            protected SingleResponse rpcCall() throws Exception {
                HBaseProtos.CompareType compareType = HBaseProtos.CompareType.valueOf((String)compareOp.name());
                ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), compareType, delete);
                ClientProtos.MutateResponse response = this.doMutate(request);
                return ResponseConverter.getResult(request, response, this.getRpcControllerCellScanner());
            }
        };
        List<Delete> rows = Collections.singletonList(delete);
        Object[] results = new Object[1];
        AsyncProcessTask task = AsyncProcessTask.newBuilder().setPool(this.pool).setTableName(this.tableName).setRowAccess(rows).setCallable(callable).setRpcTimeout(Math.max(this.readRpcTimeout, this.writeRpcTimeout)).setOperationTimeout(this.operationTimeout).setSubmittedRows(AsyncProcessTask.SubmittedRows.ALL).setResults(results).build();
        AsyncRequestFuture ars = this.multiAp.submit(task);
        ars.waitUntilDone();
        if (ars.hasError()) {
            throw ars.getErrors();
        }
        return ((SingleResponse.Entry)results[0]).isProcessed();
    }

    @Override
    public boolean checkAndMutate(final byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp compareOp, final byte[] value, final RowMutations rm) throws IOException {
        CancellableRegionServerCallable<MultiResponse> callable = new CancellableRegionServerCallable<MultiResponse>((Connection)this.connection, this.getName(), rm.getRow(), (RpcController)this.rpcControllerFactory.newController(), this.writeRpcTimeout, new RetryingTimeTracker().start(), rm.getMaxPriority()){

            @Override
            protected MultiResponse rpcCall() throws Exception {
                HBaseProtos.CompareType compareType = HBaseProtos.CompareType.valueOf((String)compareOp.name());
                ClientProtos.MultiRequest request = RequestConverter.buildMutateRequest(this.getLocation().getRegionInfo().getRegionName(), row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), compareType, rm);
                ClientProtos.MultiResponse response = this.doMulti(request);
                ClientProtos.RegionActionResult res = (ClientProtos.RegionActionResult)response.getRegionActionResultList().get(0);
                if (res.hasException()) {
                    Throwable ex = org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.toException(res.getException());
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    throw new IOException("Failed to checkAndMutate row: " + Bytes.toStringBinary((byte[])rm.getRow()), ex);
                }
                return ResponseConverter.getResults(request, response, this.getRpcControllerCellScanner());
            }
        };
        Object[] results = new Object[rm.getMutations().size()];
        AsyncProcessTask task = AsyncProcessTask.newBuilder().setPool(this.pool).setTableName(this.tableName).setRowAccess(rm.getMutations()).setResults(results).setCallable(callable).setRpcTimeout(Math.max(this.readRpcTimeout, this.writeRpcTimeout)).setOperationTimeout(this.operationTimeout).setSubmittedRows(AsyncProcessTask.SubmittedRows.ALL).build();
        AsyncRequestFuture ars = this.multiAp.submit(task);
        ars.waitUntilDone();
        if (ars.hasError()) {
            throw ars.getErrors();
        }
        return ((Result)results[0]).getExists();
    }

    @Override
    public boolean exists(Get get) throws IOException {
        Result r = this.get(get, true);
        assert (r.getExists() != null);
        return r.getExists();
    }

    @Override
    public boolean[] existsAll(List<Get> gets) throws IOException {
        if (gets.isEmpty()) {
            return new boolean[0];
        }
        if (gets.size() == 1) {
            return new boolean[]{this.exists(gets.get(0))};
        }
        ArrayList<Get> exists = new ArrayList<Get>(gets.size());
        for (Get g : gets) {
            Get ge = new Get(g);
            ge.setCheckExistenceOnly(true);
            exists.add(ge);
        }
        Object[] r1 = new Object[exists.size()];
        try {
            this.batch(exists, r1, this.readRpcTimeout);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        boolean[] results = new boolean[r1.length];
        int i = 0;
        for (Object o : r1) {
            results[i++] = ((Result)o).getExists();
        }
        return results;
    }

    public <R> void processBatchCallback(List<? extends Row> list, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.batchCallback(list, results, callback);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.cleanupPoolOnClose) {
            this.pool.shutdown();
            try {
                boolean terminated = false;
                while (!(terminated = this.pool.awaitTermination(60L, TimeUnit.SECONDS))) {
                }
            }
            catch (InterruptedException e) {
                this.pool.shutdownNow();
                LOG.warn((Object)"waitForTermination interrupted");
            }
        }
        this.closed = true;
    }

    public void validatePut(Put put) throws IllegalArgumentException {
        HTable.validatePut(put, this.connConfiguration.getMaxKeyValueSize());
    }

    public static void validatePut(Put put, int maxKeyValueSize) throws IllegalArgumentException {
        if (put.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        if (maxKeyValueSize > 0) {
            for (List list : put.getFamilyCellMap().values()) {
                for (Cell cell : list) {
                    if (KeyValueUtil.length((Cell)cell) <= maxKeyValueSize) continue;
                    throw new IllegalArgumentException("KeyValue size too large");
                }
            }
        }
    }

    ExecutorService getPool() {
        return this.pool;
    }

    public void clearRegionCache() {
        this.connection.clearRegionCache();
    }

    @Override
    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return new RegionCoprocessorRpcChannel(this.connection, this.tableName, row);
    }

    @Override
    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        final Map results = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        this.coprocessorService(service, startKey, endKey, callable, new Batch.Callback<R>(){

            @Override
            public void update(byte[] region, byte[] row, R value) {
                if (region != null) {
                    results.put(region, value);
                }
            }
        });
        return results;
    }

    @Override
    public <T extends Service, R> void coprocessorService(final Class<T> service, byte[] startKey, byte[] endKey, final Batch.Call<T, R> callable, final Batch.Callback<R> callback) throws ServiceException, Throwable {
        List<byte[]> keys = this.getStartKeysInRange(startKey, endKey);
        TreeMap futures = new TreeMap(Bytes.BYTES_COMPARATOR);
        for (final byte[] byArray : keys) {
            final RegionCoprocessorRpcChannel channel = new RegionCoprocessorRpcChannel(this.connection, this.tableName, byArray);
            Future future = this.pool.submit(new Callable<R>(){

                @Override
                public R call() throws Exception {
                    Object instance = ProtobufUtil.newServiceStub(service, channel);
                    Object result = callable.call(instance);
                    byte[] region = channel.getLastRegion();
                    if (callback != null) {
                        callback.update(region, byArray, result);
                    }
                    return result;
                }
            });
            futures.put(byArray, future);
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                ((Future)entry.getValue()).get();
            }
            catch (ExecutionException ee) {
                LOG.warn((Object)("Error calling coprocessor service " + service.getName() + " for row " + Bytes.toStringBinary((byte[])((byte[])entry.getKey()))), (Throwable)ee);
                throw ee.getCause();
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("Interrupted calling coprocessor service " + service.getName() + " for row " + Bytes.toStringBinary((byte[])((byte[])entry.getKey()))).initCause(ie);
            }
        }
    }

    private List<byte[]> getStartKeysInRange(byte[] start, byte[] end) throws IOException {
        if (start == null) {
            start = HConstants.EMPTY_START_ROW;
        }
        if (end == null) {
            end = HConstants.EMPTY_END_ROW;
        }
        return (List)this.getKeysAndRegionsInRange(start, end, true).getFirst();
    }

    @Override
    @Deprecated
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    @Deprecated
    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    @Override
    @Deprecated
    public void setRpcTimeout(int rpcTimeout) {
        this.setReadRpcTimeout(rpcTimeout);
        this.setWriteRpcTimeout(rpcTimeout);
    }

    @Override
    public int getWriteRpcTimeout() {
        return this.writeRpcTimeout;
    }

    @Override
    @Deprecated
    public void setWriteRpcTimeout(int writeRpcTimeout) {
        this.writeRpcTimeout = writeRpcTimeout;
    }

    @Override
    public int getReadRpcTimeout() {
        return this.readRpcTimeout;
    }

    @Override
    @Deprecated
    public void setReadRpcTimeout(int readRpcTimeout) {
        this.readRpcTimeout = readRpcTimeout;
    }

    public String toString() {
        return this.tableName + ";" + this.connection;
    }

    @Override
    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        final Map results = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        this.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype, new Batch.Callback<R>(){

            @Override
            public void update(byte[] region, byte[] row, R result) {
                if (region != null) {
                    results.put(region, result);
                }
            }
        });
        return results;
    }

    @Override
    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        if (startKey == null) {
            startKey = HConstants.EMPTY_START_ROW;
        }
        if (endKey == null) {
            endKey = HConstants.EMPTY_END_ROW;
        }
        Pair<List<byte[]>, List<HRegionLocation>> keysAndRegions = this.getKeysAndRegionsInRange(startKey, endKey, true);
        List keys = (List)keysAndRegions.getFirst();
        List regions = (List)keysAndRegions.getSecond();
        if (keys.isEmpty()) {
            LOG.info((Object)("No regions were selected by key range start=" + Bytes.toStringBinary((byte[])startKey) + ", end=" + Bytes.toStringBinary((byte[])endKey)));
            return;
        }
        ArrayList<RegionCoprocessorServiceExec> execs = new ArrayList<RegionCoprocessorServiceExec>(keys.size());
        TreeMap<byte[], RegionCoprocessorServiceExec> execsByRow = new TreeMap<byte[], RegionCoprocessorServiceExec>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < keys.size(); ++i) {
            byte[] rowKey = (byte[])keys.get(i);
            byte[] region2 = ((HRegionLocation)regions.get(i)).getRegionInfo().getRegionName();
            RegionCoprocessorServiceExec exec = new RegionCoprocessorServiceExec(region2, rowKey, methodDescriptor, request);
            execs.add(exec);
            execsByRow.put(rowKey, exec);
        }
        ArrayList<Throwable> callbackErrorExceptions = new ArrayList<Throwable>();
        ArrayList<Row> callbackErrorActions = new ArrayList<Row>();
        ArrayList<String> callbackErrorServers = new ArrayList<String>();
        Object[] results = new Object[execs.size()];
        AsyncProcess asyncProcess = new AsyncProcess(this.connection, this.configuration, RpcRetryingCallerFactory.instantiate(this.configuration, this.connection.getStatisticsTracker()), true, RpcControllerFactory.instantiate(this.configuration));
        Batch.Callback<ClientProtos.CoprocessorServiceResult> resultsCallback = (region, row, serviceResult) -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Received result for endpoint " + methodDescriptor.getFullName() + ": region=" + Bytes.toStringBinary((byte[])region) + ", row=" + Bytes.toStringBinary((byte[])row) + ", value=" + serviceResult.getValue().getValue()));
            }
            try {
                Message.Builder builder = responsePrototype.newBuilderForType();
                ProtobufUtil.mergeFrom(builder, serviceResult.getValue().getValue().toByteArray());
                callback.update(region, row, builder.build());
            }
            catch (IOException e) {
                LOG.error((Object)("Unexpected response type from endpoint " + methodDescriptor.getFullName()), (Throwable)e);
                callbackErrorExceptions.add(e);
                callbackErrorActions.add((Row)execsByRow.get(row));
                callbackErrorServers.add("null");
            }
        };
        AsyncProcessTask<ClientProtos.CoprocessorServiceResult> task = AsyncProcessTask.newBuilder(resultsCallback).setPool(this.pool).setTableName(this.tableName).setRowAccess(execs).setResults(results).setRpcTimeout(this.readRpcTimeout).setOperationTimeout(this.operationTimeout).setSubmittedRows(AsyncProcessTask.SubmittedRows.ALL).build();
        AsyncRequestFuture future = asyncProcess.submit(task);
        future.waitUntilDone();
        if (future.hasError()) {
            throw future.getErrors();
        }
        if (!callbackErrorExceptions.isEmpty()) {
            throw new RetriesExhaustedWithDetailsException(callbackErrorExceptions, callbackErrorActions, callbackErrorServers);
        }
    }

    public RegionLocator getRegionLocator() {
        return this.locator;
    }
}

