/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.CancellableRegionServerCallable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.RetryingTimeTracker;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;

@InterfaceAudience.Private
class MultiServerCallable
extends CancellableRegionServerCallable<MultiResponse> {
    private MultiAction multiAction;
    private boolean cellBlock;

    MultiServerCallable(ClusterConnection connection, TableName tableName, ServerName location, MultiAction multi, RpcController rpcController, int rpcTimeout, RetryingTimeTracker tracker, int priority) {
        super(connection, tableName, null, rpcController, rpcTimeout, tracker, priority);
        this.multiAction = multi;
        this.location = new HRegionLocation(null, location);
        this.cellBlock = this.isCellBlock();
    }

    public void reset(ServerName location, MultiAction multiAction) {
        this.location = new HRegionLocation(null, location);
        this.multiAction = multiAction;
        this.cellBlock = this.isCellBlock();
    }

    @Override
    protected HRegionLocation getLocation() {
        throw new RuntimeException("Cannot get region location for multi-region request");
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        throw new RuntimeException("Cannot get region info for multi-region request");
    }

    MultiAction getMulti() {
        return this.multiAction;
    }

    @Override
    protected MultiResponse rpcCall() throws Exception {
        int countOfActions = this.multiAction.size();
        if (countOfActions <= 0) {
            throw new DoNotRetryIOException("No Actions");
        }
        ClientProtos.MultiRequest.Builder multiRequestBuilder = ClientProtos.MultiRequest.newBuilder();
        ClientProtos.RegionAction.Builder regionActionBuilder = ClientProtos.RegionAction.newBuilder();
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        ArrayList<CellScannable> cells = this.cellBlock ? new ArrayList<CellScannable>(countOfActions) : null;
        long nonceGroup = this.multiAction.getNonceGroup();
        if (nonceGroup != 0L) {
            multiRequestBuilder.setNonceGroup(nonceGroup);
        }
        int regionActionIndex = -1;
        HashMap<Integer, Integer> rowMutationsIndexMap = new HashMap<Integer, Integer>();
        for (Map.Entry<byte[], List<Action>> e : this.multiAction.actions.entrySet()) {
            byte[] regionName = e.getKey();
            List<Action> actions = e.getValue();
            regionActionBuilder.clear();
            regionActionBuilder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
            int rowMutations = 0;
            for (Action action : actions) {
                Row row = action.getAction();
                if (!(row instanceof RowMutations)) continue;
                RowMutations rms = (RowMutations)row;
                regionActionBuilder = this.cellBlock ? RequestConverter.buildNoDataRegionAction(regionName, rms, cells, regionActionBuilder, actionBuilder, mutationBuilder) : RequestConverter.buildRegionAction(regionName, rms);
                regionActionBuilder.setAtomic(true);
                multiRequestBuilder.addRegionAction(regionActionBuilder.build());
                rowMutationsIndexMap.put(++regionActionIndex, action.getOriginalIndex());
                ++rowMutations;
            }
            if (actions.size() <= rowMutations) continue;
            regionActionBuilder = this.cellBlock ? RequestConverter.buildNoDataRegionAction(regionName, actions, cells, regionActionBuilder, actionBuilder, mutationBuilder) : RequestConverter.buildRegionAction(regionName, actions, regionActionBuilder, actionBuilder, mutationBuilder);
            multiRequestBuilder.addRegionAction(regionActionBuilder.build());
            ++regionActionIndex;
        }
        if (cells != null) {
            this.setRpcControllerCellScanner(CellUtil.createCellScanner(cells));
        }
        ClientProtos.MultiRequest requestProto = multiRequestBuilder.build();
        ClientProtos.MultiResponse responseProto = ((ClientProtos.ClientService.BlockingInterface)this.getStub()).multi(this.getRpcController(), requestProto);
        if (responseProto == null) {
            return null;
        }
        return ResponseConverter.getResults(requestProto, rowMutationsIndexMap, responseProto, this.getRpcControllerCellScanner());
    }

    private boolean isCellBlock() {
        ClusterConnection conn = this.getConnection();
        return conn.hasCellBlockSupport();
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        this.setStub(this.getConnection().getClient(this.location.getServerName()));
    }

    @VisibleForTesting
    ServerName getServerName() {
        return this.location.getServerName();
    }
}

