/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="stub used by ipc")
public abstract class RegionAdminServiceCallable<T>
implements RetryingCallable<T> {
    protected AdminProtos.AdminService.BlockingInterface stub;
    protected final RpcControllerFactory rpcControllerFactory;
    private HBaseRpcController controller = null;
    protected final ClusterConnection connection;
    protected HRegionLocation location;
    protected final TableName tableName;
    protected final byte[] row;
    protected final int replicaId;

    public RegionAdminServiceCallable(ClusterConnection connection, RpcControllerFactory rpcControllerFactory, TableName tableName, byte[] row) {
        this(connection, rpcControllerFactory, null, tableName, row);
    }

    public RegionAdminServiceCallable(ClusterConnection connection, RpcControllerFactory rpcControllerFactory, HRegionLocation location, TableName tableName, byte[] row) {
        this(connection, rpcControllerFactory, location, tableName, row, 0);
    }

    public RegionAdminServiceCallable(ClusterConnection connection, RpcControllerFactory rpcControllerFactory, HRegionLocation location, TableName tableName, byte[] row, int replicaId) {
        this.connection = connection;
        this.rpcControllerFactory = rpcControllerFactory;
        this.location = location;
        this.tableName = tableName;
        this.row = row;
        this.replicaId = replicaId;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        if (reload || this.location == null) {
            this.location = this.getLocation(!reload);
        }
        if (this.location == null) {
            throw new HBaseIOException(this.getExceptionMessage());
        }
        this.setStub(this.connection.getAdmin(this.location.getServerName()));
    }

    protected void setStub(AdminProtos.AdminService.BlockingInterface stub) {
        this.stub = stub;
    }

    public HRegionLocation getLocation(boolean useCache) throws IOException {
        RegionLocations rl = RegionAdminServiceCallable.getRegionLocations(this.connection, this.tableName, this.row, useCache, this.replicaId);
        if (rl == null) {
            throw new HBaseIOException(this.getExceptionMessage());
        }
        HRegionLocation location = rl.getRegionLocation(this.replicaId);
        if (location == null) {
            throw new HBaseIOException(this.getExceptionMessage());
        }
        return location;
    }

    @Override
    public void throwable(Throwable t, boolean retrying) {
        if (this.location != null) {
            this.connection.updateCachedLocations(this.tableName, this.location.getRegionInfo().getRegionName(), this.row, t, this.location.getServerName());
        }
    }

    Connection getConnection() {
        return this.connection;
    }

    protected String getExceptionMessage() {
        return "There is no location table=" + this.tableName + " ,replica=" + this.replicaId + ", row=" + Bytes.toStringBinary((byte[])this.row);
    }

    @Override
    public String getExceptionMessageAdditionalDetail() {
        return null;
    }

    @Override
    public long sleep(long pause, int tries) {
        return ConnectionUtils.getPauseTime(pause, tries);
    }

    public static RegionLocations getRegionLocations(ClusterConnection connection, TableName tableName, byte[] row, boolean useCache, int replicaId) throws RetriesExhaustedException, DoNotRetryIOException, InterruptedIOException {
        RegionLocations rl;
        try {
            rl = connection.locateRegion(tableName, row, useCache, true, replicaId);
        }
        catch (DoNotRetryIOException e) {
            throw e;
        }
        catch (RetriesExhaustedException e) {
            throw e;
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RetriesExhaustedException("Can't get the location", e);
        }
        if (rl == null) {
            throw new RetriesExhaustedException("Can't get the locations");
        }
        return rl;
    }

    @Override
    public T call(int callTimeout) throws IOException {
        this.controller = this.rpcControllerFactory.newController();
        this.controller.setPriority(this.tableName);
        this.controller.setCallTimeout(callTimeout);
        try {
            return this.call(this.controller);
        }
        catch (Exception e) {
            throw ProtobufUtil.handleRemoteException(e);
        }
    }

    HBaseRpcController getCurrentPayloadCarryingRpcController() {
        return this.controller;
    }

    protected abstract T call(HBaseRpcController var1) throws Exception;
}

