/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ClientCoprocessorRpcController;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;

@InterfaceAudience.Private
public class RegionServerCoprocessorRpcChannelImpl
implements RpcChannel {
    AsyncRpcRetryingCallerFactory.ServerRequestCallerBuilder<Message> callerBuilder;

    RegionServerCoprocessorRpcChannelImpl(AsyncRpcRetryingCallerFactory.ServerRequestCallerBuilder<Message> callerBuilder) {
        this.callerBuilder = callerBuilder;
    }

    private CompletableFuture<Message> rpcCall(Descriptors.MethodDescriptor method, Message request, final Message responsePrototype, final HBaseRpcController controller, ClientProtos.ClientService.Interface stub) {
        final CompletableFuture<Message> future = new CompletableFuture<Message>();
        ClientProtos.CoprocessorServiceRequest csr = CoprocessorRpcUtils.getCoprocessorServiceRequest(method, request);
        stub.execRegionServerService((org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController)controller, csr, (org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback)new org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback<ClientProtos.CoprocessorServiceResponse>(){

            public void run(ClientProtos.CoprocessorServiceResponse resp) {
                if (controller.failed()) {
                    future.completeExceptionally(controller.getFailed());
                } else {
                    try {
                        future.complete(CoprocessorRpcUtils.getResponse(resp, responsePrototype));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            }
        });
        return future;
    }

    public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> done) {
        this.callerBuilder.action((c, s) -> this.rpcCall(method, request, responsePrototype, c, s)).call().whenComplete((r, e) -> {
            if (e != null) {
                ((ClientCoprocessorRpcController)controller).setFailed((Throwable)e);
            }
            done.run(r);
        });
    }
}

