/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;

@InterfaceAudience.Public
abstract class SyncCoprocessorRpcChannel
implements CoprocessorRpcChannel {
    private static final Log LOG = LogFactory.getLog(SyncCoprocessorRpcChannel.class);

    SyncCoprocessorRpcChannel() {
    }

    @InterfaceAudience.Private
    public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> callback) {
        Message response = null;
        try {
            response = this.callExecService(controller, method, request, responsePrototype);
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Call failed on IOException", (Throwable)ioe);
            CoprocessorRpcUtils.setControllerException(controller, ioe);
        }
        if (callback != null) {
            callback.run((Object)response);
        }
    }

    @InterfaceAudience.Private
    public Message callBlockingMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype) throws ServiceException {
        try {
            return this.callExecService(controller, method, request, responsePrototype);
        }
        catch (IOException ioe) {
            throw new ServiceException("Error calling method " + method.getFullName(), (Throwable)ioe);
        }
    }

    protected abstract Message callExecService(RpcController var1, Descriptors.MethodDescriptor var2, Message var3, Message var4) throws IOException;
}

