/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;

@InterfaceAudience.Private
@InterfaceStability.Stable
public final class ReplicationSerDeHelper {
    private static final Log LOG = LogFactory.getLog(ReplicationSerDeHelper.class);

    private ReplicationSerDeHelper() {
    }

    public static String convertToString(Set<String> namespaces) {
        if (namespaces == null) {
            return null;
        }
        return StringUtils.join(namespaces, (char)';');
    }

    public static ReplicationProtos.TableCF[] convert(Map<TableName, ? extends Collection<String>> tableCfs) {
        if (tableCfs == null) {
            return null;
        }
        ArrayList<ReplicationProtos.TableCF> tableCFList = new ArrayList<ReplicationProtos.TableCF>(tableCfs.entrySet().size());
        ReplicationProtos.TableCF.Builder tableCFBuilder = ReplicationProtos.TableCF.newBuilder();
        for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
            tableCFBuilder.clear();
            tableCFBuilder.setTableName(ProtobufUtil.toProtoTableName(entry.getKey()));
            Collection<String> v = entry.getValue();
            if (v != null && !v.isEmpty()) {
                for (String value : entry.getValue()) {
                    tableCFBuilder.addFamilies(ByteString.copyFromUtf8((String)value));
                }
            }
            tableCFList.add(tableCFBuilder.build());
        }
        return tableCFList.toArray(new ReplicationProtos.TableCF[tableCFList.size()]);
    }

    public static String convertToString(Map<TableName, ? extends Collection<String>> tableCfs) {
        if (tableCfs == null) {
            return null;
        }
        return ReplicationSerDeHelper.convert(ReplicationSerDeHelper.convert(tableCfs));
    }

    public static ReplicationProtos.TableCF[] convert(String tableCFsConfig) {
        if (tableCFsConfig == null || tableCFsConfig.trim().length() == 0) {
            return null;
        }
        ReplicationProtos.TableCF.Builder tableCFBuilder = ReplicationProtos.TableCF.newBuilder();
        String[] tables = tableCFsConfig.split(";");
        ArrayList<ReplicationProtos.TableCF> tableCFList = new ArrayList<ReplicationProtos.TableCF>(tables.length);
        for (String tab : tables) {
            if ((tab = tab.trim()).length() == 0) continue;
            String[] pair = tab.split(":");
            String tabName = pair[0].trim();
            if (pair.length > 2 || tabName.length() == 0) {
                LOG.info((Object)("incorrect format:" + tableCFsConfig));
                continue;
            }
            tableCFBuilder.clear();
            String ns = "default";
            String tName = tabName;
            String[] dbs = tabName.split("\\.");
            if (dbs != null && dbs.length == 2) {
                ns = dbs[0];
                tName = dbs[1];
            }
            tableCFBuilder.setTableName(ProtobufUtil.toProtoTableName(TableName.valueOf((String)ns, (String)tName)));
            if (pair.length == 2) {
                String[] cfsList;
                for (String cf : cfsList = pair[1].split(",")) {
                    String cfName = cf.trim();
                    if (cfName.length() <= 0) continue;
                    tableCFBuilder.addFamilies(ByteString.copyFromUtf8((String)cfName));
                }
            }
            tableCFList.add(tableCFBuilder.build());
        }
        return tableCFList.toArray(new ReplicationProtos.TableCF[tableCFList.size()]);
    }

    public static String convert(ReplicationProtos.TableCF[] tableCFs) {
        StringBuilder sb = new StringBuilder();
        for (ReplicationProtos.TableCF tableCF : tableCFs) {
            String namespace = tableCF.getTableName().getNamespace().toStringUtf8();
            if (!Strings.isEmpty((String)namespace)) {
                sb.append(namespace).append(".").append(tableCF.getTableName().getQualifier().toStringUtf8()).append(":");
            } else {
                sb.append(tableCF.getTableName().toString()).append(":");
            }
            for (int j = 0; j < tableCF.getFamiliesCount(); ++j) {
                sb.append(tableCF.getFamilies(j).toStringUtf8()).append(",");
            }
            sb.deleteCharAt(sb.length() - 1).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static ReplicationProtos.TableCF getTableCF(ReplicationProtos.TableCF[] tableCFs, String table) {
        for (ReplicationProtos.TableCF tableCF : tableCFs) {
            if (!tableCF.getTableName().getQualifier().toStringUtf8().equals(table)) continue;
            return tableCF;
        }
        return null;
    }

    public static ReplicationProtos.TableCF[] parseTableCFs(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return ReplicationSerDeHelper.convert(Bytes.toString((byte[])bytes));
    }

    public static Map<TableName, List<String>> parseTableCFsFromConfig(String tableCFsConfig) {
        ReplicationProtos.TableCF[] tableCFs = ReplicationSerDeHelper.convert(tableCFsConfig);
        return ReplicationSerDeHelper.convert2Map(tableCFs);
    }

    public static Map<TableName, List<String>> convert2Map(ReplicationProtos.TableCF[] tableCFs) {
        if (tableCFs == null || tableCFs.length == 0) {
            return null;
        }
        HashMap<TableName, List<String>> tableCFsMap = new HashMap<TableName, List<String>>();
        for (ReplicationProtos.TableCF tableCF : tableCFs) {
            ArrayList<String> families = new ArrayList<String>();
            int m = tableCF.getFamiliesCount();
            for (int j = 0; j < m; ++j) {
                families.add(tableCF.getFamilies(j).toStringUtf8());
            }
            if (families.size() > 0) {
                tableCFsMap.put(ProtobufUtil.toTableName(tableCF.getTableName()), families);
                continue;
            }
            tableCFsMap.put(ProtobufUtil.toTableName(tableCF.getTableName()), null);
        }
        return tableCFsMap;
    }

    public static ReplicationPeerConfig parsePeerFrom(byte[] bytes) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(bytes)) {
            ReplicationProtos.ReplicationPeer peer;
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ReplicationProtos.ReplicationPeer.Builder builder = ReplicationProtos.ReplicationPeer.newBuilder();
            try {
                ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen, bytes.length - pblen);
                peer = builder.build();
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
            return ReplicationSerDeHelper.convert(peer);
        }
        if (bytes.length > 0) {
            return new ReplicationPeerConfig().setClusterKey(Bytes.toString((byte[])bytes));
        }
        return new ReplicationPeerConfig().setClusterKey("");
    }

    public static ReplicationPeerConfig convert(ReplicationProtos.ReplicationPeer peer) {
        List namespacesList;
        ReplicationPeerConfig peerConfig = new ReplicationPeerConfig();
        if (peer.hasClusterkey()) {
            peerConfig.setClusterKey(peer.getClusterkey());
        }
        if (peer.hasReplicationEndpointImpl()) {
            peerConfig.setReplicationEndpointImpl(peer.getReplicationEndpointImpl());
        }
        for (HBaseProtos.BytesBytesPair pair : peer.getDataList()) {
            peerConfig.getPeerData().put(pair.getFirst().toByteArray(), pair.getSecond().toByteArray());
        }
        for (HBaseProtos.BytesBytesPair pair : peer.getConfigurationList()) {
            peerConfig.getConfiguration().put(pair.getName(), pair.getValue());
        }
        Map<TableName, List<String>> tableCFsMap = ReplicationSerDeHelper.convert2Map(peer.getTableCfsList().toArray(new ReplicationProtos.TableCF[peer.getTableCfsCount()]));
        if (tableCFsMap != null) {
            peerConfig.setTableCFsMap(tableCFsMap);
        }
        if ((namespacesList = peer.getNamespacesList()) != null && namespacesList.size() != 0) {
            HashSet<String> namespaces = new HashSet<String>();
            for (ByteString namespace : namespacesList) {
                namespaces.add(namespace.toStringUtf8());
            }
            peerConfig.setNamespaces(namespaces);
        }
        if (peer.hasBandwidth()) {
            peerConfig.setBandwidth(peer.getBandwidth());
        }
        return peerConfig;
    }

    /*
     * WARNING - void declaration
     */
    public static ReplicationProtos.ReplicationPeer convert(ReplicationPeerConfig peerConfig) {
        Set<String> set;
        ReplicationProtos.ReplicationPeer.Builder builder = ReplicationProtos.ReplicationPeer.newBuilder();
        if (peerConfig.getClusterKey() != null) {
            builder.setClusterkey(peerConfig.getClusterKey());
        }
        if (peerConfig.getReplicationEndpointImpl() != null) {
            builder.setReplicationEndpointImpl(peerConfig.getReplicationEndpointImpl());
        }
        for (Map.Entry<byte[], byte[]> entry : peerConfig.getPeerData().entrySet()) {
            builder.addData(HBaseProtos.BytesBytesPair.newBuilder().setFirst(UnsafeByteOperations.unsafeWrap((byte[])entry.getKey())).setSecond(UnsafeByteOperations.unsafeWrap((byte[])entry.getValue())).build());
        }
        for (Map.Entry<Object, Object> entry : peerConfig.getConfiguration().entrySet()) {
            builder.addConfiguration(HBaseProtos.NameStringPair.newBuilder().setName((String)entry.getKey()).setValue((String)entry.getValue()).build());
        }
        ReplicationProtos.TableCF[] tableCFs = ReplicationSerDeHelper.convert(peerConfig.getTableCFsMap());
        if (tableCFs != null) {
            void var3_7;
            boolean bl = false;
            while (var3_7 < tableCFs.length) {
                builder.addTableCfs(tableCFs[var3_7]);
                ++var3_7;
            }
        }
        if ((set = peerConfig.getNamespaces()) != null) {
            for (String namespace : set) {
                builder.addNamespaces(ByteString.copyFromUtf8((String)namespace));
            }
        }
        builder.setBandwidth(peerConfig.getBandwidth());
        return builder.build();
    }

    public static byte[] toByteArray(ReplicationPeerConfig peerConfig) {
        byte[] bytes = ReplicationSerDeHelper.convert(peerConfig).toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    public static ReplicationPeerDescription toReplicationPeerDescription(ReplicationProtos.ReplicationPeerDescription desc) {
        boolean enabled = ReplicationProtos.ReplicationState.State.ENABLED == desc.getState().getState();
        ReplicationPeerConfig config = ReplicationSerDeHelper.convert(desc.getConfig());
        return new ReplicationPeerDescription(desc.getId(), enabled, config);
    }

    public static ReplicationProtos.ReplicationPeerDescription toProtoReplicationPeerDescription(ReplicationPeerDescription desc) {
        ReplicationProtos.ReplicationPeerDescription.Builder builder = ReplicationProtos.ReplicationPeerDescription.newBuilder();
        builder.setId(desc.getPeerId());
        ReplicationProtos.ReplicationState.Builder stateBuilder = ReplicationProtos.ReplicationState.newBuilder();
        stateBuilder.setState(desc.isEnabled() ? ReplicationProtos.ReplicationState.State.ENABLED : ReplicationProtos.ReplicationState.State.DISABLED);
        builder.setState(stateBuilder.build());
        builder.setConfig(ReplicationSerDeHelper.convert(desc.getPeerConfig()));
        return builder.build();
    }

    public static void appendTableCFsToReplicationPeerConfig(Map<TableName, ? extends Collection<String>> tableCfs, ReplicationPeerConfig peerConfig) {
        Map<TableName, List<String>> preTableCfs = peerConfig.getTableCFsMap();
        if (preTableCfs == null) {
            peerConfig.setTableCFsMap(tableCfs);
        } else {
            for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
                TableName table = entry.getKey();
                Collection<String> appendCfs = entry.getValue();
                if (preTableCfs.containsKey(table)) {
                    List<String> cfs = preTableCfs.get(table);
                    if (cfs == null || appendCfs == null || appendCfs.isEmpty()) {
                        preTableCfs.put(table, null);
                        continue;
                    }
                    HashSet<String> cfSet = new HashSet<String>(cfs);
                    cfSet.addAll(appendCfs);
                    preTableCfs.put(table, Lists.newArrayList(cfSet));
                    continue;
                }
                if (appendCfs == null || appendCfs.isEmpty()) {
                    preTableCfs.put(table, null);
                    continue;
                }
                preTableCfs.put(table, Lists.newArrayList(appendCfs));
            }
        }
    }

    public static void removeTableCFsFromReplicationPeerConfig(Map<TableName, ? extends Collection<String>> tableCfs, ReplicationPeerConfig peerConfig, String id) throws ReplicationException {
        Map<TableName, List<String>> preTableCfs = peerConfig.getTableCFsMap();
        if (preTableCfs == null) {
            throw new ReplicationException("Table-Cfs for peer: " + id + " is null");
        }
        for (Map.Entry<TableName, ? extends Collection<String>> entry : tableCfs.entrySet()) {
            TableName table = entry.getKey();
            Collection<String> removeCfs = entry.getValue();
            if (preTableCfs.containsKey(table)) {
                List<String> cfs = preTableCfs.get(table);
                if (cfs == null && (removeCfs == null || removeCfs.isEmpty())) {
                    preTableCfs.remove(table);
                    continue;
                }
                if (cfs != null && removeCfs != null && !removeCfs.isEmpty()) {
                    HashSet<String> cfSet = new HashSet<String>(cfs);
                    cfSet.removeAll(removeCfs);
                    if (cfSet.isEmpty()) {
                        preTableCfs.remove(table);
                        continue;
                    }
                    preTableCfs.put(table, Lists.newArrayList(cfSet));
                    continue;
                }
                if (cfs == null && removeCfs != null && !removeCfs.isEmpty()) {
                    throw new ReplicationException("Cannot remove cf of table: " + table + " which doesn't specify cfs from table-cfs config in peer: " + id);
                }
                if (cfs == null || removeCfs != null && !removeCfs.isEmpty()) continue;
                throw new ReplicationException("Cannot remove table: " + table + " which has specified cfs from table-cfs config in peer: " + id);
            }
            throw new ReplicationException("No table: " + table + " in table-cfs config of peer: " + id);
        }
    }
}

