/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;

@InterfaceAudience.Public
public class PageFilter
extends FilterBase {
    private long pageSize = Long.MAX_VALUE;
    private int rowsAccepted = 0;

    public PageFilter(long pageSize) {
        Preconditions.checkArgument((pageSize >= 0L ? 1 : 0) != 0, (String)"must be positive %s", (long)pageSize);
        this.pageSize = pageSize;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return this.filterAllRemaining();
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public boolean filterAllRemaining() {
        return (long)this.rowsAccepted >= this.pageSize;
    }

    @Override
    public boolean filterRow() {
        ++this.rowsAccepted;
        return (long)this.rowsAccepted > this.pageSize;
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 but got: %s", (int)filterArguments.size());
        long pageSize = ParseFilter.convertByteArrayToLong(filterArguments.get(0));
        return new PageFilter(pageSize);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.PageFilter.Builder builder = FilterProtos.PageFilter.newBuilder();
        builder.setPageSize(this.pageSize);
        return builder.build().toByteArray();
    }

    public static PageFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.PageFilter proto;
        try {
            proto = FilterProtos.PageFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        return new PageFilter(proto.getPageSize());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageFilter)) {
            return false;
        }
        PageFilter other = (PageFilter)o;
        return this.getPageSize() == other.getPageSize();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.pageSize;
    }
}

