/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.InetSocketAddress;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.User;

@InterfaceAudience.Private
class ConnectionId {
    private static final int PRIME = 16777619;
    final User ticket;
    final String serviceName;
    final InetSocketAddress address;

    public ConnectionId(User ticket, String serviceName, InetSocketAddress address) {
        this.address = address;
        this.ticket = ticket;
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public User getTicket() {
        return this.ticket;
    }

    public String toString() {
        return this.address.toString() + "/" + this.serviceName + "/" + this.ticket;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionId) {
            ConnectionId id = (ConnectionId)obj;
            return this.address.equals(id.address) && (this.ticket != null && this.ticket.equals((Object)id.ticket) || this.ticket == id.ticket) && this.serviceName == id.serviceName;
        }
        return false;
    }

    public int hashCode() {
        return ConnectionId.hashCode(this.ticket, this.serviceName, this.address);
    }

    public static int hashCode(User ticket, String serviceName, InetSocketAddress address) {
        return address.hashCode() + 16777619 * (16777619 * serviceName.hashCode() ^ (ticket == null ? 0 : ticket.hashCode()));
    }
}

