/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Date;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;

@InterfaceAudience.Private
public class RegionState {
    private final long stamp;
    private final HRegionInfo hri;
    private final ServerName serverName;
    private final State state;
    private long ritDuration;

    public RegionState(HRegionInfo region, State state) {
        this(region, state, System.currentTimeMillis(), null);
    }

    public RegionState(HRegionInfo region, State state, ServerName serverName) {
        this(region, state, System.currentTimeMillis(), serverName);
    }

    public RegionState(HRegionInfo region, State state, long stamp, ServerName serverName) {
        this(region, state, stamp, serverName, 0L);
    }

    public RegionState(HRegionInfo region, State state, long stamp, ServerName serverName, long ritDuration) {
        this.hri = region;
        this.state = state;
        this.stamp = stamp;
        this.serverName = serverName;
        this.ritDuration = ritDuration;
    }

    public State getState() {
        return this.state;
    }

    public long getStamp() {
        return this.stamp;
    }

    public HRegionInfo getRegion() {
        return this.hri;
    }

    public ServerName getServerName() {
        return this.serverName;
    }

    public long getRitDuration() {
        return this.ritDuration;
    }

    @InterfaceAudience.Private
    void updateRitDuration(long previousStamp) {
        this.ritDuration += this.stamp - previousStamp;
    }

    public boolean isClosing() {
        return this.state == State.CLOSING;
    }

    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public boolean isOpening() {
        return this.state == State.OPENING;
    }

    public boolean isOpened() {
        return this.state == State.OPEN;
    }

    public boolean isOffline() {
        return this.state == State.OFFLINE;
    }

    public boolean isSplitting() {
        return this.state == State.SPLITTING;
    }

    public boolean isSplit() {
        return this.state == State.SPLIT;
    }

    public boolean isSplittingNew() {
        return this.state == State.SPLITTING_NEW;
    }

    public boolean isFailedOpen() {
        return this.state == State.FAILED_OPEN;
    }

    public boolean isFailedClose() {
        return this.state == State.FAILED_CLOSE;
    }

    public boolean isMerging() {
        return this.state == State.MERGING;
    }

    public boolean isMerged() {
        return this.state == State.MERGED;
    }

    public boolean isMergingNew() {
        return this.state == State.MERGING_NEW;
    }

    public boolean isOnServer(ServerName sn) {
        return this.serverName != null && this.serverName.equals((Object)sn);
    }

    public boolean isMergingOnServer(ServerName sn) {
        return this.isOnServer(sn) && this.isMerging();
    }

    public boolean isMergingNewOnServer(ServerName sn) {
        return this.isOnServer(sn) && this.isMergingNew();
    }

    public boolean isMergingNewOrOpenedOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isMergingNew() || this.isOpened());
    }

    public boolean isMergingNewOrOfflineOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isMergingNew() || this.isOffline());
    }

    public boolean isSplittingOnServer(ServerName sn) {
        return this.isOnServer(sn) && this.isSplitting();
    }

    public boolean isSplittingNewOnServer(ServerName sn) {
        return this.isOnServer(sn) && this.isSplittingNew();
    }

    public boolean isSplittingOrOpenedOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isSplitting() || this.isOpened());
    }

    public boolean isSplittingOrSplitOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isSplitting() || this.isSplit());
    }

    public boolean isClosingOrClosedOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isClosing() || this.isClosed());
    }

    public boolean isOpeningOrFailedOpenOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isOpening() || this.isFailedOpen());
    }

    public boolean isOpeningOrOpenedOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isOpening() || this.isOpened());
    }

    public boolean isOpenedOnServer(ServerName sn) {
        return this.isOnServer(sn) && this.isOpened();
    }

    public boolean isReadyToOffline() {
        return this.isMerged() || this.isSplit() || this.isOffline() || this.isSplittingNew() || this.isMergingNew();
    }

    public boolean isReadyToOnline() {
        return this.isOpened() || this.isSplittingNew() || this.isMergingNew();
    }

    public boolean isUnassignable() {
        return RegionState.isUnassignable(this.state);
    }

    public static boolean isUnassignable(State state) {
        return state == State.MERGED || state == State.SPLIT || state == State.OFFLINE || state == State.SPLITTING_NEW || state == State.MERGING_NEW;
    }

    public String toString() {
        return "{" + this.hri.getShortNameToLog() + " state=" + (Object)((Object)this.state) + ", ts=" + this.stamp + ", server=" + this.serverName + "}";
    }

    public String toDescriptiveString() {
        long relTime = System.currentTimeMillis() - this.stamp;
        return this.hri.getRegionNameAsString() + " state=" + (Object)((Object)this.state) + ", ts=" + new Date(this.stamp) + " (" + relTime / 1000L + "s ago), server=" + this.serverName;
    }

    public ClusterStatusProtos.RegionState convert() {
        ClusterStatusProtos.RegionState.Builder regionState = ClusterStatusProtos.RegionState.newBuilder();
        regionState.setRegionInfo(HRegionInfo.convert(this.hri));
        regionState.setState(this.state.convert());
        regionState.setStamp(this.getStamp());
        return regionState.build();
    }

    public static RegionState convert(ClusterStatusProtos.RegionState proto) {
        return new RegionState(HRegionInfo.convert(proto.getRegionInfo()), State.convert(proto.getState()), proto.getStamp(), null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegionState tmp = (RegionState)obj;
        return tmp.hri.equals(this.hri) && tmp.state == this.state && (this.serverName != null && this.serverName.equals((Object)tmp.serverName) || tmp.serverName == null && this.serverName == null);
    }

    public int hashCode() {
        return (this.serverName != null ? this.serverName.hashCode() * 11 : 0) + this.hri.hashCode() + 5 * this.state.ordinal();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static enum State {
        OFFLINE,
        OPENING,
        OPEN,
        CLOSING,
        CLOSED,
        SPLITTING,
        SPLIT,
        FAILED_OPEN,
        FAILED_CLOSE,
        MERGING,
        MERGED,
        SPLITTING_NEW,
        MERGING_NEW;


        public ClusterStatusProtos.RegionState.State convert() {
            ClusterStatusProtos.RegionState.State rs;
            switch (this) {
                case OFFLINE: {
                    rs = ClusterStatusProtos.RegionState.State.OFFLINE;
                    break;
                }
                case OPENING: {
                    rs = ClusterStatusProtos.RegionState.State.OPENING;
                    break;
                }
                case OPEN: {
                    rs = ClusterStatusProtos.RegionState.State.OPEN;
                    break;
                }
                case CLOSING: {
                    rs = ClusterStatusProtos.RegionState.State.CLOSING;
                    break;
                }
                case CLOSED: {
                    rs = ClusterStatusProtos.RegionState.State.CLOSED;
                    break;
                }
                case SPLITTING: {
                    rs = ClusterStatusProtos.RegionState.State.SPLITTING;
                    break;
                }
                case SPLIT: {
                    rs = ClusterStatusProtos.RegionState.State.SPLIT;
                    break;
                }
                case FAILED_OPEN: {
                    rs = ClusterStatusProtos.RegionState.State.FAILED_OPEN;
                    break;
                }
                case FAILED_CLOSE: {
                    rs = ClusterStatusProtos.RegionState.State.FAILED_CLOSE;
                    break;
                }
                case MERGING: {
                    rs = ClusterStatusProtos.RegionState.State.MERGING;
                    break;
                }
                case MERGED: {
                    rs = ClusterStatusProtos.RegionState.State.MERGED;
                    break;
                }
                case SPLITTING_NEW: {
                    rs = ClusterStatusProtos.RegionState.State.SPLITTING_NEW;
                    break;
                }
                case MERGING_NEW: {
                    rs = ClusterStatusProtos.RegionState.State.MERGING_NEW;
                    break;
                }
                default: {
                    throw new IllegalStateException("");
                }
            }
            return rs;
        }

        public static State convert(ClusterStatusProtos.RegionState.State protoState) {
            State state;
            switch (protoState) {
                case OFFLINE: {
                    state = OFFLINE;
                    break;
                }
                case PENDING_OPEN: 
                case OPENING: {
                    state = OPENING;
                    break;
                }
                case OPEN: {
                    state = OPEN;
                    break;
                }
                case PENDING_CLOSE: 
                case CLOSING: {
                    state = CLOSING;
                    break;
                }
                case CLOSED: {
                    state = CLOSED;
                    break;
                }
                case SPLITTING: {
                    state = SPLITTING;
                    break;
                }
                case SPLIT: {
                    state = SPLIT;
                    break;
                }
                case FAILED_OPEN: {
                    state = FAILED_OPEN;
                    break;
                }
                case FAILED_CLOSE: {
                    state = FAILED_CLOSE;
                    break;
                }
                case MERGING: {
                    state = MERGING;
                    break;
                }
                case MERGED: {
                    state = MERGED;
                    break;
                }
                case SPLITTING_NEW: {
                    state = SPLITTING_NEW;
                    break;
                }
                case MERGING_NEW: {
                    state = MERGING_NEW;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled state " + protoState);
                }
            }
            return state;
        }
    }
}

