/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Objects;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class SpaceQuotaSnapshot {
    private static final SpaceQuotaSnapshot NO_SUCH_SNAPSHOT = new SpaceQuotaSnapshot(SpaceQuotaStatus.notInViolation(), 0L, Long.MAX_VALUE);
    private final SpaceQuotaStatus quotaStatus;
    private final long usage;
    private final long limit;

    public SpaceQuotaSnapshot(SpaceQuotaStatus quotaStatus, long usage, long limit) {
        this.quotaStatus = Objects.requireNonNull(quotaStatus);
        this.usage = usage;
        this.limit = limit;
    }

    public SpaceQuotaStatus getQuotaStatus() {
        return this.quotaStatus;
    }

    public long getUsage() {
        return this.usage;
    }

    public long getLimit() {
        return this.limit;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.quotaStatus.hashCode()).append(this.usage).append(this.limit).toHashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SpaceQuotaSnapshot) {
            SpaceQuotaSnapshot other = (SpaceQuotaSnapshot)o;
            return this.quotaStatus.equals(other.quotaStatus) && this.usage == other.usage && this.limit == other.limit;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("SpaceQuotaSnapshot[policy=").append(this.quotaStatus).append(", use=");
        sb.append(StringUtils.byteDesc((long)this.usage)).append("/");
        sb.append(StringUtils.byteDesc((long)this.limit)).append("]");
        return sb.toString();
    }

    public static SpaceQuotaSnapshot toSpaceQuotaSnapshot(QuotaProtos.SpaceQuotaSnapshot proto) {
        return new SpaceQuotaSnapshot(SpaceQuotaStatus.toStatus(proto.getQuotaStatus()), proto.getQuotaUsage(), proto.getQuotaLimit());
    }

    public static QuotaProtos.SpaceQuotaSnapshot toProtoSnapshot(SpaceQuotaSnapshot snapshot) {
        return QuotaProtos.SpaceQuotaSnapshot.newBuilder().setQuotaStatus(SpaceQuotaStatus.toProto(snapshot.getQuotaStatus())).setQuotaUsage(snapshot.getUsage()).setQuotaLimit(snapshot.getLimit()).build();
    }

    public static SpaceQuotaSnapshot getNoSuchSnapshot() {
        return NO_SUCH_SNAPSHOT;
    }

    @InterfaceAudience.Private
    public static class SpaceQuotaStatus {
        private static final SpaceQuotaStatus NOT_IN_VIOLATION = new SpaceQuotaStatus(null, false);
        final SpaceViolationPolicy policy;
        final boolean inViolation;

        public SpaceQuotaStatus(SpaceViolationPolicy policy) {
            this(Objects.requireNonNull(policy), true);
        }

        private SpaceQuotaStatus(SpaceViolationPolicy policy, boolean inViolation) {
            this.policy = policy;
            this.inViolation = inViolation;
        }

        public SpaceViolationPolicy getPolicy() {
            return this.policy;
        }

        public boolean isInViolation() {
            return this.inViolation;
        }

        public static SpaceQuotaStatus notInViolation() {
            return NOT_IN_VIOLATION;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.policy == null ? 0 : this.policy.hashCode()).append(this.inViolation).toHashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof SpaceQuotaStatus) {
                SpaceQuotaStatus other = (SpaceQuotaStatus)o;
                return Objects.equals((Object)this.policy, (Object)other.policy) && this.inViolation == other.inViolation;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
            sb.append("[policy=").append((Object)this.policy);
            sb.append(", inViolation=").append(this.inViolation).append("]");
            return sb.toString();
        }

        public static QuotaProtos.SpaceQuotaStatus toProto(SpaceQuotaStatus status) {
            QuotaProtos.SpaceQuotaStatus.Builder builder = QuotaProtos.SpaceQuotaStatus.newBuilder();
            builder.setInViolation(status.inViolation);
            if (status.isInViolation()) {
                builder.setViolationPolicy(ProtobufUtil.toProtoViolationPolicy(status.getPolicy()));
            }
            return builder.build();
        }

        public static SpaceQuotaStatus toStatus(QuotaProtos.SpaceQuotaStatus proto) {
            if (proto.getInViolation()) {
                return new SpaceQuotaStatus(ProtobufUtil.toViolationPolicy(proto.getViolationPolicy()));
            }
            return NOT_IN_VIOLATION;
        }
    }
}

