/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.replication.ReplicationSerDeHelper;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigListener;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ReplicationPeerZKImpl
extends ReplicationStateZKBase
implements ReplicationPeer,
Abortable,
Closeable {
    private static final Log LOG = LogFactory.getLog(ReplicationPeerZKImpl.class);
    private ReplicationPeerConfig peerConfig;
    private final String id;
    private volatile ReplicationPeer.PeerState peerState;
    private volatile Map<TableName, List<String>> tableCFs = new HashMap<TableName, List<String>>();
    private final Configuration conf;
    private PeerStateTracker peerStateTracker;
    private PeerConfigTracker peerConfigTracker;

    public ReplicationPeerZKImpl(ZooKeeperWatcher zkWatcher, Configuration conf, String id, ReplicationPeerConfig peerConfig, Abortable abortable) throws ReplicationException {
        super(zkWatcher, conf, abortable);
        this.conf = conf;
        this.peerConfig = peerConfig;
        this.id = id;
    }

    public void startStateTracker(String peerStateNode) throws KeeperException {
        this.ensurePeerEnabled(peerStateNode);
        this.peerStateTracker = new PeerStateTracker(peerStateNode, this.zookeeper, this);
        this.peerStateTracker.start();
        try {
            this.readPeerStateZnode();
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
    }

    private void readPeerStateZnode() throws DeserializationException {
        this.peerState = ReplicationPeerZKImpl.isStateEnabled(this.peerStateTracker.getData(false)) ? ReplicationPeer.PeerState.ENABLED : ReplicationPeer.PeerState.DISABLED;
    }

    public void startPeerConfigTracker(String peerConfigNode) throws KeeperException {
        this.peerConfigTracker = new PeerConfigTracker(peerConfigNode, this.zookeeper, this);
        this.peerConfigTracker.start();
        this.readPeerConfig();
    }

    private ReplicationPeerConfig readPeerConfig() {
        try {
            byte[] data = this.peerConfigTracker.getData(false);
            if (data != null) {
                this.peerConfig = ReplicationSerDeHelper.parsePeerFrom(data);
            }
        }
        catch (DeserializationException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        return this.peerConfig;
    }

    @Override
    public ReplicationPeer.PeerState getPeerState() {
        return this.peerState;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ReplicationPeerConfig getPeerConfig() {
        return this.peerConfig;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public Map<TableName, List<String>> getTableCFs() {
        this.tableCFs = this.peerConfig.getTableCFsMap();
        return this.tableCFs;
    }

    @Override
    public Set<String> getNamespaces() {
        return this.peerConfig.getNamespaces();
    }

    @Override
    public long getPeerBandwidth() {
        return this.peerConfig.getBandwidth();
    }

    @Override
    public void trackPeerConfigChanges(ReplicationPeerConfigListener listener) {
        if (this.peerConfigTracker != null) {
            this.peerConfigTracker.setListener(listener);
        }
    }

    @Override
    public void abort(String why, Throwable e) {
        LOG.fatal((Object)("The ReplicationPeer corresponding to peer " + this.peerConfig + " was aborted for the following reason(s):" + why), e);
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    public static boolean isStateEnabled(byte[] bytes) throws DeserializationException {
        ReplicationProtos.ReplicationState.State state = ReplicationPeerZKImpl.parseStateFrom(bytes);
        return ReplicationProtos.ReplicationState.State.ENABLED == state;
    }

    private static ReplicationProtos.ReplicationState.State parseStateFrom(byte[] bytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(bytes);
        int pblen = ProtobufUtil.lengthOfPBMagic();
        ReplicationProtos.ReplicationState.Builder builder = ReplicationProtos.ReplicationState.newBuilder();
        try {
            ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen, bytes.length - pblen);
            ReplicationProtos.ReplicationState state = builder.build();
            return state.getState();
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
    }

    private boolean ensurePeerEnabled(String path) throws KeeperException.NodeExistsException, KeeperException {
        if (ZKUtil.checkExists(this.zookeeper, path) == -1) {
            ZKUtil.createNodeIfNotExistsAndWatch(this.zookeeper, path, ReplicationStateZKBase.ENABLED_ZNODE_BYTES);
            return true;
        }
        return false;
    }

    public class PeerConfigTracker
    extends ZooKeeperNodeTracker {
        ReplicationPeerConfigListener listener;

        public PeerConfigTracker(String peerConfigNode, ZooKeeperWatcher watcher, Abortable abortable) {
            super(watcher, peerConfigNode, abortable);
        }

        public synchronized void setListener(ReplicationPeerConfigListener listener) {
            this.listener = listener;
        }

        @Override
        public synchronized void nodeCreated(String path) {
            if (path.equals(this.node)) {
                super.nodeCreated(path);
                ReplicationPeerConfig config = ReplicationPeerZKImpl.this.readPeerConfig();
                if (this.listener != null) {
                    this.listener.peerConfigUpdated(config);
                }
            }
        }

        @Override
        public synchronized void nodeDataChanged(String path) {
            if (path.equals(this.node)) {
                super.nodeDataChanged(path);
            }
        }
    }

    public class PeerStateTracker
    extends ZooKeeperNodeTracker {
        public PeerStateTracker(String peerStateZNode, ZooKeeperWatcher watcher, Abortable abortable) {
            super(watcher, peerStateZNode, abortable);
        }

        @Override
        public synchronized void nodeDataChanged(String path) {
            if (path.equals(this.node)) {
                super.nodeDataChanged(path);
                try {
                    ReplicationPeerZKImpl.this.readPeerStateZnode();
                }
                catch (DeserializationException e) {
                    LOG.warn((Object)("Failed deserializing the content of " + path), (Throwable)e);
                }
            }
        }
    }
}

