/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public abstract class ReplicationStateZKBase {
    protected final String peerStateNodeName;
    protected final String replicationZNode;
    protected final String peersZNode;
    protected final String queuesZNode;
    protected final String hfileRefsZNode;
    protected final String ourClusterKey;
    protected final String tableCFsNodeName;
    protected final ZooKeeperWatcher zookeeper;
    protected final Configuration conf;
    protected final Abortable abortable;
    public static final byte[] ENABLED_ZNODE_BYTES = ReplicationStateZKBase.toByteArray(ReplicationProtos.ReplicationState.State.ENABLED);
    public static final byte[] DISABLED_ZNODE_BYTES = ReplicationStateZKBase.toByteArray(ReplicationProtos.ReplicationState.State.DISABLED);
    public static final String ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_KEY = "zookeeper.znode.replication.hfile.refs";
    public static final String ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_DEFAULT = "hfile-refs";

    public ReplicationStateZKBase(ZooKeeperWatcher zookeeper, Configuration conf, Abortable abortable) {
        this.zookeeper = zookeeper;
        this.conf = conf;
        this.abortable = abortable;
        String replicationZNodeName = conf.get("zookeeper.znode.replication", "replication");
        String peersZNodeName = conf.get("zookeeper.znode.replication.peers", "peers");
        String queuesZNodeName = conf.get("zookeeper.znode.replication.rs", "rs");
        String hfileRefsZNodeName = conf.get(ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_KEY, ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_DEFAULT);
        this.peerStateNodeName = conf.get("zookeeper.znode.replication.peers.state", "peer-state");
        this.tableCFsNodeName = conf.get("zookeeper.znode.replication.peers.tableCFs", "tableCFs");
        this.ourClusterKey = ZKConfig.getZooKeeperClusterKey((Configuration)this.conf);
        this.replicationZNode = ZKUtil.joinZNode(this.zookeeper.znodePaths.baseZNode, replicationZNodeName);
        this.peersZNode = ZKUtil.joinZNode(this.replicationZNode, peersZNodeName);
        this.queuesZNode = ZKUtil.joinZNode(this.replicationZNode, queuesZNodeName);
        this.hfileRefsZNode = ZKUtil.joinZNode(this.replicationZNode, hfileRefsZNodeName);
    }

    public List<String> getListOfReplicators() {
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, this.queuesZNode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get list of replicators", e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static byte[] toByteArray(ReplicationProtos.ReplicationState.State state) {
        ReplicationProtos.ReplicationState msg = ReplicationProtos.ReplicationState.newBuilder().setState(state).build();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)baos, (int)16);
            msg.writeTo(cos);
            cos.flush();
            baos.flush();
            byte[] byArray = ProtobufUtil.prependPBMagic(baos.toByteArray());
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean peerExists(String id) throws KeeperException {
        return ZKUtil.checkExists(this.zookeeper, ZKUtil.joinZNode(this.peersZNode, id)) >= 0;
    }

    protected boolean isPeerPath(String path) {
        return path.split("/").length == this.peersZNode.split("/").length + 1;
    }

    @VisibleForTesting
    protected String getTableCFsNode(String id) {
        return ZKUtil.joinZNode(this.peersZNode, ZKUtil.joinZNode(id, this.tableCFsNodeName));
    }

    @VisibleForTesting
    protected String getPeerStateNode(String id) {
        return ZKUtil.joinZNode(this.peersZNode, ZKUtil.joinZNode(id, this.peerStateNodeName));
    }

    @VisibleForTesting
    protected String getPeerNode(String id) {
        return ZKUtil.joinZNode(this.peersZNode, id);
    }
}

