/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;

@InterfaceAudience.Private
abstract class ReplicationTableBase {
    public static final TableName REPLICATION_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"replication");
    public static final byte[] CF_QUEUE = Bytes.toBytes((String)"q");
    public static final byte[] COL_QUEUE_OWNER = Bytes.toBytes((String)"o");
    public static final byte[] COL_QUEUE_OWNER_HISTORY = Bytes.toBytes((String)"h");
    private static final HColumnDescriptor REPLICATION_COL_DESCRIPTOR = new HColumnDescriptor(CF_QUEUE).setMaxVersions(1).setInMemory(true).setScope(0).setBloomFilterType(BloomType.NONE);
    public static final String ROW_KEY_DELIMITER = "-";
    public static final String QUEUE_HISTORY_DELIMITER = "|";
    private static final int CLIENT_RETRIES = 3600;
    private static final int RPC_TIMEOUT = 2000;
    private static final int OPERATION_TIMEOUT = 0x6DDD00;
    private static final int NUM_INITIALIZE_WORKERS = 1;
    protected final Configuration conf;
    protected final Abortable abortable;
    private final Connection connection;
    private final Executor executor;
    private volatile CountDownLatch replicationTableInitialized;

    public ReplicationTableBase(Configuration conf, Abortable abort) throws IOException {
        this.conf = new Configuration(conf);
        this.abortable = abort;
        this.decorateConf();
        this.connection = ConnectionFactory.createConnection(this.conf);
        this.executor = this.setUpExecutor();
        this.replicationTableInitialized = new CountDownLatch(1);
        this.createReplicationTableInBackground();
    }

    private void decorateConf() {
        this.conf.setInt("hbase.client.retries.number", 3600);
    }

    private Executor setUpExecutor() {
        ThreadPoolExecutor tempExecutor = new ThreadPoolExecutor(1, 1, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setNameFormat("ReplicationTableExecutor-%d");
        tfb.setDaemon(true);
        tempExecutor.setThreadFactory(tfb.build());
        return tempExecutor;
    }

    public boolean getInitializationStatus() {
        return this.replicationTableInitialized.getCount() == 0L;
    }

    private Table setReplicationTableTimeOuts(Table replicationTable) {
        replicationTable.setRpcTimeout(2000);
        replicationTable.setOperationTimeout(0x6DDD00);
        return replicationTable;
    }

    protected String buildQueueRowKey(String serverName, String queueId) {
        return queueId + ROW_KEY_DELIMITER + serverName;
    }

    protected String getRawQueueIdFromRowKey(String rowKey) {
        return rowKey.split(ROW_KEY_DELIMITER)[0];
    }

    protected byte[] queueIdToRowKey(String serverName, String queueId) {
        if (!queueId.contains(ROW_KEY_DELIMITER)) {
            return Bytes.toBytes((String)this.buildQueueRowKey(serverName, queueId));
        }
        return Bytes.toBytes((String)queueId);
    }

    protected String buildClaimedQueueHistory(String originalHistory, String oldServer) {
        return oldServer + QUEUE_HISTORY_DELIMITER + originalHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getListOfReplicators() {
        HashSet<String> peerServers = new HashSet<String>();
        try (ResultScanner allQueuesInCluster = null;
             Table replicationTable = this.getOrBlockOnReplicationTable();){
            Scan scan = new Scan();
            scan.addColumn(CF_QUEUE, COL_QUEUE_OWNER);
            allQueuesInCluster = replicationTable.getScanner(scan);
            for (Result queue : allQueuesInCluster) {
                peerServers.add(Bytes.toString((byte[])queue.getValue(CF_QUEUE, COL_QUEUE_OWNER)));
            }
        }
        return new ArrayList<String>(peerServers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getAllQueues(String serverName) {
        ArrayList<String> allQueues = new ArrayList<String>();
        try (ResultScanner queueScanner = null;){
            queueScanner = this.getQueuesBelongingToServer(serverName);
            for (Result queue : queueScanner) {
                String rowKey = Bytes.toString((byte[])queue.getRow());
                if (Bytes.toString((byte[])queue.getValue(CF_QUEUE, COL_QUEUE_OWNER_HISTORY)).length() == 0) {
                    allQueues.add(this.getRawQueueIdFromRowKey(rowKey));
                    continue;
                }
                allQueues.add(rowKey);
            }
            ArrayList<String> arrayList = allQueues;
            return arrayList;
        }
    }

    protected List<String> getLogsInQueue(String serverName, String queueId) {
        String rowKey = queueId;
        if (!queueId.contains(ROW_KEY_DELIMITER)) {
            rowKey = this.buildQueueRowKey(serverName, queueId);
        }
        return this.getLogsInQueue(Bytes.toBytes((String)rowKey));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> getLogsInQueue(byte[] rowKey) {
        String errMsg = "Failed getting logs in queue queueId=" + Bytes.toString((byte[])rowKey);
        try (Table replicationTable = this.getOrBlockOnReplicationTable();){
            Get getQueue = new Get(rowKey);
            Result queue = replicationTable.get(getQueue);
            if (queue == null || queue.isEmpty()) {
                this.abortable.abort(errMsg, (Throwable)((Object)new ReplicationException(errMsg)));
                List<String> list2 = null;
                return list2;
            }
            List<String> list = this.readWALsFromResult(queue);
            return list;
        }
        catch (IOException e) {
            this.abortable.abort(errMsg, e);
            return null;
        }
    }

    protected List<String> readWALsFromResult(Result queue) {
        ArrayList<String> wals = new ArrayList<String>();
        NavigableMap<byte[], byte[]> familyMap = queue.getFamilyMap(CF_QUEUE);
        for (byte[] cQualifier : familyMap.keySet()) {
            if (Arrays.equals(cQualifier, COL_QUEUE_OWNER) || Arrays.equals(cQualifier, COL_QUEUE_OWNER_HISTORY)) continue;
            wals.add(Bytes.toString((byte[])cQualifier));
        }
        return wals;
    }

    protected ResultScanner getQueuesBelongingToServer(String server) throws IOException {
        Scan scan = new Scan();
        SingleColumnValueFilter filterMyQueues = new SingleColumnValueFilter(CF_QUEUE, COL_QUEUE_OWNER, CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)server));
        scan.setFilter(filterMyQueues);
        scan.addColumn(CF_QUEUE, COL_QUEUE_OWNER);
        scan.addColumn(CF_QUEUE, COL_QUEUE_OWNER_HISTORY);
        try (Table replicationTable = this.getOrBlockOnReplicationTable();){
            ResultScanner results;
            ResultScanner resultScanner = results = replicationTable.getScanner(scan);
            return resultScanner;
        }
    }

    protected Table getOrBlockOnReplicationTable() throws IOException {
        try {
            this.replicationTableInitialized.await();
        }
        catch (InterruptedException e) {
            String errMsg = "Unable to acquire the Replication Table due to InterruptedException: " + e.getMessage();
            throw new InterruptedIOException(errMsg);
        }
        return this.getAndSetUpReplicationTable();
    }

    private Table getAndSetUpReplicationTable() throws IOException {
        Table replicationTable = this.connection.getTable(REPLICATION_TABLE_NAME);
        this.setReplicationTableTimeOuts(replicationTable);
        return replicationTable;
    }

    private void createReplicationTableInBackground() throws IOException {
        this.executor.execute(new CreateReplicationTableWorker());
    }

    private class CreateReplicationTableWorker
    implements Runnable {
        private Admin admin;

        private CreateReplicationTableWorker() {
        }

        @Override
        public void run() {
            try {
                this.admin = ReplicationTableBase.this.connection.getAdmin();
                if (!this.replicationTableExists()) {
                    this.createReplicationTable();
                }
                int maxRetries = ReplicationTableBase.this.conf.getInt("hbase.replication.queues.createtable.retries.number", 3600);
                RetryCounterFactory counterFactory = new RetryCounterFactory(maxRetries, 2000);
                RetryCounter retryCounter = counterFactory.create();
                while (!this.replicationTableExists()) {
                    retryCounter.sleepUntilNextRetry();
                    if (retryCounter.shouldRetry()) continue;
                    throw new IOException("Unable to acquire the Replication Table");
                }
                ReplicationTableBase.this.replicationTableInitialized.countDown();
            }
            catch (IOException | InterruptedException e) {
                ReplicationTableBase.this.abortable.abort("Failed building Replication Table", e);
            }
        }

        private void createReplicationTable() throws IOException {
            HTableDescriptor replicationTableDescriptor = new HTableDescriptor(REPLICATION_TABLE_NAME);
            replicationTableDescriptor.addFamily(REPLICATION_COL_DESCRIPTOR);
            try {
                this.admin.createTable(replicationTableDescriptor);
            }
            catch (TableExistsException tableExistsException) {
                // empty catch block
            }
        }

        private boolean replicationTableExists() {
            try {
                return this.admin.tableExists(REPLICATION_TABLE_NAME);
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

