/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClientArguments;
import org.apache.hadoop.hbase.replication.ReplicationTableBase;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class TableBasedReplicationQueuesClientImpl
extends ReplicationTableBase
implements ReplicationQueuesClient {
    public TableBasedReplicationQueuesClientImpl(ReplicationQueuesClientArguments args) throws IOException {
        super(args.getConf(), args.getAbortable());
    }

    public TableBasedReplicationQueuesClientImpl(Configuration conf, Abortable abortable) throws IOException {
        super(conf, abortable);
    }

    @Override
    public void init() throws ReplicationException {
    }

    @Override
    public List<String> getListOfReplicators() {
        return super.getListOfReplicators();
    }

    @Override
    public List<String> getLogsInQueue(String serverName, String queueId) {
        return super.getLogsInQueue(serverName, queueId);
    }

    @Override
    public List<String> getAllQueues(String serverName) {
        return super.getAllQueues(serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAllWALs() {
        HashSet<String> allWals = new HashSet<String>();
        try (ResultScanner allQueues = null;
             Table replicationTable = this.getOrBlockOnReplicationTable();){
            allQueues = replicationTable.getScanner(new Scan());
            for (Result queue : allQueues) {
                for (String wal : this.readWALsFromResult(queue)) {
                    allWals.add(wal);
                }
            }
        }
        return allWals;
    }

    @Override
    public int getHFileRefsNodeChangeVersion() throws KeeperException {
        throw new NotImplementedException();
    }

    @Override
    public List<String> getAllPeersFromHFileRefsQueue() throws KeeperException {
        throw new NotImplementedException();
    }

    @Override
    public List<String> getReplicableHFiles(String peerId) throws KeeperException {
        throw new NotImplementedException();
    }
}

