/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.zookeeper.MetricsZooKeeperSource;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperMetricsListener;

@InterfaceAudience.Private
public class MetricsZooKeeper
implements ZooKeeperMetricsListener {
    private final MetricsZooKeeperSource source;

    public MetricsZooKeeper() {
        this((MetricsZooKeeperSource)CompatibilitySingletonFactory.getInstance(MetricsZooKeeperSource.class));
    }

    @VisibleForTesting
    public MetricsZooKeeper(MetricsZooKeeperSource s) {
        this.source = s;
    }

    @Override
    public void registerAuthFailedException() {
        this.source.incrementAuthFailedCount();
    }

    @Override
    public void registerConnectionLossException() {
        this.source.incrementConnectionLossCount();
    }

    @Override
    public void registerDataInconsistencyException() {
        this.source.incrementDataInconsistencyCount();
    }

    @Override
    public void registerInvalidACLException() {
        this.source.incrementInvalidACLCount();
    }

    @Override
    public void registerNoAuthException() {
        this.source.incrementNoAuthCount();
    }

    @Override
    public void registerOperationTimeoutException() {
        this.source.incrementOperationTimeoutCount();
    }

    @Override
    public void registerRuntimeInconsistencyException() {
        this.source.incrementRuntimeInconsistencyCount();
    }

    @Override
    public void registerSessionExpiredException() {
        this.source.incrementSessionExpiredCount();
    }

    @Override
    public void registerSystemErrorException() {
        this.source.incrementSystemErrorCount();
    }

    @Override
    public void registerFailedZKCall() {
        this.source.incrementTotalFailedZKCalls();
    }

    @Override
    public void registerReadOperationLatency(long latency) {
        this.source.recordReadOperationLatency(latency);
    }

    @Override
    public void registerWriteOperationLatency(long latency) {
        this.source.recordWriteOperationLatency(latency);
    }

    @Override
    public void registerSyncOperationLatency(long latency) {
        this.source.recordSyncOperationLatency(latency);
    }
}

