/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.codec.Codec;

public abstract class BaseDecoder
implements Codec.Decoder {
    protected final InputStream in;
    private boolean hasNext = true;
    private Cell current = null;

    public BaseDecoder(InputStream in) {
        this.in = in;
    }

    @Override
    public boolean advance() {
        if (!this.hasNext) {
            return this.hasNext;
        }
        try {
            if (this.in.available() <= 0) {
                this.hasNext = false;
                return this.hasNext;
            }
            this.current = this.parseCell();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.hasNext;
    }

    protected abstract Cell parseCell() throws IOException;

    @Override
    public Cell current() {
        return this.current;
    }
}

