/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.CodecException;

public class KeyValueCodec
implements Codec {
    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        return new KeyValueDecoder(is);
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        return new KeyValueEncoder(os);
    }

    static class KeyValueDecoder
    extends BaseDecoder {
        KeyValueDecoder(InputStream in) {
            super(in);
        }

        @Override
        protected Cell parseCell() throws IOException {
            return KeyValue.iscreate(this.in);
        }
    }

    static class KeyValueEncoder
    extends BaseEncoder {
        KeyValueEncoder(OutputStream out) {
            super(out);
        }

        @Override
        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            try {
                KeyValue.oswrite(KeyValueUtil.ensureKeyValue(cell), this.out);
            }
            catch (IOException e) {
                throw new CodecException(e);
            }
        }
    }
}

