/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hbase.util.ByteRange;

public class ByteRangeTool {
    public static ArrayList<byte[]> copyToNewArrays(Collection<ByteRange> ranges) {
        if (ranges == null) {
            return new ArrayList<byte[]>(0);
        }
        ArrayList arrays = Lists.newArrayListWithCapacity((int)ranges.size());
        for (ByteRange range : ranges) {
            arrays.add(range.deepCopyToNewArray());
        }
        return arrays;
    }

    public static ArrayList<ByteRange> fromArrays(Collection<byte[]> arrays) {
        if (arrays == null) {
            return new ArrayList<ByteRange>(0);
        }
        ArrayList ranges = Lists.newArrayListWithCapacity((int)arrays.size());
        for (byte[] array : arrays) {
            ranges.add(new ByteRange(array));
        }
        return ranges;
    }

    public static void write(OutputStream os, ByteRange byteRange) throws IOException {
        os.write(byteRange.getBytes(), byteRange.getOffset(), byteRange.getLength());
    }

    public static void write(OutputStream os, ByteRange byteRange, int byteRangeInnerOffset) throws IOException {
        os.write(byteRange.getBytes(), byteRange.getOffset() + byteRangeInnerOffset, byteRange.getLength() - byteRangeInnerOffset);
    }
}

