/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public final class HConstants {
    public static final String UTF8_ENCODING = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    public static final int DEFAULT_BLOCKSIZE = 65536;
    public static final int INDEX_KEY_MAGIC = -2;
    public static final String RECOVERED_EDITS_DIR = "recovered.edits";
    public static final ByteBuffer RPC_HEADER = ByteBuffer.wrap("HBas".getBytes());
    public static final byte RPC_CURRENT_VERSION = 0;
    public static final int HFILEBLOCK_HEADER_SIZE_NO_CHECKSUM = 24;
    public static final int HFILEBLOCK_HEADER_SIZE = 33;
    public static final byte[] HFILEBLOCK_DUMMY_HEADER = new byte[33];
    public static final Long ZERO_L = 0L;
    public static final String NINES = "99999999999999";
    public static final String ZEROES = "00000000000000";
    public static final String VERSION_FILE_NAME = "hbase.version";
    public static final String FILE_SYSTEM_VERSION = "8";
    public static final String CLUSTER_DISTRIBUTED = "hbase.cluster.distributed";
    public static final String HBASE_MASTER_LOADBALANCER_CLASS = "hbase.master.loadbalancer.class";
    public static final boolean CLUSTER_IS_LOCAL = false;
    public static final boolean CLUSTER_IS_DISTRIBUTED = true;
    public static final boolean DEFAULT_CLUSTER_DISTRIBUTED = false;
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final String MASTER_PORT = "hbase.master.port";
    public static final int DEFAULT_MASTER_PORT = 16000;
    public static final int DEFAULT_MASTER_INFOPORT = 16010;
    public static final String MASTER_INFO_PORT = "hbase.master.info.port";
    public static final String MASTER_TYPE_BACKUP = "hbase.master.backup";
    public static final boolean DEFAULT_MASTER_TYPE_BACKUP = false;
    public static final String ZOOKEEPER_QUORUM = "hbase.zookeeper.quorum";
    public static final String ZOOKEEPER_CONFIG_NAME = "zoo.cfg";
    public static final String ZK_CFG_PROPERTY_PREFIX = "hbase.zookeeper.property.";
    public static final int ZK_CFG_PROPERTY_PREFIX_LEN = "hbase.zookeeper.property.".length();
    public static final String CLIENT_PORT_STR = "clientPort";
    public static final String ZOOKEEPER_CLIENT_PORT = "hbase.zookeeper.property.clientPort";
    public static final int DEFAULT_ZOOKEPER_CLIENT_PORT = 2181;
    public static final String ZOOKEEPER_RECOVERABLE_WAITTIME = "hbase.zookeeper.recoverable.waittime";
    public static final long DEFAULT_ZOOKEPER_RECOVERABLE_WAITIME = 10000L;
    public static final String ZOOKEEPER_ZNODE_PARENT = "zookeeper.znode.parent";
    public static final String DEFAULT_ZOOKEEPER_ZNODE_PARENT = "/hbase";
    public static final String ZOOKEEPER_MAX_CLIENT_CNXNS = "hbase.zookeeper.property.maxClientCnxns";
    public static final String ZOOKEEPER_DATA_DIR = "hbase.zookeeper.property.dataDir";
    public static final int DEFAULT_ZOOKEPER_MAX_CLIENT_CNXNS = 300;
    public static final String ZK_SESSION_TIMEOUT = "zookeeper.session.timeout";
    public static final int DEFAULT_ZK_SESSION_TIMEOUT = 180000;
    public static final String ZOOKEEPER_USEMULTI = "hbase.zookeeper.useMulti";
    public static final String REGIONSERVER_PORT = "hbase.regionserver.port";
    public static final int DEFAULT_REGIONSERVER_PORT = 16020;
    public static final int DEFAULT_REGIONSERVER_INFOPORT = 16030;
    public static final String REGIONSERVER_INFO_PORT = "hbase.regionserver.info.port";
    public static final String REGIONSERVER_INFO_PORT_AUTO = "hbase.regionserver.info.port.auto";
    public static final String REGION_SERVER_IMPL = "hbase.regionserver.impl";
    public static final String MASTER_IMPL = "hbase.master.impl";
    public static final String HBASECLIENT_IMPL = "hbase.hbaseclient.impl";
    public static final String THREAD_WAKE_FREQUENCY = "hbase.server.thread.wakefrequency";
    public static final int DEFAULT_THREAD_WAKE_FREQUENCY = 10000;
    public static final String VERSION_FILE_WRITE_ATTEMPTS = "hbase.server.versionfile.writeattempts";
    public static final int DEFAULT_VERSION_FILE_WRITE_ATTEMPTS = 3;
    public static final String MAJOR_COMPACTION_PERIOD = "hbase.hregion.majorcompaction";
    public static final String COMPACTION_KV_MAX = "hbase.hstore.compaction.kv.max";
    public static final int COMPACTION_KV_MAX_DEFAULT = 10;
    public static final String HBASE_DIR = "hbase.rootdir";
    public static final String HBASE_CLIENT_IPC_POOL_TYPE = "hbase.client.ipc.pool.type";
    public static final String HBASE_CLIENT_IPC_POOL_SIZE = "hbase.client.ipc.pool.size";
    public static final String HBASE_CLIENT_OPERATION_TIMEOUT = "hbase.client.operation.timeout";
    public static final String HBASE_CLIENT_META_OPERATION_TIMEOUT = "hbase.client.meta.operation.timeout";
    public static final int DEFAULT_HBASE_CLIENT_OPERATION_TIMEOUT = Integer.MAX_VALUE;
    public static final String HREGION_LOGDIR_NAME = "WALs";
    public static final String SPLIT_LOGDIR_NAME = "splitWAL";
    public static final String HREGION_OLDLOGDIR_NAME = "oldWALs";
    public static final String CORRUPT_DIR_NAME = "corrupt";
    public static final String HBCK_SIDELINEDIR_NAME = ".hbck";
    public static final String MIGRATION_NAME = ".migration";
    public static final String LIB_DIR = "lib";
    public static final String HREGION_COMPACTIONDIR_NAME = "compaction.dir";
    public static final String HREGION_MAX_FILESIZE = "hbase.hregion.max.filesize";
    public static final long DEFAULT_MAX_FILE_SIZE = 0x280000000L;
    public static final String TABLE_MAX_ROWSIZE_KEY = "hbase.table.max.rowsize";
    public static final long TABLE_MAX_ROWSIZE_DEFAULT = 0x40000000L;
    public static final String HSTORE_OPEN_AND_CLOSE_THREADS_MAX = "hbase.hstore.open.and.close.threads.max";
    public static final int DEFAULT_HSTORE_OPEN_AND_CLOSE_THREADS_MAX = 1;
    public static final String HREGION_MEMSTORE_FLUSH_SIZE = "hbase.hregion.memstore.flush.size";
    public static final String HREGION_EDITS_REPLAY_SKIP_ERRORS = "hbase.hregion.edits.replay.skip.errors";
    public static final boolean DEFAULT_HREGION_EDITS_REPLAY_SKIP_ERRORS = false;
    public static final int MAXIMUM_VALUE_LENGTH = 0x7FFFFFFE;
    public static final String CLUSTER_ID_FILE_NAME = "hbase.id";
    public static final String CLUSTER_ID_DEFAULT = "default-cluster";
    public static final String KEEP_SEQID_PERIOD = "hbase.hstore.compaction.keep.seqId.period";
    public static final int MIN_KEEP_SEQID_PERIOD = 5;
    @Deprecated
    public static final byte[] META_TABLE_NAME = TableName.META_TABLE_NAME.getName();
    public static final String BASE_NAMESPACE_DIR = "data";
    public static final int META_ROW_DELIMITER = 44;
    public static final String CATALOG_FAMILY_STR = "info";
    public static final byte[] CATALOG_FAMILY = Bytes.toBytes("info");
    public static final String REGIONINFO_QUALIFIER_STR = "regioninfo";
    public static final byte[] REGIONINFO_QUALIFIER = Bytes.toBytes("regioninfo");
    public static final String SERVER_QUALIFIER_STR = "server";
    public static final byte[] SERVER_QUALIFIER = Bytes.toBytes("server");
    public static final String STARTCODE_QUALIFIER_STR = "serverstartcode";
    public static final byte[] STARTCODE_QUALIFIER = Bytes.toBytes("serverstartcode");
    public static final String SEQNUM_QUALIFIER_STR = "seqnumDuringOpen";
    public static final byte[] SEQNUM_QUALIFIER = Bytes.toBytes("seqnumDuringOpen");
    public static final String STATE_QUALIFIER_STR = "state";
    public static final byte[] STATE_QUALIFIER = Bytes.toBytes("state");
    public static final String SERVERNAME_QUALIFIER_STR = "sn";
    public static final byte[] SERVERNAME_QUALIFIER = Bytes.toBytes("sn");
    public static final byte[] SPLITA_QUALIFIER = Bytes.toBytes("splitA");
    public static final byte[] SPLITB_QUALIFIER = Bytes.toBytes("splitB");
    public static final byte[] MERGEA_QUALIFIER = Bytes.toBytes("mergeA");
    public static final byte[] MERGEB_QUALIFIER = Bytes.toBytes("mergeB");
    public static final byte[] META_VERSION_QUALIFIER = Bytes.toBytes("v");
    public static final short META_VERSION = 1;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final byte[] EMPTY_START_ROW = EMPTY_BYTE_ARRAY;
    public static final byte[] EMPTY_END_ROW = EMPTY_START_ROW;
    public static final byte[] LAST_ROW = EMPTY_BYTE_ARRAY;
    public static final int MAX_ROW_LENGTH = Short.MAX_VALUE;
    public static final long LATEST_TIMESTAMP = Long.MAX_VALUE;
    public static final long OLDEST_TIMESTAMP = Long.MIN_VALUE;
    public static final byte[] LATEST_TIMESTAMP_BYTES = new byte[]{127, -1, -1, -1, -1, -1, -1, -1};
    public static final int ALL_VERSIONS = Integer.MAX_VALUE;
    public static final int FOREVER = Integer.MAX_VALUE;
    public static final int WEEK_IN_SECONDS = 604800;
    public static final int DAY_IN_SECONDS = 86400;
    public static final int HOUR_IN_SECONDS = 3600;
    public static final int MINUTE_IN_SECONDS = 60;
    public static final String NAME = "NAME";
    public static final String VERSIONS = "VERSIONS";
    public static final String IN_MEMORY = "IN_MEMORY";
    public static final String METADATA = "METADATA";
    public static final String CONFIGURATION = "CONFIGURATION";
    public static final int[] RETRY_BACKOFF = new int[]{1, 2, 3, 5, 10, 20, 40, 100, 100, 100, 100, 200, 200};
    public static final String REGION_IMPL = "hbase.hregion.impl";
    public static final int REPLICATION_SCOPE_LOCAL = 0;
    public static final int REPLICATION_SCOPE_GLOBAL = 1;
    public static final UUID DEFAULT_CLUSTER_ID = new UUID(0L, 0L);
    public static final String HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE_KEY = "hbase.client.scanner.max.result.size";
    public static final long DEFAULT_HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE = Long.MAX_VALUE;
    public static final String HBASE_CLIENT_PAUSE = "hbase.client.pause";
    public static final long DEFAULT_HBASE_CLIENT_PAUSE = 100L;
    public static final String HBASE_CLIENT_MAX_TOTAL_TASKS = "hbase.client.max.total.tasks";
    public static final int DEFAULT_HBASE_CLIENT_MAX_TOTAL_TASKS = 100;
    public static final String HBASE_CLIENT_MAX_PERSERVER_TASKS = "hbase.client.max.perserver.tasks";
    public static final int DEFAULT_HBASE_CLIENT_MAX_PERSERVER_TASKS = 2;
    public static final String HBASE_CLIENT_MAX_PERREGION_TASKS = "hbase.client.max.perregion.tasks";
    public static final int DEFAULT_HBASE_CLIENT_MAX_PERREGION_TASKS = 1;
    public static final String HBASE_SERVER_PAUSE = "hbase.server.pause";
    public static final int DEFAULT_HBASE_SERVER_PAUSE = 1000;
    public static final String HBASE_CLIENT_RETRIES_NUMBER = "hbase.client.retries.number";
    public static final int DEFAULT_HBASE_CLIENT_RETRIES_NUMBER = 31;
    public static final String HBASE_CLIENT_SCANNER_CACHING = "hbase.client.scanner.caching";
    public static final int DEFAULT_HBASE_CLIENT_SCANNER_CACHING = 100;
    public static final String HBASE_META_SCANNER_CACHING = "hbase.meta.scanner.caching";
    public static final int DEFAULT_HBASE_META_SCANNER_CACHING = 100;
    public static final String HBASE_CLIENT_INSTANCE_ID = "hbase.client.instance.id";
    public static final String HBASE_CLIENT_SCANNER_TIMEOUT_PERIOD = "hbase.client.scanner.timeout.period";
    @Deprecated
    public static final String HBASE_REGIONSERVER_LEASE_PERIOD_KEY = "hbase.regionserver.lease.period";
    public static final int DEFAULT_HBASE_CLIENT_SCANNER_TIMEOUT_PERIOD = 60000;
    public static final String HBASE_RPC_TIMEOUT_KEY = "hbase.rpc.timeout";
    public static final int DEFAULT_HBASE_RPC_TIMEOUT = 60000;
    public static final String HBASE_RPC_SHORTOPERATION_TIMEOUT_KEY = "hbase.rpc.shortoperation.timeout";
    public static final int DEFAULT_HBASE_RPC_SHORTOPERATION_TIMEOUT = 10000;
    public static final long NO_SEQNUM = -1L;
    public static final String REPLICATION_ENABLE_KEY = "hbase.replication";
    public static final boolean REPLICATION_ENABLE_DEFAULT = true;
    public static final String REPLICATION_SOURCE_SERVICE_CLASSNAME = "hbase.replication.source.service";
    public static final String REPLICATION_SINK_SERVICE_CLASSNAME = "hbase.replication.sink.service";
    public static final String REPLICATION_SERVICE_CLASSNAME_DEFAULT = "org.apache.hadoop.hbase.replication.regionserver.Replication";
    public static final String HBCK_CODE_NAME = "HBCKServerName";
    public static final String KEY_FOR_HOSTNAME_SEEN_BY_MASTER = "hbase.regionserver.hostname.seen.by.master";
    public static final String HBASE_MASTER_LOGCLEANER_PLUGINS = "hbase.master.logcleaner.plugins";
    public static final String HBASE_REGION_SPLIT_POLICY_KEY = "hbase.regionserver.region.split.policy";
    public static final String HBASE_RS_NONCES_ENABLED = "hbase.regionserver.nonces.enabled";
    public static final String HFILE_BLOCK_CACHE_SIZE_KEY = "hfile.block.cache.size";
    public static final float HFILE_BLOCK_CACHE_SIZE_DEFAULT = 0.4f;
    public static final float HBASE_CLUSTER_MINIMUM_MEMORY_THRESHOLD = 0.2f;
    public static final Pattern CP_HTD_ATTR_KEY_PATTERN = Pattern.compile("^coprocessor\\$([0-9]+)$", 2);
    public static final Pattern CP_HTD_ATTR_VALUE_PATTERN = Pattern.compile("(^[^\\|]*)\\|([^\\|]+)\\|[\\s]*([\\d]*)[\\s]*(\\|.*)?$");
    public static final String CP_HTD_ATTR_VALUE_PARAM_KEY_PATTERN = "[^=,]+";
    public static final String CP_HTD_ATTR_VALUE_PARAM_VALUE_PATTERN = "[^,]+";
    public static final Pattern CP_HTD_ATTR_VALUE_PARAM_PATTERN = Pattern.compile("([^=,]+)=([^,]+),?");
    public static final int SOCKET_RETRY_WAIT_MS = 200;
    public static final String LOCALHOST = "localhost";
    public static final String HBASE_CHECKSUM_VERIFICATION = "hbase.regionserver.checksum.verify";
    public static final String LOCALHOST_IP = "127.0.0.1";
    public static final String DISTRIBUTED_LOG_REPLAY_KEY = "hbase.master.distributed.log.replay";
    public static final boolean DEFAULT_DISTRIBUTED_LOG_REPLAY_CONFIG = false;
    public static final String DISALLOW_WRITES_IN_RECOVERING = "hbase.regionserver.disallow.writes.when.recovering";
    public static final boolean DEFAULT_DISALLOW_WRITES_IN_RECOVERING_CONFIG = false;
    public static final String REGION_SERVER_HANDLER_COUNT = "hbase.regionserver.handler.count";
    public static final int DEFAULT_REGION_SERVER_HANDLER_COUNT = 30;
    public static final String REGION_SERVER_META_HANDLER_COUNT = "hbase.regionserver.metahandler.count";
    public static final int DEFAULT_REGION_SERVER_META_HANDLER_COUNT = 10;
    public static final String REGION_SERVER_REPLICATION_HANDLER_COUNT = "hbase.regionserver.replication.handler.count";
    public static final int DEFAULT_REGION_SERVER_REPLICATION_HANDLER_COUNT = 3;
    public static final String MASTER_HANDLER_COUNT = "hbase.master.handler.count";
    public static final int DEFAULT_MASTER_HANLDER_COUNT = 25;
    public static final String LOG_REPLAY_WAIT_REGION_TIMEOUT = "hbase.master.log.replay.wait.region.timeout";
    public static final String BYTES_PER_CHECKSUM = "hbase.hstore.bytes.per.checksum";
    public static final String CHECKSUM_TYPE_NAME = "hbase.hstore.checksum.algorithm";
    public static final String ENABLE_DATA_FILE_UMASK = "hbase.data.umask.enable";
    public static final String DATA_FILE_UMASK_KEY = "hbase.data.umask";
    public static final String ENABLE_WAL_COMPRESSION = "hbase.regionserver.wal.enablecompression";
    public static final String METRICS_RIT_STUCK_WARNING_THRESHOLD = "hbase.metrics.rit.stuck.warning.threshold";
    public static final String LOAD_BALANCER_SLOP_KEY = "hbase.regions.slop";
    public static final byte[] NO_NEXT_INDEXED_KEY = Bytes.toBytes("NO_NEXT_INDEXED_KEY");
    public static final int DELIMITER = 44;
    public static final String HBASE_CONFIG_READ_ZOOKEEPER_CONFIG = "hbase.config.read.zookeeper.config";
    public static final boolean DEFAULT_HBASE_CONFIG_READ_ZOOKEEPER_CONFIG = false;
    public static final int NORMAL_QOS = 0;
    public static final int QOS_THRESHOLD = 10;
    public static final int HIGH_QOS = 100;
    public static final int REPLICATION_QOS = 5;
    public static final int REPLAY_QOS = 6;
    public static final String HFILE_ARCHIVE_DIRECTORY = "archive";
    public static final String SNAPSHOT_DIR_NAME = ".hbase-snapshot";
    public static final String OLD_SNAPSHOT_DIR_NAME = ".snapshot";
    public static final String HBASE_TEMP_DIRECTORY = ".tmp";
    public static final String REGIONSERVER_METRICS_PERIOD = "hbase.regionserver.metrics.period";
    public static final long DEFAULT_REGIONSERVER_METRICS_PERIOD = 5000L;
    public static final List<String> HBASE_NON_TABLE_DIRS = Collections.unmodifiableList(Arrays.asList(".hbck", ".tmp", ".migration"));
    public static final List<String> HBASE_NON_USER_TABLE_DIRS = Collections.unmodifiableList(Arrays.asList((String[])ArrayUtils.addAll((Object[])new String[]{TableName.META_TABLE_NAME.getNameAsString()}, (Object[])HBASE_NON_TABLE_DIRS.toArray())));
    public static final String HEALTH_SCRIPT_LOC = "hbase.node.health.script.location";
    public static final String HEALTH_SCRIPT_TIMEOUT = "hbase.node.health.script.timeout";
    public static final String HEALTH_CHORE_WAKE_FREQ = "hbase.node.health.script.frequency";
    public static final long DEFAULT_HEALTH_SCRIPT_TIMEOUT = 60000L;
    public static final String HEALTH_FAILURE_THRESHOLD = "hbase.node.health.failure.threshold";
    public static final int DEFAULT_HEALTH_FAILURE_THRESHOLD = 3;
    public static final String STATUS_PUBLISHED = "hbase.status.published";
    public static final boolean STATUS_PUBLISHED_DEFAULT = false;
    public static final String STATUS_MULTICAST_ADDRESS = "hbase.status.multicast.address.ip";
    public static final String DEFAULT_STATUS_MULTICAST_ADDRESS = "226.1.1.3";
    public static final String STATUS_MULTICAST_BIND_ADDRESS = "hbase.status.multicast.bind.address.ip";
    public static final String DEFAULT_STATUS_MULTICAST_BIND_ADDRESS = "0.0.0.0";
    public static final String STATUS_MULTICAST_PORT = "hbase.status.multicast.address.port";
    public static final int DEFAULT_STATUS_MULTICAST_PORT = 16100;
    public static final long NO_NONCE = 0L;
    public static final String CRYPTO_CIPHERPROVIDER_CONF_KEY = "hbase.crypto.cipherprovider";
    public static final String CRYPTO_KEYPROVIDER_CONF_KEY = "hbase.crypto.keyprovider";
    public static final String CRYPTO_KEYPROVIDER_PARAMETERS_KEY = "hbase.crypto.keyprovider.parameters";
    public static final String CRYPTO_MASTERKEY_NAME_CONF_KEY = "hbase.crypto.master.key.name";
    public static final String CRYPTO_MASTERKEY_ALTERNATE_NAME_CONF_KEY = "hbase.crypto.master.alternate.key.name";
    public static final String CRYPTO_WAL_ALGORITHM_CONF_KEY = "hbase.crypto.wal.algorithm";
    public static final String CRYPTO_WAL_KEY_NAME_CONF_KEY = "hbase.crypto.wal.key.name";
    public static final String ENABLE_WAL_ENCRYPTION = "hbase.regionserver.wal.encryption";
    public static final String RPC_CODEC_CONF_KEY = "hbase.client.rpc.codec";
    public static final String REPLICATION_CODEC_CONF_KEY = "hbase.replication.rpc.codec";
    public static final String HBASE_COORDINATED_STATE_MANAGER_CLASS = "hbase.coordinated.state.manager.class";
    public static final String HBASE_SPLITLOG_MANAGER_TIMEOUT = "hbase.splitlog.manager.timeout";
    public static final String BUCKET_CACHE_IOENGINE_KEY = "hbase.bucketcache.ioengine";
    public static final String BUCKET_CACHE_SIZE_KEY = "hbase.bucketcache.size";
    public static final String HBASE_CLIENT_FAST_FAIL_MODE_ENABLED = "hbase.client.fast.fail.mode.enabled";
    public static final boolean HBASE_CLIENT_ENABLE_FAST_FAIL_MODE_DEFAULT = false;
    public static final String HBASE_CLIENT_FAST_FAIL_THREASHOLD_MS = "hbase.client.fastfail.threshold";
    public static final long HBASE_CLIENT_FAST_FAIL_THREASHOLD_MS_DEFAULT = 60000L;
    public static final String HBASE_CLIENT_FAST_FAIL_CLEANUP_MS_DURATION_MS = "hbase.client.fast.fail.cleanup.duration";
    public static final long HBASE_CLIENT_FAST_FAIL_CLEANUP_DURATION_MS_DEFAULT = 600000L;
    public static final String HBASE_CLIENT_FAST_FAIL_INTERCEPTOR_IMPL = "hbase.client.fast.fail.interceptor.impl";

    private HConstants() {
    }

    @InterfaceAudience.Private
    public static enum Modify {
        CLOSE_REGION,
        TABLE_COMPACT,
        TABLE_FLUSH,
        TABLE_MAJOR_COMPACT,
        TABLE_SET_HTD,
        TABLE_SPLIT;

    }

    @InterfaceAudience.Private
    public static enum OperationStatusCode {
        NOT_RUN,
        SUCCESS,
        BAD_FAMILY,
        SANITY_CHECK_FAILURE,
        FAILURE;

    }
}

