/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ByteBufferCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.shaded.com.google.common.primitives.Longs;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@SuppressWarnings(value={"UNKNOWN"}, justification="Findbugs doesn't like the way we are negating the result of a compare in below")
public class CellComparator
implements Comparator<Cell>,
Serializable {
    static final Log LOG = LogFactory.getLog(CellComparator.class);
    private static final long serialVersionUID = -8760041766259623329L;
    public static final CellComparator COMPARATOR = new CellComparator();
    public static final CellComparator META_COMPARATOR = new MetaCellComparator();

    @Override
    public int compare(Cell a, Cell b) {
        return this.compare(a, b, false);
    }

    public final int compareKeyIgnoresMvcc(Cell left, Cell right) {
        return this.compare(left, right, true);
    }

    public final int compare(Cell left, byte[] key, int offset, int length) {
        short rrowlength = Bytes.toShort(key, offset);
        int c = this.compareRows(left, key, offset + 2, rrowlength);
        if (c != 0) {
            return c;
        }
        return this.compareWithoutRow(left, key, offset, length, rrowlength);
    }

    private final int compare(Cell a, Cell b, boolean ignoreSequenceid) {
        int c = this.compareRows(a, b);
        if (c != 0) {
            return c;
        }
        c = CellComparator.compareWithoutRow(a, b);
        if (c != 0) {
            return c;
        }
        if (!ignoreSequenceid) {
            return Longs.compare((long)b.getSequenceId(), (long)a.getSequenceId());
        }
        return c;
    }

    public static final int compareColumns(Cell left, Cell right) {
        int diff = CellComparator.compareFamilies(left, right);
        if (diff != 0) {
            return diff;
        }
        return CellComparator.compareQualifiers(left, right);
    }

    private static final int compareColumns(Cell left, byte[] right, int rfoffset, int rflength, int rqoffset, int rqlength) {
        int diff = CellComparator.compareFamilies(left, right, rfoffset, rflength);
        if (diff != 0) {
            return diff;
        }
        return CellComparator.compareQualifiers(left, right, rqoffset, rqlength);
    }

    public static final int compareFamilies(Cell left, Cell right) {
        if (left instanceof ByteBufferCell && right instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getFamilyByteBuffer(), ((ByteBufferCell)left).getFamilyPosition(), (int)left.getFamilyLength(), ((ByteBufferCell)right).getFamilyByteBuffer(), ((ByteBufferCell)right).getFamilyPosition(), (int)right.getFamilyLength());
        }
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getFamilyByteBuffer(), ((ByteBufferCell)left).getFamilyPosition(), (int)left.getFamilyLength(), right.getFamilyArray(), right.getFamilyOffset(), (int)right.getFamilyLength());
        }
        if (right instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(left.getFamilyArray(), left.getFamilyOffset(), (int)left.getFamilyLength(), ((ByteBufferCell)right).getFamilyByteBuffer(), ((ByteBufferCell)right).getFamilyPosition(), (int)right.getFamilyLength());
        }
        return Bytes.compareTo(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), right.getFamilyArray(), right.getFamilyOffset(), right.getFamilyLength());
    }

    private static final int compareFamilies(Cell left, byte[] right, int roffset, int rlength) {
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getFamilyByteBuffer(), ((ByteBufferCell)left).getFamilyPosition(), (int)left.getFamilyLength(), right, roffset, rlength);
        }
        return Bytes.compareTo(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), right, roffset, rlength);
    }

    public static final int compareQualifiers(Cell left, Cell right) {
        if (left instanceof ByteBufferCell && right instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getQualifierByteBuffer(), ((ByteBufferCell)left).getQualifierPosition(), left.getQualifierLength(), ((ByteBufferCell)right).getQualifierByteBuffer(), ((ByteBufferCell)right).getQualifierPosition(), right.getQualifierLength());
        }
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getQualifierByteBuffer(), ((ByteBufferCell)left).getQualifierPosition(), left.getQualifierLength(), right.getQualifierArray(), right.getQualifierOffset(), right.getQualifierLength());
        }
        if (right instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), ((ByteBufferCell)right).getQualifierByteBuffer(), ((ByteBufferCell)right).getQualifierPosition(), right.getQualifierLength());
        }
        return Bytes.compareTo(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), right.getQualifierArray(), right.getQualifierOffset(), right.getQualifierLength());
    }

    public static final int compareQualifiers(Cell left, byte[] right, int rOffset, int rLength) {
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getQualifierByteBuffer(), ((ByteBufferCell)left).getQualifierPosition(), left.getQualifierLength(), right, rOffset, rLength);
        }
        return Bytes.compareTo(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), right, rOffset, rLength);
    }

    private final int compareWithoutRow(Cell left, byte[] right, int roffset, int rlength, short rowlength) {
        byte rfamilylength;
        boolean sameFamilySize;
        int commonLength = 3 + rowlength;
        int commonLengthWithTSAndType = 9 + commonLength;
        int lcolumnlength = left.getFamilyLength() + left.getQualifierLength();
        int rcolumnlength = rlength - commonLengthWithTSAndType;
        byte ltype = left.getTypeByte();
        byte rtype = right[roffset + (rlength - 1)];
        if (lcolumnlength == 0 && ltype == KeyValue.Type.Minimum.getCode()) {
            return 1;
        }
        if (rcolumnlength == 0 && rtype == KeyValue.Type.Minimum.getCode()) {
            return -1;
        }
        int rfamilyoffset = commonLength + roffset;
        byte lfamilylength = left.getFamilyLength();
        boolean bl = sameFamilySize = lfamilylength == (rfamilylength = right[rfamilyoffset - 1]);
        if (!sameFamilySize) {
            return CellComparator.compareFamilies(left, right, rfamilyoffset, rfamilylength);
        }
        int comparison = CellComparator.compareColumns(left, right, rfamilyoffset, rfamilylength, rfamilyoffset + rfamilylength, rcolumnlength - rfamilylength);
        if (comparison != 0) {
            return comparison;
        }
        long rtimestamp = Bytes.toLong(right, roffset + (rlength - 9));
        int compare = CellComparator.compareTimestamps(left.getTimestamp(), rtimestamp);
        if (compare != 0) {
            return compare;
        }
        return (0xFF & rtype) - (0xFF & ltype);
    }

    public int compareRows(Cell left, Cell right) {
        if (left == right) {
            return 0;
        }
        if (left instanceof ByteBufferCell && right instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getRowByteBuffer(), ((ByteBufferCell)left).getRowPosition(), (int)left.getRowLength(), ((ByteBufferCell)right).getRowByteBuffer(), ((ByteBufferCell)right).getRowPosition(), (int)right.getRowLength());
        }
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getRowByteBuffer(), ((ByteBufferCell)left).getRowPosition(), (int)left.getRowLength(), right.getRowArray(), right.getRowOffset(), (int)right.getRowLength());
        }
        if (right instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(left.getRowArray(), left.getRowOffset(), (int)left.getRowLength(), ((ByteBufferCell)right).getRowByteBuffer(), ((ByteBufferCell)right).getRowPosition(), (int)right.getRowLength());
        }
        return Bytes.compareTo(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right.getRowArray(), right.getRowOffset(), right.getRowLength());
    }

    public int compareRows(Cell left, byte[] right, int roffset, int rlength) {
        if (left instanceof ByteBufferCell) {
            return ByteBufferUtils.compareTo(((ByteBufferCell)left).getRowByteBuffer(), ((ByteBufferCell)left).getRowPosition(), (int)left.getRowLength(), right, roffset, rlength);
        }
        return Bytes.compareTo(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right, roffset, rlength);
    }

    public static int compareWithoutRow(Cell left, Cell right) {
        byte lFamLength = left.getFamilyLength();
        byte rFamLength = right.getFamilyLength();
        int lQualLength = left.getQualifierLength();
        int rQualLength = right.getQualifierLength();
        if (lFamLength + lQualLength == 0 && left.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
            return 1;
        }
        if (rFamLength + rQualLength == 0 && right.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
            return -1;
        }
        if (lFamLength != rFamLength) {
            return CellComparator.compareFamilies(left, right);
        }
        int diff = CellComparator.compareColumns(left, right);
        if (diff != 0) {
            return diff;
        }
        diff = CellComparator.compareTimestamps(left, right);
        if (diff != 0) {
            return diff;
        }
        return (0xFF & right.getTypeByte()) - (0xFF & left.getTypeByte());
    }

    public static int compareTimestamps(Cell left, Cell right) {
        return CellComparator.compareTimestamps(left.getTimestamp(), right.getTimestamp());
    }

    public final int compareKeyBasedOnColHint(Cell nextIndexedCell, Cell currentCell, int foff, int flen, byte[] colHint, int coff, int clen, long ts, byte type) {
        int compare = this.compareRows(nextIndexedCell, currentCell);
        if (compare != 0) {
            return compare;
        }
        if (nextIndexedCell.getFamilyLength() + nextIndexedCell.getQualifierLength() == 0 && nextIndexedCell.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
            return 1;
        }
        if (flen + clen == 0 && type == KeyValue.Type.Minimum.getCode()) {
            return -1;
        }
        compare = CellComparator.compareFamilies(nextIndexedCell, currentCell);
        if (compare != 0) {
            return compare;
        }
        compare = colHint == null ? CellComparator.compareQualifiers(nextIndexedCell, currentCell) : CellComparator.compareQualifiers(nextIndexedCell, colHint, coff, clen);
        if (compare != 0) {
            return compare;
        }
        compare = CellComparator.compareTimestamps(nextIndexedCell.getTimestamp(), ts);
        if (compare != 0) {
            return compare;
        }
        return (0xFF & type) - (0xFF & nextIndexedCell.getTypeByte());
    }

    public static int compareTimestamps(long ltimestamp, long rtimestamp) {
        if (ltimestamp < rtimestamp) {
            return 1;
        }
        if (ltimestamp > rtimestamp) {
            return -1;
        }
        return 0;
    }

    public static int compareRow(Cell cell, ByteArrayComparable comparator) {
        if (cell instanceof ByteBufferCell) {
            return comparator.compareTo(((ByteBufferCell)cell).getRowByteBuffer(), ((ByteBufferCell)cell).getRowPosition(), (int)cell.getRowLength());
        }
        return comparator.compareTo(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
    }

    public static int compareFamily(Cell cell, ByteArrayComparable comparator) {
        if (cell instanceof ByteBufferCell) {
            return comparator.compareTo(((ByteBufferCell)cell).getFamilyByteBuffer(), ((ByteBufferCell)cell).getFamilyPosition(), (int)cell.getFamilyLength());
        }
        return comparator.compareTo(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength());
    }

    public static int compareQualifier(Cell cell, ByteArrayComparable comparator) {
        if (cell instanceof ByteBufferCell) {
            return comparator.compareTo(((ByteBufferCell)cell).getQualifierByteBuffer(), ((ByteBufferCell)cell).getQualifierPosition(), cell.getQualifierLength());
        }
        return comparator.compareTo(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    public static int compareValue(Cell cell, ByteArrayComparable comparator) {
        if (cell instanceof ByteBufferCell) {
            return comparator.compareTo(((ByteBufferCell)cell).getValueByteBuffer(), ((ByteBufferCell)cell).getValuePosition(), cell.getValueLength());
        }
        return comparator.compareTo(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static class MetaCellComparator
    extends CellComparator {
        @Override
        public int compareRows(Cell left, Cell right) {
            return this.compareRows(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right.getRowArray(), right.getRowOffset(), right.getRowLength());
        }

        @Override
        public int compareRows(Cell left, byte[] right, int roffset, int rlength) {
            return this.compareRows(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right, roffset, rlength);
        }

        private int compareRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
            int rightFarDelimiter;
            int leftFarDelimiter;
            int rightDelimiter;
            int rpart;
            int leftDelimiter = Bytes.searchDelimiterIndex(left, loffset, llength, 44);
            int lpart = leftDelimiter < 0 ? llength : leftDelimiter - loffset;
            int result = Bytes.compareTo(left, loffset, lpart, right, roffset, rpart = (rightDelimiter = Bytes.searchDelimiterIndex(right, roffset, rlength, 44)) < 0 ? rlength : rightDelimiter - roffset);
            if (result != 0) {
                return result;
            }
            if (leftDelimiter < 0 && rightDelimiter >= 0) {
                return -1;
            }
            if (rightDelimiter < 0 && leftDelimiter >= 0) {
                return 1;
            }
            if (leftDelimiter < 0 && rightDelimiter < 0) {
                return 0;
            }
            if ((result = Bytes.compareTo(left, leftDelimiter, lpart = ((leftFarDelimiter = Bytes.searchDelimiterIndexInReverse(left, ++leftDelimiter, llength - (leftDelimiter - loffset), 44)) < 0 ? llength + loffset : leftFarDelimiter) - leftDelimiter, right, rightDelimiter, rpart = ((rightFarDelimiter = Bytes.searchDelimiterIndexInReverse(right, ++rightDelimiter, rlength - (rightDelimiter - roffset), 44)) < 0 ? rlength + roffset : rightFarDelimiter) - rightDelimiter)) != 0) {
                return result;
            }
            if (leftDelimiter < 0 && rightDelimiter >= 0) {
                return -1;
            }
            if (rightDelimiter < 0 && leftDelimiter >= 0) {
                return 1;
            }
            if (leftDelimiter < 0 && rightDelimiter < 0) {
                return 0;
            }
            result = Bytes.compareTo(left, ++leftFarDelimiter, llength - (leftFarDelimiter - loffset), right, ++rightFarDelimiter, rlength - (rightFarDelimiter - roffset));
            return result;
        }
    }

    public static class RowComparator
    extends CellComparator {
        @Override
        public int compare(Cell a, Cell b) {
            return this.compareRows(a, b);
        }
    }
}

