/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.BaseConfigurable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.CacheLoader;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.LoadingCache;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public class UserProvider
extends BaseConfigurable {
    private static final String USER_PROVIDER_CONF_KEY = "hbase.client.userprovider.class";
    private static final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("group-cache-%d").build()));
    private LoadingCache<String, String[]> groupCache = null;
    static Groups groups = Groups.getUserToGroupsMappingService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        Class<UserProvider> clazz = UserProvider.class;
        synchronized (UserProvider.class) {
            if (!(groups instanceof User.TestingGroups)) {
                groups = Groups.getUserToGroupsMappingService((Configuration)conf);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            long cacheTimeout = this.getConf().getLong("hadoop.security.groups.cache.secs", 300L) * 1000L;
            this.groupCache = CacheBuilder.newBuilder().refreshAfterWrite(cacheTimeout, TimeUnit.MILLISECONDS).expireAfterWrite(10L * cacheTimeout, TimeUnit.MILLISECONDS).concurrencyLevel(20).build((CacheLoader)new CacheLoader<String, String[]>(){

                public String[] load(String ugi) throws Exception {
                    return this.getGroupStrings(ugi);
                }

                private String[] getGroupStrings(String ugi) {
                    try {
                        LinkedHashSet result = new LinkedHashSet(groups.getGroups(ugi));
                        return result.toArray(new String[result.size()]);
                    }
                    catch (Exception e) {
                        return new String[0];
                    }
                }

                public ListenableFuture<String[]> reload(final String k, String[] oldValue) throws Exception {
                    return executor.submit((Callable)new Callable<String[]>(){

                        @Override
                        public String[] call() throws Exception {
                            return this.getGroupStrings(k);
                        }
                    });
                }
            });
            return;
        }
    }

    public static UserProvider instantiate(Configuration conf) {
        Class clazz = conf.getClass(USER_PROVIDER_CONF_KEY, UserProvider.class, UserProvider.class);
        return (UserProvider)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
    }

    public static void setUserProviderForTesting(Configuration conf, Class<? extends UserProvider> provider) {
        conf.set(USER_PROVIDER_CONF_KEY, provider.getName());
    }

    public String getCurrentUserName() throws IOException {
        User user = this.getCurrent();
        return user == null ? null : user.getName();
    }

    public boolean isHBaseSecurityEnabled() {
        return User.isHBaseSecurityEnabled(this.getConf());
    }

    public boolean isHadoopSecurityEnabled() {
        return User.isSecurityEnabled();
    }

    public User getCurrent() throws IOException {
        return User.getCurrent();
    }

    public User create(UserGroupInformation ugi) {
        if (ugi == null) {
            return null;
        }
        return new User.SecureHadoopUser(ugi, this.groupCache);
    }

    public void login(String fileConfKey, String principalConfKey, String localhost) throws IOException {
        User.login(this.getConf(), fileConfKey, principalConfKey, localhost);
    }
}

