/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
public final class ZKConfig {
    private static final String VARIABLE_START = "${";

    private ZKConfig() {
    }

    public static Properties makeZKProps(Configuration conf) {
        return ZKConfig.makeZKPropsFromHbaseConfig(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties makeZKPropsFromHbaseConfig(Configuration conf) {
        Properties zkProperties = new Properties();
        Configuration configuration = conf;
        synchronized (configuration) {
            for (Map.Entry entry : conf) {
                String key = (String)entry.getKey();
                if (!key.startsWith("hbase.zookeeper.property.")) continue;
                String zkKey = key.substring(HConstants.ZK_CFG_PROPERTY_PREFIX_LEN);
                String value = (String)entry.getValue();
                if (value.contains(VARIABLE_START)) {
                    value = conf.get(key);
                }
                zkProperties.setProperty(zkKey, value);
            }
        }
        if (zkProperties.getProperty("clientPort") == null) {
            zkProperties.put("clientPort", (Object)2181);
        }
        int peerPort = conf.getInt("hbase.zookeeper.peerport", 2888);
        int leaderPort = conf.getInt("hbase.zookeeper.leaderport", 3888);
        String[] serverHosts = conf.getStrings("hbase.zookeeper.quorum", new String[]{"localhost"});
        for (int i = 0; i < serverHosts.length; ++i) {
            String serverHost = serverHosts[i].contains(":") ? serverHosts[i].substring(0, serverHosts[i].indexOf(58)) : serverHosts[i];
            String address = serverHost + ":" + peerPort + ":" + leaderPort;
            String key = "server." + i;
            zkProperties.put(key, address);
        }
        return zkProperties;
    }

    private static String getZKQuorumServersStringFromHbaseConfig(Configuration conf) {
        String defaultClientPort = Integer.toString(conf.getInt("hbase.zookeeper.property.clientPort", 2181));
        String[] serverHosts = conf.getStrings("hbase.zookeeper.quorum", new String[]{"localhost"});
        return ZKConfig.buildZKQuorumServerString(serverHosts, defaultClientPort);
    }

    public static String getZKQuorumServersString(Configuration conf) {
        return ZKConfig.getZKQuorumServersStringFromHbaseConfig(conf);
    }

    public static String buildZKQuorumServerString(String[] serverHosts, String clientPort) {
        StringBuilder quorumStringBuilder = new StringBuilder();
        for (int i = 0; i < serverHosts.length; ++i) {
            String serverHost = serverHosts[i].contains(":") ? serverHosts[i] : serverHosts[i] + ":" + clientPort;
            if (i > 0) {
                quorumStringBuilder.append(',');
            }
            quorumStringBuilder.append(serverHost);
        }
        return quorumStringBuilder.toString();
    }

    public static void validateClusterKey(String key) throws IOException {
        ZKConfig.transformClusterKey(key);
    }

    public static ZKClusterKey transformClusterKey(String key) throws IOException {
        String[] parts = key.split(":");
        if (parts.length == 3) {
            if (!parts[2].matches("/.*[^/]")) {
                throw new IOException("Cluster key passed " + key + " is invalid, the format should be:" + "hbase.zookeeper.quorum" + ":" + "hbase.zookeeper.property.clientPort" + ":" + "zookeeper.znode.parent");
            }
            return new ZKClusterKey(parts[0], Integer.parseInt(parts[1]), parts[2]);
        }
        if (parts.length > 3) {
            String zNodeParent = parts[parts.length - 1];
            if (!zNodeParent.matches("/.*[^/]")) {
                throw new IOException("Cluster key passed " + key + " is invalid, the format should be:" + "hbase.zookeeper.quorum" + ":" + "hbase.zookeeper.property.clientPort" + ":" + "zookeeper.znode.parent");
            }
            String clientPort = parts[parts.length - 2];
            int endQuorumIndex = key.length() - zNodeParent.length() - clientPort.length() - 2;
            String quorumStringInput = key.substring(0, endQuorumIndex);
            String[] serverHosts = quorumStringInput.split(",");
            if (parts.length - 2 == serverHosts.length + 1) {
                return new ZKClusterKey(quorumStringInput, Integer.parseInt(clientPort), zNodeParent);
            }
            return new ZKClusterKey(ZKConfig.buildZKQuorumServerString(serverHosts, clientPort), Integer.parseInt(clientPort), zNodeParent);
        }
        throw new IOException("Cluster key passed " + key + " is invalid, the format should be:" + "hbase.zookeeper.quorum" + ":" + "hbase.zookeeper.property.clientPort" + ":" + "zookeeper.znode.parent");
    }

    public static String getZooKeeperClusterKey(Configuration conf) {
        return ZKConfig.getZooKeeperClusterKey(conf, null);
    }

    public static String getZooKeeperClusterKey(Configuration conf, String name) {
        String ensemble = conf.get("hbase.zookeeper.quorum").replaceAll("[\\t\\n\\x0B\\f\\r]", "");
        StringBuilder builder = new StringBuilder(ensemble);
        builder.append(":");
        builder.append(conf.get("hbase.zookeeper.property.clientPort"));
        builder.append(":");
        builder.append(conf.get("zookeeper.znode.parent"));
        if (name != null && !name.isEmpty()) {
            builder.append(",");
            builder.append(name);
        }
        return builder.toString();
    }

    @VisibleForTesting
    public static String standardizeZKQuorumServerString(String quorumStringInput, String clientPort) {
        String[] serverHosts = quorumStringInput.split(",");
        return ZKConfig.buildZKQuorumServerString(serverHosts, clientPort);
    }

    @VisibleForTesting
    public static class ZKClusterKey {
        private String quorumString;
        private int clientPort;
        private String znodeParent;

        ZKClusterKey(String quorumString, int clientPort, String znodeParent) {
            this.quorumString = quorumString;
            this.clientPort = clientPort;
            this.znodeParent = znodeParent;
        }

        public String getQuorumString() {
            return this.quorumString;
        }

        public int getClientPort() {
            return this.clientPort;
        }

        public String getZnodeParent() {
            return this.znodeParent;
        }
    }
}

