/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.io.ByteArrayOutputStream;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.NoneEncoder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowIndexEncoderV1 {
    private static final Log LOG = LogFactory.getLog(RowIndexEncoderV1.class);
    private Cell lastCell = null;
    private DataOutputStream out;
    private NoneEncoder encoder;
    private int startOffset = -1;
    private ByteArrayOutputStream rowsOffsetBAOS = new ByteArrayOutputStream(256);

    public RowIndexEncoderV1(DataOutputStream out, HFileBlockDefaultEncodingContext encodingCtx) {
        this.out = out;
        this.encoder = new NoneEncoder(out, encodingCtx);
    }

    public int write(Cell cell) throws IOException {
        if (!this.checkRow(cell)) {
            if (this.startOffset < 0) {
                this.startOffset = this.out.size();
            }
            this.rowsOffsetBAOS.writeInt(this.out.size() - this.startOffset);
        }
        this.lastCell = cell;
        return this.encoder.write(cell);
    }

    protected boolean checkRow(Cell cell) throws IOException {
        boolean isDuplicateRow = false;
        if (cell == null) {
            throw new IOException("Key cannot be null or empty");
        }
        if (this.lastCell != null) {
            int keyComp = CellComparatorImpl.COMPARATOR.compareRows(this.lastCell, cell);
            if (keyComp > 0) {
                throw new IOException("Added a key not lexically larger than previous. Current cell = " + cell + ", lastCell = " + this.lastCell);
            }
            if (keyComp == 0) {
                isDuplicateRow = true;
            }
        }
        return isDuplicateRow;
    }

    public void flush() throws IOException {
        int onDiskDataSize = 0;
        if (this.startOffset >= 0) {
            onDiskDataSize = this.out.size() - this.startOffset;
        }
        this.out.writeInt(this.rowsOffsetBAOS.size() / 4);
        if (this.rowsOffsetBAOS.size() > 0) {
            this.out.write(this.rowsOffsetBAOS.getBuffer(), 0, this.rowsOffsetBAOS.size());
        }
        this.out.writeInt(onDiskDataSize);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("RowNumber: " + this.rowsOffsetBAOS.size() / 4 + ", onDiskDataSize: " + onDiskDataSize + ", totalOnDiskSize: " + (this.out.size() - this.startOffset)));
        }
    }
}

