/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.util.JSONBean;
import org.codehaus.jettison.json.JSONException;

public final class JSONMetricUtil {
    private static final Log LOG = LogFactory.getLog(JSONMetricUtil.class);
    private static MBeanServer mbServer = ManagementFactory.getPlatformMBeanServer();
    public static final String JAVA_LANG_DOMAIN = "java.lang";
    public static final String JAVA_NIO_DOMAIN = "java.nio";
    public static final String SUN_MGMT_DOMAIN = "com.sun.management";
    public static final String HADOOP_DOMAIN = "Hadoop";
    public static final String TYPE_KEY = "type";
    public static final String NAME_KEY = "name";
    public static final String SERVICE_KEY = "service";
    public static final String SUBSYSTEM_KEY = "sub";

    private JSONMetricUtil() {
    }

    public static MBeanAttributeInfo[] getMBeanAttributeInfo(ObjectName bean) throws IntrospectionException, InstanceNotFoundException, ReflectionException, IntrospectionException, javax.management.IntrospectionException {
        MBeanInfo mbinfo = mbServer.getMBeanInfo(bean);
        return mbinfo.getAttributes();
    }

    public static Object getValueFromMBean(ObjectName bean, String attribute) {
        Object value = null;
        try {
            value = mbServer.getAttribute(bean, attribute);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to get value from MBean= " + bean.toString() + "for attribute=" + attribute + " " + e.getMessage()));
        }
        return value;
    }

    public static String dumpBeanToString(String qry) throws MalformedObjectNameException, IOException {
        StringWriter sw = new StringWriter(102400);
        try (PrintWriter writer = new PrintWriter(sw);){
            JSONBean dumper = new JSONBean();
            try (JSONBean.Writer jsonBeanWriter = dumper.open(writer);){
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                jsonBeanWriter.write(mbeanServer, new ObjectName(qry), null, false);
            }
        }
        sw.close();
        return sw.toString();
    }

    public static JsonNode mappStringToJsonNode(String jsonString) throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(jsonString);
        return node;
    }

    public static JsonNode searchJson(JsonNode tree, String searchKey) throws JsonProcessingException, IOException {
        if (tree == null) {
            return null;
        }
        if (tree.has(searchKey)) {
            return tree.get(searchKey);
        }
        if (tree.isContainerNode()) {
            for (JsonNode branch : tree) {
                JsonNode branchResult = JSONMetricUtil.searchJson(branch, searchKey);
                if (branchResult == null || branchResult.isMissingNode()) continue;
                return branchResult;
            }
        }
        return null;
    }

    public static Hashtable<String, String> buldKeyValueTable(String[] keys, String[] values) {
        if (keys.length != values.length) {
            LOG.error((Object)"keys and values arrays must be same size");
            return null;
        }
        if (keys.length == 0 || values.length == 0) {
            LOG.error((Object)"keys and values arrays can not be empty;");
            return null;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (int i = 0; i < keys.length; ++i) {
            table.put(keys[i], values[i]);
        }
        return table;
    }

    public static ObjectName buildObjectName(String pattern) throws MalformedObjectNameException {
        return new ObjectName(pattern);
    }

    public static ObjectName buildObjectName(String domain, Hashtable<String, String> keyValueTable) throws MalformedObjectNameException {
        return new ObjectName(domain, keyValueTable);
    }

    public static Set<ObjectName> getRegistredMBeans(ObjectName name, MBeanServer mbs) {
        return mbs.queryNames(name, null);
    }

    public static String getProcessPID() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public static String getCommmand() throws MalformedObjectNameException, IOException, JSONException {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        return runtimeBean.getSystemProperties().get("sun.java.command");
    }

    public static List<GarbageCollectorMXBean> getGcCollectorBeans() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        return gcBeans;
    }

    public static long getLastGcDuration(ObjectName gcCollector) {
        long lastGcDuration = 0L;
        Object lastGcInfo = JSONMetricUtil.getValueFromMBean(gcCollector, "LastGcInfo");
        if (lastGcInfo != null && lastGcInfo instanceof CompositeData) {
            CompositeData cds = (CompositeData)lastGcInfo;
            lastGcDuration = (Long)cds.get("duration");
        }
        return lastGcDuration;
    }

    public static List<MemoryPoolMXBean> getMemoryPools() {
        List<MemoryPoolMXBean> mPools = ManagementFactory.getMemoryPoolMXBeans();
        return mPools;
    }

    public static float calcPercentage(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0.0f;
        }
        return (float)a / (float)b * 100.0f;
    }
}

