/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.trace.HBaseHTraceConfiguration;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.Sampler;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.SpanReceiver;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

public final class TraceUtil {
    private static HTraceConfiguration conf;
    private static Tracer tracer;

    private TraceUtil() {
    }

    public static void initTracer(Configuration c) {
        if (c != null) {
            conf = new HBaseHTraceConfiguration(c);
        }
        if (tracer == null && conf != null) {
            tracer = new Tracer.Builder("Tracer").conf(conf).build();
        }
    }

    public static TraceScope createTrace(String description) {
        return tracer == null ? null : tracer.newScope(description);
    }

    public static TraceScope createTrace(String description, Span span) {
        if (span == null) {
            return TraceUtil.createTrace(description);
        }
        return tracer == null ? null : tracer.newScope(description, span.getSpanId());
    }

    public static boolean addSampler(Sampler sampler) {
        if (sampler == null) {
            return false;
        }
        return tracer == null ? false : tracer.addSampler(sampler);
    }

    public static void addKVAnnotation(String key, String value) {
        Span span = Tracer.getCurrentSpan();
        if (span != null) {
            span.addKVAnnotation(key, value);
        }
    }

    public static boolean addReceiver(SpanReceiver rcvr) {
        return tracer == null ? false : tracer.getTracerPool().addReceiver(rcvr);
    }

    public static boolean removeReceiver(SpanReceiver rcvr) {
        return tracer == null ? false : tracer.getTracerPool().removeReceiver(rcvr);
    }

    public static void addTimelineAnnotation(String msg) {
        Span span = Tracer.getCurrentSpan();
        if (span != null) {
            span.addTimelineAnnotation(msg);
        }
    }

    public static Runnable wrap(Runnable runnable, String description) {
        return tracer == null ? runnable : tracer.wrap(runnable, description);
    }
}

