/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class CommonFSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonFSUtils.class);
    public static final String HBASE_WAL_DIR = "hbase.wal.dir";
    public static final String UNSAFE_STREAM_CAPABILITY_ENFORCE = "hbase.unsafe.stream.capability.enforce";
    public static final String FULL_RWX_PERMISSIONS = "777";
    private static final Map<FileSystem, Boolean> warningMap = new ConcurrentHashMap<FileSystem, Boolean>();

    protected CommonFSUtils() {
    }

    public static boolean isStartingWithPath(Path rootPath, String path) {
        String uriRootPath = rootPath.toUri().getPath();
        String tailUriPath = new Path(path).toUri().getPath();
        return tailUriPath.startsWith(uriRootPath);
    }

    public static boolean isMatchingTail(Path pathToSearch, String pathTail) {
        return CommonFSUtils.isMatchingTail(pathToSearch, new Path(pathTail));
    }

    public static boolean isMatchingTail(Path pathToSearch, Path pathTail) {
        String toSearchName;
        String tailName;
        if (pathToSearch.depth() != pathTail.depth()) {
            return false;
        }
        Path tailPath = pathTail;
        Path toSearch = pathToSearch;
        boolean result = false;
        do {
            if ((tailName = tailPath.getName()) == null || tailName.length() <= 0) {
                result = true;
                break;
            }
            toSearchName = toSearch.getName();
            if (toSearchName == null || toSearchName.length() <= 0) break;
            tailPath = tailPath.getParent();
            toSearch = toSearch.getParent();
        } while (tailName.equals(toSearchName));
        return result;
    }

    public static boolean deleteDirectory(FileSystem fs, Path dir) throws IOException {
        return fs.exists(dir) && fs.delete(dir, true);
    }

    public static long getDefaultBlockSize(FileSystem fs, Path path) throws IOException {
        Method m = null;
        Class<?> cls = fs.getClass();
        try {
            m = cls.getMethod("getDefaultBlockSize", Path.class);
        }
        catch (NoSuchMethodException e) {
            LOG.info("FileSystem doesn't support getDefaultBlockSize");
        }
        catch (SecurityException e) {
            LOG.info("Doesn't have access to getDefaultBlockSize on FileSystems", (Throwable)e);
            m = null;
        }
        if (m == null) {
            return fs.getDefaultBlockSize(path);
        }
        try {
            Object ret = m.invoke((Object)fs, path);
            return (Long)ret;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static short getDefaultReplication(FileSystem fs, Path path) throws IOException {
        Method m = null;
        Class<?> cls = fs.getClass();
        try {
            m = cls.getMethod("getDefaultReplication", Path.class);
        }
        catch (NoSuchMethodException e) {
            LOG.info("FileSystem doesn't support getDefaultReplication");
        }
        catch (SecurityException e) {
            LOG.info("Doesn't have access to getDefaultReplication on FileSystems", (Throwable)e);
            m = null;
        }
        if (m == null) {
            return fs.getDefaultReplication(path);
        }
        try {
            Object ret = m.invoke((Object)fs, path);
            return ((Number)ret).shortValue();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static int getDefaultBufferSize(FileSystem fs) {
        return fs.getConf().getInt("io.file.buffer.size", 4096);
    }

    public static FSDataOutputStream create(FileSystem fs, Path path, FsPermission perm, boolean overwrite) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating file=" + path + " with permission=" + perm + ", overwrite=" + overwrite);
        }
        return fs.create(path, perm, overwrite, CommonFSUtils.getDefaultBufferSize(fs), CommonFSUtils.getDefaultReplication(fs, path), CommonFSUtils.getDefaultBlockSize(fs, path), null);
    }

    public static FsPermission getFilePermissions(FileSystem fs, Configuration conf, String permssionConfKey) {
        boolean enablePermissions = conf.getBoolean("hbase.data.umask.enable", false);
        if (enablePermissions) {
            try {
                FsPermission perm = new FsPermission(FULL_RWX_PERMISSIONS);
                String mask = conf.get(permssionConfKey);
                if (mask == null) {
                    return FsPermission.getFileDefault();
                }
                FsPermission umask = new FsPermission(mask);
                return perm.applyUMask(umask);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Incorrect umask attempted to be created: " + conf.get(permssionConfKey) + ", using default file permissions.", (Throwable)e);
                return FsPermission.getFileDefault();
            }
        }
        return FsPermission.getFileDefault();
    }

    public static Path validateRootPath(Path root) throws IOException {
        try {
            URI rootURI = new URI(root.toString());
            String scheme = rootURI.getScheme();
            if (scheme == null) {
                throw new IOException("Root directory does not have a scheme");
            }
            return root;
        }
        catch (URISyntaxException e) {
            IOException io = new IOException("Root directory path is not a valid URI -- check your hbase.rootdir configuration");
            io.initCause(e);
            throw io;
        }
    }

    public static String removeWALRootPath(Path path, Configuration conf) throws IOException {
        Path root = CommonFSUtils.getWALRootDir(conf);
        String pathStr = path.toString();
        if (!pathStr.startsWith(root.toString())) {
            return pathStr;
        }
        return pathStr.substring(root.toString().length() + 1);
    }

    public static String getPath(Path p) {
        return p.toUri().getPath();
    }

    public static Path getRootDir(Configuration c) throws IOException {
        Path p = new Path(c.get("hbase.rootdir"));
        FileSystem fs = p.getFileSystem(c);
        return p.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    public static void setRootDir(Configuration c, Path root) throws IOException {
        c.set("hbase.rootdir", root.toString());
    }

    public static void setFsDefault(Configuration c, Path root) throws IOException {
        c.set("fs.defaultFS", root.toString());
    }

    public static FileSystem getRootDirFileSystem(Configuration c) throws IOException {
        Path p = CommonFSUtils.getRootDir(c);
        return p.getFileSystem(c);
    }

    public static Path getWALRootDir(Configuration c) throws IOException {
        Path p = new Path(c.get(HBASE_WAL_DIR, c.get("hbase.rootdir")));
        if (!CommonFSUtils.isValidWALRootDir(p, c)) {
            return CommonFSUtils.getRootDir(c);
        }
        FileSystem fs = p.getFileSystem(c);
        return p.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    @VisibleForTesting
    public static void setWALRootDir(Configuration c, Path root) throws IOException {
        c.set(HBASE_WAL_DIR, root.toString());
    }

    public static FileSystem getWALFileSystem(Configuration c) throws IOException {
        Path p = CommonFSUtils.getWALRootDir(c);
        return p.getFileSystem(c);
    }

    private static boolean isValidWALRootDir(Path walDir, Configuration c) throws IOException {
        Path rootDir = CommonFSUtils.getRootDir(c);
        FileSystem fs = walDir.getFileSystem(c);
        Path qualifiedWalDir = walDir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        if (!qualifiedWalDir.equals((Object)rootDir) && qualifiedWalDir.toString().startsWith(rootDir.toString() + "/")) {
            throw new IllegalStateException("Illegal WAL directory specified. WAL directories are not permitted to be under the root directory if set.");
        }
        return true;
    }

    public static Path getTableDir(Path rootdir, TableName tableName) {
        return new Path(CommonFSUtils.getNamespaceDir(rootdir, tableName.getNamespaceAsString()), tableName.getQualifierAsString());
    }

    public static TableName getTableName(Path tablePath) {
        return TableName.valueOf(tablePath.getParent().getName(), tablePath.getName());
    }

    public static Path getNamespaceDir(Path rootdir, String namespace) {
        return new Path(rootdir, new Path("data", new Path(namespace)));
    }

    public static void setStoragePolicy(FileSystem fs, Configuration conf, Path path, String policyKey, String defaultPolicy) {
        String storagePolicy = conf.get(policyKey, defaultPolicy).toUpperCase(Locale.ROOT);
        if (storagePolicy.equals(defaultPolicy)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("default policy of " + defaultPolicy + " requested, exiting early.");
            }
            return;
        }
        CommonFSUtils.setStoragePolicy(fs, path, storagePolicy);
    }

    public static void setStoragePolicy(FileSystem fs, Path path, String storagePolicy) {
        if (storagePolicy == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("We were passed a null storagePolicy, exiting early.");
            }
            return;
        }
        String trimmedStoragePolicy = storagePolicy.trim();
        if (trimmedStoragePolicy.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("We were passed an empty storagePolicy, exiting early.");
            }
            return;
        }
        CommonFSUtils.invokeSetStoragePolicy(fs, path, trimmedStoragePolicy);
    }

    private static void invokeSetStoragePolicy(FileSystem fs, Path path, String storagePolicy) {
        block18: {
            String msg;
            Method m = null;
            try {
                m = fs.getClass().getDeclaredMethod("setStoragePolicy", Path.class, String.class);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                msg = "FileSystem doesn't support setStoragePolicy; HDFS-6584, HDFS-9345 not available. This is normal and expected on earlier Hadoop versions.";
                if (!warningMap.containsKey(fs)) {
                    warningMap.put(fs, true);
                    LOG.warn("FileSystem doesn't support setStoragePolicy; HDFS-6584, HDFS-9345 not available. This is normal and expected on earlier Hadoop versions.", (Throwable)e);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("FileSystem doesn't support setStoragePolicy; HDFS-6584, HDFS-9345 not available. This is normal and expected on earlier Hadoop versions.", (Throwable)e);
                }
                m = null;
            }
            catch (SecurityException e) {
                msg = "No access to setStoragePolicy on FileSystem from the SecurityManager; HDFS-6584, HDFS-9345 not available. This is unusual and probably warrants an email to the user@hbase mailing list. Please be sure to include a link to your configs, and logs that include this message and period of time before it. Logs around service start up will probably be useful as well.";
                if (!warningMap.containsKey(fs)) {
                    warningMap.put(fs, true);
                    LOG.warn("No access to setStoragePolicy on FileSystem from the SecurityManager; HDFS-6584, HDFS-9345 not available. This is unusual and probably warrants an email to the user@hbase mailing list. Please be sure to include a link to your configs, and logs that include this message and period of time before it. Logs around service start up will probably be useful as well.", (Throwable)e);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("No access to setStoragePolicy on FileSystem from the SecurityManager; HDFS-6584, HDFS-9345 not available. This is unusual and probably warrants an email to the user@hbase mailing list. Please be sure to include a link to your configs, and logs that include this message and period of time before it. Logs around service start up will probably be useful as well.", (Throwable)e);
                }
                m = null;
            }
            if (m != null) {
                try {
                    m.invoke((Object)fs, path, storagePolicy);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Set storagePolicy=" + storagePolicy + " for path=" + path);
                    }
                }
                catch (Exception e) {
                    if (!warningMap.containsKey(fs)) {
                        warningMap.put(fs, true);
                        LOG.warn("Unable to set storagePolicy=" + storagePolicy + " for path=" + path + ". DEBUG log level might have more details.", (Throwable)e);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Unable to set storagePolicy=" + storagePolicy + " for path=" + path, (Throwable)e);
                    }
                    if (!(e instanceof InvocationTargetException)) break block18;
                    Throwable exception = e.getCause();
                    if (exception instanceof RemoteException && HadoopIllegalArgumentException.class.getName().equals(((RemoteException)exception).getClassName())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Given storage policy, '" + storagePolicy + "', was rejected and probably isn't a valid policy for the version of Hadoop you're running. I.e. if you're trying to use SSD related policies then you're likely missing HDFS-7228. For more information see the 'ArchivalStorage' docs for your Hadoop release.");
                        }
                    }
                    if (!(exception instanceof UnsupportedOperationException) || !LOG.isDebugEnabled()) break block18;
                    LOG.debug("The underlying FileSystem implementation doesn't support setStoragePolicy. This is probably intentional on their part, since HDFS-9345 appears to be present in your version of Hadoop. For more information check the Hadoop documentation on 'ArchivalStorage', the Hadoop FileSystem specification docs from HADOOP-11981, and/or related documentation from the provider of the underlying FileSystem (its name should appear in the stacktrace that accompanies this message). Note in particular that Hadoop's local filesystem implementation doesn't support storage policies.", exception);
                }
            }
        }
    }

    public static boolean isHDFS(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        String scheme = fs.getUri().getScheme();
        return scheme.equalsIgnoreCase("hdfs");
    }

    public static boolean isRecoveredEdits(Path path) {
        return path.toString().contains("recovered.edits");
    }

    public static FileSystem getCurrentFileSystem(Configuration conf) throws IOException {
        return CommonFSUtils.getRootDir(conf).getFileSystem(conf);
    }

    public static FileStatus[] listStatus(FileSystem fs, Path dir, PathFilter filter) throws IOException {
        FileStatus[] status;
        block3: {
            status = null;
            try {
                status = filter == null ? fs.listStatus(dir) : fs.listStatus(dir, filter);
            }
            catch (FileNotFoundException fnfe) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace(dir + " doesn't exist");
            }
        }
        if (status == null || status.length < 1) {
            return null;
        }
        return status;
    }

    public static FileStatus[] listStatus(FileSystem fs, Path dir) throws IOException {
        return CommonFSUtils.listStatus(fs, dir, null);
    }

    public static List<LocatedFileStatus> listLocatedStatus(FileSystem fs, Path dir) throws IOException {
        ArrayList status;
        block4: {
            status = null;
            try {
                RemoteIterator locatedFileStatusRemoteIterator = fs.listFiles(dir, false);
                while (locatedFileStatusRemoteIterator.hasNext()) {
                    if (status == null) {
                        status = Lists.newArrayList();
                    }
                    status.add(locatedFileStatusRemoteIterator.next());
                }
            }
            catch (FileNotFoundException fnfe) {
                if (!LOG.isTraceEnabled()) break block4;
                LOG.trace(dir + " doesn't exist");
            }
        }
        return status;
    }

    public static boolean delete(FileSystem fs, Path path, boolean recursive) throws IOException {
        return fs.delete(path, recursive);
    }

    public static boolean isExists(FileSystem fs, Path path) throws IOException {
        return fs.exists(path);
    }

    public static void logFileSystemState(FileSystem fs, Path root, Logger LOG) throws IOException {
        LOG.debug("File system contents for path " + root);
        CommonFSUtils.logFSTree(LOG, fs, root, "|-");
    }

    private static void logFSTree(Logger LOG, FileSystem fs, Path root, String prefix) throws IOException {
        FileStatus[] files = CommonFSUtils.listStatus(fs, root, null);
        if (files == null) {
            return;
        }
        for (FileStatus file : files) {
            if (file.isDirectory()) {
                LOG.debug(prefix + file.getPath().getName() + "/");
                CommonFSUtils.logFSTree(LOG, fs, file.getPath(), prefix + "---");
                continue;
            }
            LOG.debug(prefix + file.getPath().getName());
        }
    }

    public static boolean renameAndSetModifyTime(FileSystem fs, Path src, Path dest) throws IOException {
        fs.setTimes(src, EnvironmentEdgeManager.currentTime(), -1L);
        return fs.rename(src, dest);
    }

    public static void setupShortCircuitRead(Configuration conf) {
        boolean shortCircuitSkipChecksum = conf.getBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        boolean useHBaseChecksum = conf.getBoolean("hbase.regionserver.checksum.verify", true);
        if (shortCircuitSkipChecksum) {
            LOG.warn("Configuration \"dfs.client.read.shortcircuit.skip.checksum\" should not be set to true." + (useHBaseChecksum ? " HBase checksum doesn't require it, see https://issues.apache.org/jira/browse/HBASE-6868." : ""));
            assert (!shortCircuitSkipChecksum);
        }
        CommonFSUtils.checkShortCircuitReadBufferSize(conf);
    }

    public static void checkShortCircuitReadBufferSize(Configuration conf) {
        int defaultSize = 131072;
        int notSet = -1;
        String dfsKey = "dfs.client.read.shortcircuit.buffer.size";
        int size = conf.getInt("dfs.client.read.shortcircuit.buffer.size", -1);
        if (size != -1) {
            return;
        }
        int hbaseSize = conf.getInt("hbase.dfs.client.read.shortcircuit.buffer.size", 131072);
        conf.setIfUnset("dfs.client.read.shortcircuit.buffer.size", Integer.toString(hbaseSize));
    }

    public static boolean hasCapability(FSDataOutputStream stream, String capability) {
        if (stream == null) {
            throw new NullPointerException("stream parameter must not be null.");
        }
        boolean result = true;
        if (StreamCapabilities.PRESENT) {
            result = false;
            if (StreamCapabilities.CLASS.isAssignableFrom(stream.getClass())) {
                try {
                    result = (Boolean)StreamCapabilities.METHOD.invoke((Object)stream, capability);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    LOG.warn("Your Hadoop installation's StreamCapabilities implementation doesn't match our understanding of how it's supposed to work. Please file a JIRA and include the following stack trace. In the mean time we're interpreting this behavior difference as a lack of capability support, which will probably cause a failure.", (Throwable)exception);
                }
            }
        }
        return result;
    }

    public static class StreamLacksCapabilityException
    extends Exception {
        public StreamLacksCapabilityException(String message, Throwable cause) {
            super(message, cause);
        }

        public StreamLacksCapabilityException(String message) {
            super(message);
        }
    }

    private static class StreamCapabilities {
        public static final boolean PRESENT;
        public static final Class<?> CLASS;
        public static final Method METHOD;

        private StreamCapabilities() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            boolean tmp = false;
            Class<?> clazz = null;
            Method method = null;
            try {
                clazz = Class.forName("org.apache.hadoop.fs.StreamCapabilities");
                method = clazz.getMethod("hasCapability", String.class);
                tmp = true;
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                LOG.warn("Your Hadoop installation does not include the StreamCapabilities class from HDFS-11644, so we will skip checking if any FSDataOutputStreams actually support hflush/hsync. If you are running on top of HDFS this probably just means you have an older version and this can be ignored. If you are running on top of an alternate FileSystem implementation you should manually verify that hflush and hsync are implemented; otherwise you risk data loss and hard to diagnose errors when our assumptions are violated.");
                LOG.debug("The first request to check for StreamCapabilities came from this stacktrace.", (Throwable)exception);
            }
            finally {
                PRESENT = tmp;
                CLASS = clazz;
                METHOD = method;
            }
        }
    }
}

