/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.master.MetricsMasterSource;
import org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MetricMutableHistogram;

public class MetricsMasterSourceImpl
extends BaseSourceImpl
implements MetricsMasterSource {
    private static final Log LOG = LogFactory.getLog((String)MetricsMasterSourceImpl.class.getName());
    private final MetricsMasterWrapper masterWrapper;
    private MetricMutableCounterLong clusterRequestsCounter;
    private MetricMutableGaugeLong ritGauge;
    private MetricMutableGaugeLong ritCountOverThresholdGauge;
    private MetricMutableGaugeLong ritOldestAgeGauge;
    private MetricMutableHistogram splitTimeHisto;
    private MetricMutableHistogram splitSizeHisto;

    public MetricsMasterSourceImpl(MetricsMasterWrapper masterWrapper) {
        this("Server", "Metrics about HBase master server", "master", "Master,sub=Server", masterWrapper);
    }

    public MetricsMasterSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsMasterWrapper masterWrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.masterWrapper = masterWrapper;
    }

    @Override
    public void init() {
        super.init();
        this.clusterRequestsCounter = this.metricsRegistry.newCounter("clusterRequests", "", 0L);
        this.ritGauge = this.metricsRegistry.newGauge("ritCount", "", 0L);
        this.ritCountOverThresholdGauge = this.metricsRegistry.newGauge("ritCountOverThreshold", "", 0L);
        this.ritOldestAgeGauge = this.metricsRegistry.newGauge("ritOldestAge", "", 0L);
        this.splitTimeHisto = this.metricsRegistry.newHistogram("hlogSplitSize", "Size of HLog files being split");
        this.splitSizeHisto = this.metricsRegistry.newHistogram("hlogSplitTime", "Time it takes to finish HLog.splitLog()");
    }

    public void incRequests(int inc) {
        this.clusterRequestsCounter.incr((long)inc);
    }

    public void setRIT(int ritCount) {
        this.ritGauge.set((long)ritCount);
    }

    public void setRITCountOverThreshold(int ritCount) {
        this.ritCountOverThresholdGauge.set((long)ritCount);
    }

    public void setRITOldestAge(long ritCount) {
        this.ritOldestAgeGauge.set(ritCount);
    }

    public void updateSplitTime(long time) {
        this.splitTimeHisto.add(time);
    }

    public void updateSplitSize(long size) {
        this.splitSizeHisto.add(size);
    }

    @Override
    public void getMetrics(MetricsBuilder metricsBuilder, boolean all) {
        MetricsRecordBuilder metricsRecordBuilder = metricsBuilder.addRecord(this.metricsName).setContext(this.metricsContext);
        if (this.masterWrapper != null) {
            metricsRecordBuilder.addGauge("masterActiveTime", "Master Active Time", this.masterWrapper.getActiveTime()).addGauge("masterStartTime", "Master Start Time", this.masterWrapper.getStartTime()).addGauge("averageLoad", "AverageLoad", this.masterWrapper.getAverageLoad()).addGauge("numRegionServers", "Number of RegionServers", this.masterWrapper.getRegionServers()).addGauge("numDeadRegionServers", "Number of dead RegionServers", this.masterWrapper.getDeadRegionServers()).tag("zookeeperQuorum", "Zookeeper Quorum", this.masterWrapper.getZookeeperQuorum()).tag("serverName", "Server Name", this.masterWrapper.getServerName()).tag("clusterId", "Cluster Id", this.masterWrapper.getClusterId()).tag("isActiveMaster", "Is Active Master", String.valueOf(this.masterWrapper.getIsActiveMaster()));
        }
        this.metricsRegistry.snapshot(metricsRecordBuilder, all);
    }
}

