/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSourceImpl;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;

public class MetricsRegionAggregateSourceImpl
extends BaseSourceImpl
implements MetricsRegionAggregateSource {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private final TreeSet<MetricsRegionSourceImpl> regionSources = new TreeSet();

    public MetricsRegionAggregateSourceImpl() {
        this("Regions", "Metrics about HBase RegionServer regions and tables", "regionserver", "RegionServer,sub=Regions");
    }

    public MetricsRegionAggregateSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    public void register(MetricsRegionSource source) {
        this.regionSources.add((MetricsRegionSourceImpl)source);
    }

    public void deregister(MetricsRegionSource source) {
        this.regionSources.remove(source);
    }

    @Override
    public void getMetrics(MetricsBuilder metricsBuilder, boolean all) {
        MetricsRecordBuilder mrb = metricsBuilder.addRecord(this.metricsName).setContext(this.metricsContext);
        if (this.regionSources != null) {
            for (MetricsRegionSourceImpl regionMetricSource : this.regionSources) {
                regionMetricSource.snapshot(mrb, all);
            }
        }
        this.metricsRegistry.snapshot(mrb, all);
    }
}

