/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.impl.JmxCacheBuster;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;

public class MetricsRegionSourceImpl
implements MetricsRegionSource {
    private final MetricsRegionWrapper regionWrapper;
    private boolean closed = false;
    private MetricsRegionAggregateSourceImpl agg;
    private DynamicMetricsRegistry registry;
    private static final Log LOG = LogFactory.getLog(MetricsRegionSourceImpl.class);
    private String regionNamePrefix;
    private String regionPutKey;
    private String regionDeleteKey;
    private String regionGetKey;
    private String regionIncrementKey;
    private String regionAppendKey;
    private MetricMutableCounterLong regionPut;
    private MetricMutableCounterLong regionDelete;
    private MetricMutableCounterLong regionGet;
    private MetricMutableCounterLong regionIncrement;
    private MetricMutableCounterLong regionAppend;

    public MetricsRegionSourceImpl(MetricsRegionWrapper regionWrapper, MetricsRegionAggregateSourceImpl aggregate) {
        this.regionWrapper = regionWrapper;
        this.agg = aggregate;
        this.agg.register(this);
        LOG.debug((Object)("Creating new MetricsRegionSourceImpl for table " + regionWrapper.getTableName() + " " + regionWrapper.getRegionName()));
        this.registry = this.agg.getMetricsRegistry();
        this.regionNamePrefix = "table." + regionWrapper.getTableName() + "." + "region." + regionWrapper.getRegionName() + ".";
        String suffix = "Count";
        this.regionPutKey = this.regionNamePrefix + "mutate" + suffix;
        this.regionPut = this.registry.getLongCounter(this.regionPutKey, 0L);
        this.regionDeleteKey = this.regionNamePrefix + "delete" + suffix;
        this.regionDelete = this.registry.getLongCounter(this.regionDeleteKey, 0L);
        this.regionGetKey = this.regionNamePrefix + "get" + suffix;
        this.regionGet = this.registry.getLongCounter(this.regionGetKey, 0L);
        this.regionIncrementKey = this.regionNamePrefix + "increment" + suffix;
        this.regionIncrement = this.registry.getLongCounter(this.regionIncrementKey, 0L);
        this.regionAppendKey = this.regionNamePrefix + "append" + suffix;
        this.regionAppend = this.registry.getLongCounter(this.regionAppendKey, 0L);
    }

    public void close() {
        this.closed = true;
        this.agg.deregister(this);
        LOG.trace((Object)("Removing region Metrics: " + this.regionWrapper.getRegionName()));
        this.registry.removeMetric(this.regionPutKey);
        this.registry.removeMetric(this.regionDeleteKey);
        this.registry.removeMetric(this.regionGetKey);
        this.registry.removeMetric(this.regionIncrementKey);
        this.registry.removeMetric(this.regionAppendKey);
        JmxCacheBuster.clearJmxCache();
    }

    public void updatePut() {
        this.regionPut.incr();
    }

    public void updateDelete() {
        this.regionDelete.incr();
    }

    public void updateGet() {
        this.regionGet.incr();
    }

    public void updateIncrement() {
        this.regionIncrement.incr();
    }

    public void updateAppend() {
        this.regionAppend.incr();
    }

    public MetricsRegionAggregateSource getAggregateSource() {
        return this.agg;
    }

    public int compareTo(MetricsRegionSource source) {
        if (!(source instanceof MetricsRegionSourceImpl)) {
            return -1;
        }
        MetricsRegionSourceImpl impl = (MetricsRegionSourceImpl)source;
        return this.regionWrapper.getRegionName().compareTo(impl.regionWrapper.getRegionName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MetricsRegionSourceImpl)) {
            return false;
        }
        return this.compareTo((MetricsRegionSourceImpl)obj) == 0;
    }

    void snapshot(MetricsRecordBuilder mrb, boolean ignored) {
        if (this.closed) {
            return;
        }
        mrb.addGauge(this.regionNamePrefix + "storeCount", "Number of Stores", this.regionWrapper.getNumStores());
        mrb.addGauge(this.regionNamePrefix + "storeFileCount", "Number of Store Files", this.regionWrapper.getNumStoreFiles());
        mrb.addGauge(this.regionNamePrefix + "memStoreSize", "Size of the memstore", this.regionWrapper.getMemstoreSize());
        mrb.addGauge(this.regionNamePrefix + "storeFileSize", "Size of storefiles being served.", this.regionWrapper.getStoreFileSize());
        mrb.addCounter(this.regionNamePrefix + "readRequestCount", "Number of read requests this region server has answered.", this.regionWrapper.getReadRequestCount());
        mrb.addCounter(this.regionNamePrefix + "writeRequestCount", "Number of mutation requests this region server has answered.", this.regionWrapper.getWriteRequestCount());
    }
}

