/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.thrift.MetricsThriftServerSource;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MetricMutableStat;

public class MetricsThriftServerSourceImpl
extends BaseSourceImpl
implements MetricsThriftServerSource {
    private MetricMutableStat batchGetStat;
    private MetricMutableStat batchMutateStat;
    private MetricMutableStat queueTimeStat;
    private MetricMutableStat thriftCallStat;
    private MetricMutableStat thriftSlowCallStat;
    private MetricMutableGaugeLong callQueueLenGauge;

    public MetricsThriftServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        super.init();
        this.batchGetStat = this.getMetricsRegistry().newStat("batchGet", "", "Keys", "Ops");
        this.batchMutateStat = this.getMetricsRegistry().newStat("batchMutate", "", "Keys", "Ops");
        this.queueTimeStat = this.getMetricsRegistry().newStat("timeInQueue");
        this.thriftCallStat = this.getMetricsRegistry().newStat("thriftCall");
        this.thriftSlowCallStat = this.getMetricsRegistry().newStat("slowThriftCall");
        this.callQueueLenGauge = this.getMetricsRegistry().getLongGauge("callQueueLen", 0L);
    }

    public void incTimeInQueue(long time) {
        this.queueTimeStat.add(time);
    }

    public void setCallQueueLen(int len) {
        this.callQueueLenGauge.set((long)len);
    }

    public void incNumRowKeysInBatchGet(int diff) {
        this.batchGetStat.add((long)diff);
    }

    public void incNumRowKeysInBatchMutate(int diff) {
        this.batchMutateStat.add((long)diff);
    }

    public void incMethodTime(String name, long time) {
        MetricMutableStat s = this.getMetricsRegistry().newStat(name);
        s.add(time);
    }

    public void incCall(long time) {
        this.thriftCallStat.add(time);
    }

    public void incSlowCall(long time) {
        this.thriftSlowCallStat.add(time);
    }
}

