/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;

public class Action {
    public static final String KILL_MASTER_TIMEOUT_KEY = "hbase.chaosmonkey.action.killmastertimeout";
    public static final String START_MASTER_TIMEOUT_KEY = "hbase.chaosmonkey.action.startmastertimeout";
    public static final String KILL_RS_TIMEOUT_KEY = "hbase.chaosmonkey.action.killrstimeout";
    public static final String START_RS_TIMEOUT_KEY = "hbase.chaosmonkey.action.startrstimeout";
    public static final String KILL_ZK_NODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.killzknodetimeout";
    public static final String START_ZK_NODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.startzknodetimeout";
    public static final String KILL_DATANODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.killdatanodetimeout";
    public static final String START_DATANODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.startdatanodetimeout";
    protected static Log LOG = LogFactory.getLog(Action.class);
    protected static final long KILL_MASTER_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_MASTER_TIMEOUT_DEFAULT = 60000L;
    protected static final long KILL_RS_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_RS_TIMEOUT_DEFAULT = 60000L;
    protected static final long KILL_ZK_NODE_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_ZK_NODE_TIMEOUT_DEFAULT = 60000L;
    protected static final long KILL_DATANODE_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_DATANODE_TIMEOUT_DEFAULT = 60000L;
    protected ActionContext context;
    protected HBaseCluster cluster;
    protected ClusterStatus initialStatus;
    protected ServerName[] initialServers;
    protected long killMasterTimeout;
    protected long startMasterTimeout;
    protected long killRsTimeout;
    protected long startRsTimeout;
    protected long killZkNodeTimeout;
    protected long startZkNodeTimeout;
    protected long killDataNodeTimeout;
    protected long startDataNodeTimeout;

    public void init(ActionContext context) throws IOException {
        this.context = context;
        this.cluster = context.getHBaseCluster();
        this.initialStatus = this.cluster.getInitialClusterStatus();
        Collection regionServers = this.initialStatus.getServers();
        this.initialServers = regionServers.toArray(new ServerName[regionServers.size()]);
        this.killMasterTimeout = this.cluster.getConf().getLong(KILL_MASTER_TIMEOUT_KEY, 60000L);
        this.startMasterTimeout = this.cluster.getConf().getLong(START_MASTER_TIMEOUT_KEY, 60000L);
        this.killRsTimeout = this.cluster.getConf().getLong(KILL_RS_TIMEOUT_KEY, 60000L);
        this.startRsTimeout = this.cluster.getConf().getLong(START_RS_TIMEOUT_KEY, 60000L);
        this.killZkNodeTimeout = this.cluster.getConf().getLong(KILL_ZK_NODE_TIMEOUT_KEY, 60000L);
        this.startZkNodeTimeout = this.cluster.getConf().getLong(START_ZK_NODE_TIMEOUT_KEY, 60000L);
        this.killDataNodeTimeout = this.cluster.getConf().getLong(KILL_DATANODE_TIMEOUT_KEY, 60000L);
        this.startDataNodeTimeout = this.cluster.getConf().getLong(START_DATANODE_TIMEOUT_KEY, 60000L);
    }

    public void perform() throws Exception {
    }

    protected ServerName[] getCurrentServers() throws IOException {
        int count;
        ClusterStatus clusterStatus = this.cluster.getClusterStatus();
        Collection regionServers = clusterStatus.getServers();
        int n = count = regionServers == null ? 0 : regionServers.size();
        if (count <= 0) {
            return new ServerName[0];
        }
        ServerName master = clusterStatus.getMaster();
        if (master == null || !regionServers.contains(master)) {
            return regionServers.toArray(new ServerName[count]);
        }
        if (count == 1) {
            return new ServerName[0];
        }
        ArrayList tmp = new ArrayList(count);
        tmp.addAll(regionServers);
        tmp.remove(master);
        return tmp.toArray(new ServerName[count - 1]);
    }

    protected void killMaster(ServerName server) throws IOException {
        LOG.info((Object)("Killing master:" + server));
        this.cluster.killMaster(server);
        this.cluster.waitForMasterToStop(server, this.killMasterTimeout);
        LOG.info((Object)("Killed master server:" + server));
    }

    protected void startMaster(ServerName server) throws IOException {
        LOG.info((Object)("Starting master:" + server.getHostname()));
        this.cluster.startMaster(server.getHostname(), server.getPort());
        this.cluster.waitForActiveAndReadyMaster(this.startMasterTimeout);
        LOG.info((Object)("Started master: " + server));
    }

    protected void killRs(ServerName server) throws IOException {
        LOG.info((Object)("Killing region server:" + server));
        this.cluster.killRegionServer(server);
        this.cluster.waitForRegionServerToStop(server, this.killRsTimeout);
        LOG.info((Object)("Killed region server:" + server + ". Reported num of rs:" + this.cluster.getClusterStatus().getServersSize()));
    }

    protected void startRs(ServerName server) throws IOException {
        LOG.info((Object)("Starting region server:" + server.getHostname()));
        this.cluster.startRegionServer(server.getHostname(), server.getPort());
        this.cluster.waitForRegionServerToStart(server.getHostname(), server.getPort(), this.startRsTimeout);
        LOG.info((Object)("Started region server:" + server + ". Reported num of rs:" + this.cluster.getClusterStatus().getServersSize()));
    }

    protected void killZKNode(ServerName server) throws IOException {
        LOG.info((Object)("Killing zookeeper node:" + server));
        this.cluster.killZkNode(server);
        this.cluster.waitForZkNodeToStop(server, this.killZkNodeTimeout);
        LOG.info((Object)("Killed zookeeper node:" + server + ". Reported num of rs:" + this.cluster.getClusterStatus().getServersSize()));
    }

    protected void startZKNode(ServerName server) throws IOException {
        LOG.info((Object)("Starting zookeeper node:" + server.getHostname()));
        this.cluster.startZkNode(server.getHostname(), server.getPort());
        this.cluster.waitForZkNodeToStart(server, this.startZkNodeTimeout);
        LOG.info((Object)("Started zookeeper node:" + server));
    }

    protected void killDataNode(ServerName server) throws IOException {
        LOG.info((Object)("Killing datanode:" + server));
        this.cluster.killDataNode(server);
        this.cluster.waitForDataNodeToStop(server, this.killDataNodeTimeout);
        LOG.info((Object)("Killed datanode:" + server + ". Reported num of rs:" + this.cluster.getClusterStatus().getServersSize()));
    }

    protected void startDataNode(ServerName server) throws IOException {
        LOG.info((Object)("Starting datanode:" + server.getHostname()));
        this.cluster.startDataNode(server);
        this.cluster.waitForDataNodeToStart(server, this.startDataNodeTimeout);
        LOG.info((Object)("Started datanode:" + server));
    }

    protected void unbalanceRegions(ClusterStatus clusterStatus, List<ServerName> fromServers, List<ServerName> toServers, double fractionOfRegions) throws Exception {
        LinkedList<byte[]> victimRegions = new LinkedList<byte[]>();
        for (ServerName server : fromServers) {
            ServerLoad serverLoad = clusterStatus.getLoad(server);
            LinkedList regions = new LinkedList(serverLoad.getRegionsLoad().keySet());
            int victimRegionCount = (int)Math.ceil(fractionOfRegions * (double)regions.size());
            LOG.debug((Object)("Removing " + victimRegionCount + " regions from " + server.getServerName()));
            for (int i = 0; i < victimRegionCount; ++i) {
                int victimIx = RandomUtils.nextInt((int)regions.size());
                String regionId = HRegionInfo.encodeRegionName((byte[])((byte[])regions.remove(victimIx)));
                victimRegions.add(Bytes.toBytes((String)regionId));
            }
        }
        LOG.info((Object)("Moving " + victimRegions.size() + " regions from " + fromServers.size() + " servers to " + toServers.size() + " different servers"));
        HBaseAdmin admin = this.context.getHBaseIntegrationTestingUtility().getHBaseAdmin();
        for (byte[] victimRegion : victimRegions) {
            int targetIx = RandomUtils.nextInt((int)toServers.size());
            admin.move(victimRegion, Bytes.toBytes((String)toServers.get(targetIx).getServerName()));
        }
    }

    protected void forceBalancer() throws Exception {
        HBaseAdmin admin = this.context.getHBaseIntegrationTestingUtility().getHBaseAdmin();
        boolean result = false;
        try {
            result = admin.balancer();
        }
        catch (Exception e) {
            LOG.warn((Object)"Got exception while doing balance ", (Throwable)e);
        }
        if (!result) {
            LOG.error((Object)"Balancer didn't succeed");
        }
    }

    public Configuration getConf() {
        return this.cluster.getConf();
    }

    public static class ActionContext {
        private IntegrationTestingUtility util;

        public ActionContext(IntegrationTestingUtility util) {
            this.util = util;
        }

        public IntegrationTestingUtility getHBaseIntegrationTestingUtility() {
            return this.util;
        }

        public HBaseCluster getHBaseCluster() {
            return this.util.getHBaseClusterInterface();
        }
    }
}

