/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.io.compress.Compressor;

public class ChangeCompressionAction
extends Action {
    private final TableName tableName;
    private Admin admin;
    private Random random;

    public ChangeCompressionAction(TableName tableName) {
        this.tableName = tableName;
        this.random = new Random();
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        super.init(context);
        this.admin = context.getHBaseIntegrationTestingUtility().getHBaseAdmin();
    }

    @Override
    public void perform() throws Exception {
        Compression.Algorithm algo;
        HTableDescriptor tableDescriptor = this.admin.getTableDescriptor(this.tableName);
        HColumnDescriptor[] columnDescriptors = tableDescriptor.getColumnFamilies();
        if (columnDescriptors == null || columnDescriptors.length == 0) {
            return;
        }
        Compression.Algorithm[] possibleAlgos = Compression.Algorithm.values();
        while (true) {
            algo = possibleAlgos[this.random.nextInt(possibleAlgos.length)];
            try {
                Compressor c = algo.getCompressor();
                algo.returnCompressor(c);
            }
            catch (Throwable t) {
                LOG.info((Object)("Performing action: Changing compression algorithms to " + algo + " is not supported, pick another one"));
                continue;
            }
            break;
        }
        LOG.debug((Object)("Performing action: Changing compression algorithms on " + this.tableName.getNameAsString() + " to " + algo));
        for (HColumnDescriptor descriptor : columnDescriptors) {
            if (this.random.nextBoolean()) {
                descriptor.setCompactionCompressionType(algo);
                continue;
            }
            descriptor.setCompressionType(algo);
        }
        this.admin.modifyTable(this.tableName, tableDescriptor);
    }
}

