/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.factories.MonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.junit.After;
import org.junit.Before;

public abstract class IntegrationTestBase
extends AbstractHBaseTool {
    public static final String NO_CLUSTER_CLEANUP_LONG_OPT = "noClusterCleanUp";
    public static final String MONKEY_LONG_OPT = "monkey";
    public static final String CHAOS_MONKEY_PROPS = "monkeyProps";
    private static final Log LOG = LogFactory.getLog(IntegrationTestBase.class);
    protected IntegrationTestingUtility util;
    protected ChaosMonkey monkey;
    protected String monkeyToUse;
    protected Properties monkeyProps;
    protected boolean noClusterCleanUp = false;

    public IntegrationTestBase() {
        this(null);
    }

    public IntegrationTestBase(String monkeyToUse) {
        this.monkeyToUse = monkeyToUse;
    }

    protected void addOptions() {
        this.addOptWithArg("m", MONKEY_LONG_OPT, "Which chaos monkey to run");
        this.addOptNoArg("ncc", NO_CLUSTER_CLEANUP_LONG_OPT, "Don't clean up the cluster at the end");
        this.addOptWithArg(CHAOS_MONKEY_PROPS, "The properties file for specifying chaos monkey properties.");
    }

    protected void processBaseOptions(CommandLine cmd) {
        String chaosMonkeyPropsFile;
        if (cmd.hasOption(MONKEY_LONG_OPT)) {
            this.monkeyToUse = cmd.getOptionValue(MONKEY_LONG_OPT);
        }
        if (cmd.hasOption(NO_CLUSTER_CLEANUP_LONG_OPT)) {
            this.noClusterCleanUp = true;
        }
        this.monkeyProps = new Properties();
        if (cmd.hasOption(CHAOS_MONKEY_PROPS) && StringUtils.isNotEmpty((String)(chaosMonkeyPropsFile = cmd.getOptionValue(CHAOS_MONKEY_PROPS)))) {
            try {
                this.monkeyProps.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(chaosMonkeyPropsFile));
            }
            catch (IOException e) {
                LOG.warn((Object)e);
                System.exit(1);
            }
        }
    }

    protected void processOptions(CommandLine cmd) {
        this.processBaseOptions(cmd);
    }

    public Configuration getConf() {
        Configuration c = super.getConf();
        if (c == null && this.util != null) {
            c = this.conf = this.util.getConfiguration();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doWork() throws Exception {
        this.setUp();
        int result = -1;
        try {
            result = this.runTestFromCommandLine();
        }
        finally {
            this.cleanUp();
        }
        return result;
    }

    @Before
    public void setUp() throws Exception {
        this.setUpCluster();
        this.setUpMonkey();
    }

    @After
    public void cleanUp() throws Exception {
        this.cleanUpMonkey();
        this.cleanUpCluster();
    }

    public void setUpMonkey() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        MonkeyFactory fact = MonkeyFactory.getFactory(this.monkeyToUse);
        if (fact == null) {
            fact = this.getDefaultMonkeyFactory();
        }
        this.monkey = fact.setUtil(this.util).setTableName(this.getTablename()).setProperties(this.monkeyProps).setColumnFamilies(this.getColumnFamilies()).build();
        this.startMonkey();
    }

    protected MonkeyFactory getDefaultMonkeyFactory() {
        return MonkeyFactory.getFactory(this.util.isDistributedCluster() ? "calm" : "slowDeterministic");
    }

    protected void startMonkey() throws Exception {
        this.monkey.start();
    }

    public void cleanUpMonkey() throws Exception {
        this.cleanUpMonkey("Ending test");
    }

    protected void cleanUpMonkey(String why) throws Exception {
        if (this.monkey != null && !this.monkey.isStopped()) {
            this.monkey.stop(why);
            this.monkey.waitForStop();
        }
    }

    protected IntegrationTestingUtility getTestingUtil(Configuration conf) {
        if (this.util == null) {
            if (conf == null) {
                this.util = new IntegrationTestingUtility();
                this.setConf(this.util.getConfiguration());
            } else {
                this.util = new IntegrationTestingUtility(conf);
            }
        }
        return this.util;
    }

    public abstract void setUpCluster() throws Exception;

    public void cleanUpCluster() throws Exception {
        if (this.util.isDistributedCluster() && (this.monkey == null || !this.monkey.isDestructive())) {
            this.noClusterCleanUp = true;
        }
        if (this.noClusterCleanUp) {
            LOG.debug((Object)"noClusterCleanUp is set, skip restoring the cluster");
            return;
        }
        LOG.debug((Object)"Restoring the cluster");
        this.util.restoreCluster();
        LOG.debug((Object)"Done restoring the cluster");
    }

    public abstract int runTestFromCommandLine() throws Exception;

    public abstract TableName getTablename();

    protected abstract Set<String> getColumnFamilies();
}

