/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;

public class MoveRegionsOfTableAction
extends Action {
    private final long sleepTime;
    private final TableName tableName;
    private final long maxTime;

    public MoveRegionsOfTableAction(TableName tableName) {
        this(-1L, 600000L, tableName);
    }

    public MoveRegionsOfTableAction(long sleepTime, long maxSleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
        this.maxTime = maxSleepTime;
    }

    @Override
    public void perform() throws Exception {
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
        HBaseAdmin admin = this.context.getHBaseIntegrationTestingUtility().getHBaseAdmin();
        Collection serversList = admin.getClusterStatus().getServers();
        ServerName[] servers = serversList.toArray(new ServerName[serversList.size()]);
        LOG.info((Object)("Performing action: Move regions of table " + this.tableName));
        List regions = admin.getTableRegions(this.tableName);
        if (regions == null || regions.isEmpty()) {
            LOG.info((Object)("Table " + this.tableName + " doesn't have regions to move"));
            return;
        }
        Collections.shuffle(regions);
        long start = System.currentTimeMillis();
        for (HRegionInfo regionInfo : regions) {
            if (this.context.isStopping()) {
                return;
            }
            try {
                String destServerName = servers[RandomUtils.nextInt((int)servers.length)].getServerName();
                LOG.debug((Object)("Moving " + regionInfo.getRegionNameAsString() + " to " + destServerName));
                admin.move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)destServerName));
            }
            catch (Exception ex) {
                LOG.warn((Object)("Move failed, might be caused by other chaos: " + ex.getMessage()));
            }
            if (this.sleepTime > 0L) {
                Thread.sleep(this.sleepTime);
            }
            if (System.currentTimeMillis() - start <= this.maxTime) continue;
            break;
        }
    }
}

