/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.Random;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;

public class TruncateTableAction
extends Action {
    private final TableName tableName;
    private final Random random;

    public TruncateTableAction(String tableName) {
        this.tableName = TableName.valueOf((String)tableName);
        this.random = new Random();
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        if (this.context.isStopping()) {
            return;
        }
        boolean preserveSplits = this.random.nextBoolean();
        LOG.info((Object)("Performing action: Truncate table " + this.tableName.getNameAsString() + "preserve splits " + preserveSplits));
        admin.truncateTable(this.tableName, preserveSplits);
    }
}

