/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.policies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.policies.PeriodicPolicy;
import org.apache.hadoop.hbase.chaos.policies.Policy;
import org.apache.hadoop.util.StringUtils;

public class DoActionsOncePolicy
extends PeriodicPolicy {
    private List<Action> actions;

    public DoActionsOncePolicy(long periodMs, List<Action> actions) {
        super(periodMs);
        this.actions = new ArrayList<Action>(actions);
    }

    public DoActionsOncePolicy(long periodMs, Action ... actions) {
        this(periodMs, Arrays.asList(actions));
    }

    @Override
    protected void runOneIteration() {
        if (this.actions.isEmpty()) {
            this.stop("done");
            return;
        }
        Action action = this.actions.remove(0);
        try {
            action.perform();
        }
        catch (Exception ex) {
            LOG.warn((Object)("Exception occured during performing action: " + StringUtils.stringifyException((Throwable)ex)));
        }
    }

    @Override
    public void init(Policy.PolicyContext context) throws Exception {
        super.init(context);
        for (Action action : this.actions) {
            action.init(this.context);
        }
    }
}

