/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.executor;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.executor.EventType;
import org.cloudera.htrace.Span;
import org.cloudera.htrace.Trace;
import org.cloudera.htrace.TraceScope;

@InterfaceAudience.Private
public abstract class EventHandler
implements Runnable,
Comparable<Runnable> {
    private static final Log LOG = LogFactory.getLog(EventHandler.class);
    protected EventType eventType;
    protected Server server;
    protected static final AtomicLong seqids = new AtomicLong(0L);
    private final long seqid;
    private EventHandlerListener listener;
    protected int waitingTimeForEvents;
    private final Span parent = Trace.currentSpan();

    public EventHandler(Server server, EventType eventType) {
        this.server = server;
        this.eventType = eventType;
        this.seqid = seqids.incrementAndGet();
        if (server != null) {
            this.waitingTimeForEvents = server.getConfiguration().getInt("hbase.master.event.waiting.time", 1000);
        }
    }

    public EventHandler prepare() throws Exception {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TraceScope chunk = Trace.startSpan((String)this.getClass().getSimpleName(), (Span)this.parent);
        try {
            if (this.getListener() != null) {
                this.getListener().beforeProcess(this);
            }
            this.process();
            if (this.getListener() != null) {
                this.getListener().afterProcess(this);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)("Caught throwable while processing event " + this.eventType), t);
        }
        finally {
            chunk.close();
        }
    }

    public abstract void process() throws IOException;

    public EventType getEventType() {
        return this.eventType;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public long getSeqid() {
        return this.seqid;
    }

    @Override
    public int compareTo(Runnable o) {
        EventHandler eh = (EventHandler)o;
        if (this.getPriority() != eh.getPriority()) {
            return this.getPriority() < eh.getPriority() ? -1 : 1;
        }
        return this.seqid < eh.seqid ? -1 : 1;
    }

    public synchronized EventHandlerListener getListener() {
        return this.listener;
    }

    public synchronized void setListener(EventHandlerListener listener) {
        this.listener = listener;
    }

    public String toString() {
        return "Event #" + this.getSeqid() + " of type " + this.eventType + " (" + this.getInformativeName() + ")";
    }

    public String getInformativeName() {
        return this.getClass().toString();
    }

    public static interface EventHandlerListener {
        public void beforeProcess(EventHandler var1);

        public void afterProcess(EventHandler var1);
    }
}

