/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class ResultSerialization
implements Serialization<Result> {
    public boolean accept(Class<?> c) {
        return Result.class.isAssignableFrom(c);
    }

    public Deserializer<Result> getDeserializer(Class<Result> c) {
        return new ResultDeserializer();
    }

    public Serializer<Result> getSerializer(Class<Result> c) {
        return new ResultSerializer();
    }

    private static class ResultSerializer
    implements Serializer<Result> {
        private OutputStream out;

        private ResultSerializer() {
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void open(OutputStream out) throws IOException {
            this.out = out;
        }

        public void serialize(Result result) throws IOException {
            ProtobufUtil.toResult((Result)result).writeDelimitedTo(this.out);
        }
    }

    private static class ResultDeserializer
    implements Deserializer<Result> {
        private InputStream in;

        private ResultDeserializer() {
        }

        public void close() throws IOException {
            this.in.close();
        }

        public Result deserialize(Result mutation) throws IOException {
            ClientProtos.Result proto = ClientProtos.Result.parseDelimitedFrom((InputStream)this.in);
            return ProtobufUtil.toResult((ClientProtos.Result)proto);
        }

        public void open(InputStream in) throws IOException {
            this.in = in;
        }
    }
}

