/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HRegionPartitioner;
import org.apache.hadoop.hbase.mapreduce.KeyValueSerialization;
import org.apache.hadoop.hbase.mapreduce.MultiTableInputFormat;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.PutCombiner;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.mapreduce.hadoopbackport.JarFinder;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.ZooKeeper;
import org.cloudera.htrace.Trace;
import org.jboss.netty.channel.ChannelFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableMapReduceUtil {
    static Log LOG = LogFactory.getLog(TableMapReduceUtil.class);

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table, scan, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(byte[] table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(Bytes.toString((byte[])table), scan, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, Class<? extends InputFormat> inputFormatClass) throws IOException {
        job.setInputFormatClass(inputFormatClass);
        if (outputValueClass != null) {
            job.setMapOutputValueClass(outputValueClass);
        }
        if (outputKeyClass != null) {
            job.setMapOutputKeyClass(outputKeyClass);
        }
        job.setMapperClass(mapper);
        if (Put.class.equals(outputValueClass)) {
            job.setCombinerClass(PutCombiner.class);
        }
        Configuration conf = job.getConfiguration();
        HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
        conf.set("hbase.mapreduce.inputtable", table);
        conf.set("hbase.mapreduce.scan", TableMapReduceUtil.convertScanToString(scan));
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), KeyValueSerialization.class.getName()});
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        TableMapReduceUtil.initCredentials(job);
    }

    public static void initTableMapperJob(byte[] table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, Class<? extends InputFormat> inputFormatClass) throws IOException {
        TableMapReduceUtil.initTableMapperJob(Bytes.toString((byte[])table), scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, inputFormatClass);
    }

    public static void initTableMapperJob(byte[] table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars) throws IOException {
        TableMapReduceUtil.initTableMapperJob(Bytes.toString((byte[])table), scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, TableInputFormat.class);
    }

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table, scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, TableInputFormat.class);
    }

    public static void initTableMapperJob(List<Scan> scans, Class<? extends TableMapper> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(scans, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(List<Scan> scans, Class<? extends TableMapper> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, Job job, boolean addDependencyJars) throws IOException {
        job.setInputFormatClass(MultiTableInputFormat.class);
        if (outputValueClass != null) {
            job.setMapOutputValueClass(outputValueClass);
        }
        if (outputKeyClass != null) {
            job.setMapOutputKeyClass(outputKeyClass);
        }
        job.setMapperClass(mapper);
        HBaseConfiguration.addHbaseResources((Configuration)job.getConfiguration());
        ArrayList<String> scanStrings = new ArrayList<String>();
        for (Scan scan : scans) {
            scanStrings.add(TableMapReduceUtil.convertScanToString(scan));
        }
        job.getConfiguration().setStrings("hbase.mapreduce.scans", scanStrings.toArray(new String[scanStrings.size()]));
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
    }

    public static void initCredentials(Job job) throws IOException {
        if (User.isHBaseSecurityEnabled((Configuration)job.getConfiguration())) {
            try {
                String quorumAddress = job.getConfiguration().get("hbase.mapred.output.quorum");
                if (quorumAddress != null) {
                    Configuration peerConf = HBaseConfiguration.create((Configuration)job.getConfiguration());
                    ZKUtil.applyClusterKeyToConf((Configuration)peerConf, (String)quorumAddress);
                    User.getCurrent().obtainAuthTokenForJob(peerConf, job);
                }
                User.getCurrent().obtainAuthTokenForJob(job.getConfiguration(), job);
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted obtaining user authentication token");
                Thread.interrupted();
            }
        }
    }

    static String convertScanToString(Scan scan) throws IOException {
        ClientProtos.Scan proto = ProtobufUtil.toScan((Scan)scan);
        return Base64.encodeBytes((byte[])proto.toByteArray());
    }

    static Scan convertStringToScan(String base64) throws IOException {
        ClientProtos.Scan scan;
        byte[] decoded = Base64.decode((String)base64);
        try {
            scan = ClientProtos.Scan.parseFrom((byte[])decoded);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new IOException(ipbe);
        }
        return ProtobufUtil.toScan((ClientProtos.Scan)scan);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job) throws IOException {
        TableMapReduceUtil.initTableReducerJob(table, reducer, job, null);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job, Class partitioner) throws IOException {
        TableMapReduceUtil.initTableReducerJob(table, reducer, job, partitioner, null, null, null);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job, Class partitioner, String quorumAddress, String serverClass, String serverImpl) throws IOException {
        TableMapReduceUtil.initTableReducerJob(table, reducer, job, partitioner, quorumAddress, serverClass, serverImpl, true);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job, Class partitioner, String quorumAddress, String serverClass, String serverImpl, boolean addDependencyJars) throws IOException {
        Configuration conf = job.getConfiguration();
        HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
        job.setOutputFormatClass(TableOutputFormat.class);
        if (reducer != null) {
            job.setReducerClass(reducer);
        }
        conf.set("hbase.mapred.outputtable", table);
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName()});
        if (quorumAddress != null) {
            ZKUtil.transformClusterKey((String)quorumAddress);
            conf.set("hbase.mapred.output.quorum", quorumAddress);
        }
        if (serverClass != null && serverImpl != null) {
            conf.set("hbase.mapred.output.rs.class", serverClass);
            conf.set("hbase.mapred.output.rs.impl", serverImpl);
        }
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Writable.class);
        if (partitioner == HRegionPartitioner.class) {
            job.setPartitionerClass(HRegionPartitioner.class);
            int regions = MetaReader.getRegionCount((Configuration)conf, (String)table);
            if (job.getNumReduceTasks() > regions) {
                job.setNumReduceTasks(regions);
            }
        } else if (partitioner != null) {
            job.setPartitionerClass(partitioner);
        }
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        TableMapReduceUtil.initCredentials(job);
    }

    public static void limitNumReduceTasks(String table, Job job) throws IOException {
        int regions = MetaReader.getRegionCount((Configuration)job.getConfiguration(), (String)table);
        if (job.getNumReduceTasks() > regions) {
            job.setNumReduceTasks(regions);
        }
    }

    public static void setNumReduceTasks(String table, Job job) throws IOException {
        job.setNumReduceTasks(MetaReader.getRegionCount((Configuration)job.getConfiguration(), (String)table));
    }

    public static void setScannerCaching(Job job, int batchSize) {
        job.getConfiguration().setInt("hbase.client.scanner.caching", batchSize);
    }

    public static void addDependencyJars(Job job) throws IOException {
        try {
            TableMapReduceUtil.addDependencyJars(job.getConfiguration(), HConstants.class, ClientProtos.class, Put.class, CompatibilityFactory.class, ZooKeeper.class, ChannelFactory.class, Message.class, Lists.class, Trace.class, job.getMapOutputKeyClass(), job.getMapOutputValueClass(), job.getInputFormatClass(), job.getOutputKeyClass(), job.getOutputValueClass(), job.getOutputFormatClass(), job.getPartitionerClass(), job.getCombinerClass());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static void addDependencyJars(Configuration conf, Class<?> ... classes) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> jars = new HashSet<String>();
        jars.addAll(conf.getStringCollection("tmpjars"));
        HashMap<String, String> packagedClasses = new HashMap<String, String>();
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            Path path = TableMapReduceUtil.findOrCreateJar(clazz, (FileSystem)localFs, packagedClasses);
            if (path == null) {
                LOG.warn((Object)("Could not find jar for class " + clazz + " in order to ship it to the cluster."));
                continue;
            }
            if (!localFs.exists(path)) {
                LOG.warn((Object)("Could not validate jar file " + path + " for class " + clazz));
                continue;
            }
            jars.add(path.toString());
        }
        if (jars.isEmpty()) {
            return;
        }
        conf.set("tmpjars", StringUtils.arrayToString((String[])jars.toArray(new String[0])));
    }

    private static Path findOrCreateJar(Class<?> my_class, FileSystem fs, Map<String, String> packagedClasses) throws IOException {
        String jar = TableMapReduceUtil.findContainingJar(my_class, packagedClasses);
        if (null == jar || jar.isEmpty()) {
            jar = TableMapReduceUtil.getJar(my_class);
            TableMapReduceUtil.updateMap(jar, packagedClasses);
        }
        if (null == jar || jar.isEmpty()) {
            throw new IOException("Cannot locate resource for class " + my_class.getName());
        }
        LOG.debug((Object)String.format("For class %s, using jar %s", my_class.getName(), jar));
        return new Path(jar).makeQualified(fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMap(String jar, Map<String, String> packagedClasses) throws IOException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(jar);
            Enumeration<? extends ZipEntry> iter = zip.entries();
            while (iter.hasMoreElements()) {
                ZipEntry entry = iter.nextElement();
                if (!entry.getName().endsWith("class")) continue;
                packagedClasses.put(entry.getName(), jar);
            }
        }
        finally {
            if (null != zip) {
                zip.close();
            }
        }
    }

    private static String findContainingJar(Class<?> my_class, Map<String, String> packagedClasses) throws IOException {
        ClassLoader loader = my_class.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        Enumeration<URL> itr = loader.getResources(class_file);
        while (itr.hasMoreElements()) {
            URL url = itr.nextElement();
            if (!"jar".equals(url.getProtocol())) continue;
            String toReturn = url.getPath();
            if (toReturn.startsWith("file:")) {
                toReturn = toReturn.substring("file:".length());
            }
            toReturn = toReturn.replaceAll("\\+", "%2B");
            toReturn = URLDecoder.decode(toReturn, "UTF-8");
            return toReturn.replaceAll("!.*$", "");
        }
        return packagedClasses.get(class_file);
    }

    private static String getJar(Class<?> my_class) {
        String ret = null;
        String hadoopJarFinder = "org.apache.hadoop.util.JarFinder";
        Class<?> jarFinder = null;
        try {
            LOG.debug((Object)("Looking for " + hadoopJarFinder + "."));
            jarFinder = Class.forName(hadoopJarFinder);
            LOG.debug((Object)(hadoopJarFinder + " found."));
            Method getJar = jarFinder.getMethod("getJar", Class.class);
            ret = (String)getJar.invoke(null, my_class);
        }
        catch (ClassNotFoundException e) {
            LOG.debug((Object)"Using backported JarFinder.");
            ret = JarFinder.getJar(my_class);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException("getJar invocation failed.", e);
        }
        return ret;
    }
}

