/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.InterProcessLock;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.exceptions.LockTimeoutException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.hbase.zookeeper.lock.ZKInterProcessReadWriteLock;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public abstract class TableLockManager {
    private static final Log LOG = LogFactory.getLog(TableLockManager.class);
    public static final String TABLE_LOCK_ENABLE = "hbase.table.lock.enable";
    private static final boolean DEFAULT_TABLE_LOCK_ENABLE = true;
    protected static final String TABLE_WRITE_LOCK_TIMEOUT_MS = "hbase.table.write.lock.timeout.ms";
    protected static final String TABLE_READ_LOCK_TIMEOUT_MS = "hbase.table.read.lock.timeout.ms";
    protected static final long DEFAULT_TABLE_WRITE_LOCK_TIMEOUT_MS = 600000L;
    protected static final long DEFAULT_TABLE_READ_LOCK_TIMEOUT_MS = 600000L;
    public static final String TABLE_LOCK_EXPIRE_TIMEOUT = "hbase.table.lock.expire.ms";
    public static final long DEFAULT_TABLE_LOCK_EXPIRE_TIMEOUT_MS = 600000L;

    public abstract TableLock writeLock(TableName var1, String var2);

    public abstract TableLock readLock(TableName var1, String var2);

    public abstract void visitAllLocks(InterProcessLock.MetadataHandler var1) throws IOException;

    public abstract void reapAllExpiredLocks() throws IOException;

    public abstract void reapWriteLocks() throws IOException;

    public abstract void tableDeleted(TableName var1) throws IOException;

    public static TableLockManager createTableLockManager(Configuration conf, ZooKeeperWatcher zkWatcher, ServerName serverName) {
        if (conf.getBoolean(TABLE_LOCK_ENABLE, true)) {
            long writeLockTimeoutMs = conf.getLong(TABLE_WRITE_LOCK_TIMEOUT_MS, 600000L);
            long readLockTimeoutMs = conf.getLong(TABLE_READ_LOCK_TIMEOUT_MS, 600000L);
            long lockExpireTimeoutMs = conf.getLong(TABLE_LOCK_EXPIRE_TIMEOUT, 600000L);
            return new ZKTableLockManager(zkWatcher, serverName, writeLockTimeoutMs, readLockTimeoutMs, lockExpireTimeoutMs);
        }
        return new NullTableLockManager();
    }

    public static ZooKeeperProtos.TableLock fromBytes(byte[] bytes) {
        int pblen = ProtobufUtil.lengthOfPBMagic();
        if (bytes == null || bytes.length < pblen) {
            return null;
        }
        try {
            ZooKeeperProtos.TableLock data = ((ZooKeeperProtos.TableLock.Builder)ZooKeeperProtos.TableLock.newBuilder().mergeFrom(bytes, pblen, bytes.length - pblen)).build();
            return data;
        }
        catch (InvalidProtocolBufferException ex) {
            LOG.warn((Object)"Exception in deserialization", (Throwable)ex);
            return null;
        }
    }

    @InterfaceAudience.Private
    private static class ZKTableLockManager
    extends TableLockManager {
        private static final InterProcessLock.MetadataHandler METADATA_HANDLER = new InterProcessLock.MetadataHandler(){

            @Override
            public void handleMetadata(byte[] ownerMetadata) {
                if (!LOG.isDebugEnabled()) {
                    return;
                }
                ZooKeeperProtos.TableLock data = TableLockManager.fromBytes(ownerMetadata);
                if (data == null) {
                    return;
                }
                LOG.debug((Object)("Table is locked by " + String.format("[tableName=%s, lockOwner=%s, threadId=%s, purpose=%s, isShared=%s, createTime=%s]", Bytes.toString((byte[])data.getTableName().toByteArray()), ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getLockOwner()), data.getThreadId(), data.getPurpose(), data.getIsShared(), data.getCreateTime())));
            }
        };
        private final ServerName serverName;
        private final ZooKeeperWatcher zkWatcher;
        private final long writeLockTimeoutMs;
        private final long readLockTimeoutMs;
        private final long lockExpireTimeoutMs;

        private static byte[] toBytes(ZooKeeperProtos.TableLock data) {
            return ProtobufUtil.prependPBMagic((byte[])data.toByteArray());
        }

        public ZKTableLockManager(ZooKeeperWatcher zkWatcher, ServerName serverName, long writeLockTimeoutMs, long readLockTimeoutMs, long lockExpireTimeoutMs) {
            this.zkWatcher = zkWatcher;
            this.serverName = serverName;
            this.writeLockTimeoutMs = writeLockTimeoutMs;
            this.readLockTimeoutMs = readLockTimeoutMs;
            this.lockExpireTimeoutMs = lockExpireTimeoutMs;
        }

        @Override
        public TableLock writeLock(TableName tableName, String purpose) {
            return new TableLockImpl(tableName, this.zkWatcher, this.serverName, this.writeLockTimeoutMs, false, purpose);
        }

        @Override
        public TableLock readLock(TableName tableName, String purpose) {
            return new TableLockImpl(tableName, this.zkWatcher, this.serverName, this.readLockTimeoutMs, true, purpose);
        }

        @Override
        public void visitAllLocks(InterProcessLock.MetadataHandler handler) throws IOException {
            for (String tableName : this.getTableNames()) {
                String tableLockZNode = ZKUtil.joinZNode((String)this.zkWatcher.tableLockZNode, (String)tableName);
                ZKInterProcessReadWriteLock lock = new ZKInterProcessReadWriteLock(this.zkWatcher, tableLockZNode, null);
                lock.readLock(null).visitLocks(handler);
                lock.writeLock(null).visitLocks(handler);
            }
        }

        private List<String> getTableNames() throws IOException {
            List tableNames;
            try {
                tableNames = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.zkWatcher, (String)this.zkWatcher.tableLockZNode);
            }
            catch (KeeperException e) {
                LOG.error((Object)"Unexpected ZooKeeper error when listing children", (Throwable)e);
                throw new IOException("Unexpected ZooKeeper exception", e);
            }
            return tableNames;
        }

        @Override
        public void reapWriteLocks() throws IOException {
            try {
                for (String tableName : this.getTableNames()) {
                    String tableLockZNode = ZKUtil.joinZNode((String)this.zkWatcher.tableLockZNode, (String)tableName);
                    ZKInterProcessReadWriteLock lock = new ZKInterProcessReadWriteLock(this.zkWatcher, tableLockZNode, null);
                    lock.writeLock(null).reapAllLocks();
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.warn((Object)"Caught exception while reaping table write locks", (Throwable)ex);
            }
        }

        @Override
        public void reapAllExpiredLocks() throws IOException {
            try {
                for (String tableName : this.getTableNames()) {
                    String tableLockZNode = ZKUtil.joinZNode((String)this.zkWatcher.tableLockZNode, (String)tableName);
                    ZKInterProcessReadWriteLock lock = new ZKInterProcessReadWriteLock(this.zkWatcher, tableLockZNode, null);
                    lock.readLock(null).reapExpiredLocks(this.lockExpireTimeoutMs);
                    lock.writeLock(null).reapExpiredLocks(this.lockExpireTimeoutMs);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public void tableDeleted(TableName tableName) throws IOException {
            String tableNameStr = tableName.getNameAsString();
            String tableLockZNode = ZKUtil.joinZNode((String)this.zkWatcher.tableLockZNode, (String)tableNameStr);
            try {
                ZKUtil.deleteNode((ZooKeeperWatcher)this.zkWatcher, (String)tableLockZNode);
            }
            catch (KeeperException ex) {
                if (ex.code() == KeeperException.Code.NOTEMPTY) {
                    LOG.warn((Object)("Could not delete the znode for table locks because NOTEMPTY: " + tableLockZNode));
                    return;
                }
                throw new IOException(ex);
            }
        }

        private static class TableLockImpl
        implements TableLock {
            long lockTimeoutMs;
            TableName tableName;
            InterProcessLock lock;
            boolean isShared;
            ZooKeeperWatcher zkWatcher;
            ServerName serverName;
            String purpose;

            public TableLockImpl(TableName tableName, ZooKeeperWatcher zkWatcher, ServerName serverName, long lockTimeoutMs, boolean isShared, String purpose) {
                this.tableName = tableName;
                this.zkWatcher = zkWatcher;
                this.serverName = serverName;
                this.lockTimeoutMs = lockTimeoutMs;
                this.isShared = isShared;
                this.purpose = purpose;
            }

            @Override
            public void acquire() throws IOException {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Attempt to acquire table " + (this.isShared ? "read" : "write") + " lock on: " + this.tableName + " for:" + this.purpose));
                }
                this.lock = this.createTableLock();
                try {
                    if (this.lockTimeoutMs == -1L) {
                        this.lock.acquire();
                    } else if (!this.lock.tryAcquire(this.lockTimeoutMs)) {
                        throw new LockTimeoutException("Timed out acquiring " + (this.isShared ? "read" : "write") + "lock for table:" + this.tableName + "for:" + this.purpose + " after " + this.lockTimeoutMs + " ms.");
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)("Interrupted acquiring a lock for " + this.tableName), (Throwable)e);
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("Interrupted acquiring a lock");
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Acquired table " + (this.isShared ? "read" : "write") + " lock on " + this.tableName + " for " + this.purpose));
                }
            }

            @Override
            public void release() throws IOException {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Attempt to release table " + (this.isShared ? "read" : "write") + " lock on " + this.tableName));
                }
                if (this.lock == null) {
                    throw new IllegalStateException("Table " + this.tableName + " is not locked!");
                }
                try {
                    this.lock.release();
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)("Interrupted while releasing a lock for " + this.tableName));
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Released table lock on " + this.tableName));
                }
            }

            private InterProcessLock createTableLock() {
                String tableLockZNode = ZKUtil.joinZNode((String)this.zkWatcher.tableLockZNode, (String)this.tableName.getNameAsString());
                ZooKeeperProtos.TableLock data = ZooKeeperProtos.TableLock.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName)).setLockOwner(ProtobufUtil.toServerName((ServerName)this.serverName)).setThreadId(Thread.currentThread().getId()).setPurpose(this.purpose).setIsShared(this.isShared).setCreateTime(EnvironmentEdgeManager.currentTimeMillis()).build();
                byte[] lockMetadata = ZKTableLockManager.toBytes(data);
                ZKInterProcessReadWriteLock lock = new ZKInterProcessReadWriteLock(this.zkWatcher, tableLockZNode, METADATA_HANDLER);
                return this.isShared ? lock.readLock(lockMetadata) : lock.writeLock(lockMetadata);
            }
        }
    }

    @InterfaceAudience.Private
    public static class NullTableLockManager
    extends TableLockManager {
        @Override
        public TableLock writeLock(TableName tableName, String purpose) {
            return new NullTableLock();
        }

        @Override
        public TableLock readLock(TableName tableName, String purpose) {
            return new NullTableLock();
        }

        @Override
        public void reapAllExpiredLocks() throws IOException {
        }

        @Override
        public void reapWriteLocks() throws IOException {
        }

        @Override
        public void tableDeleted(TableName tableName) throws IOException {
        }

        @Override
        public void visitAllLocks(InterProcessLock.MetadataHandler handler) throws IOException {
        }

        static class NullTableLock
        implements TableLock {
            NullTableLock() {
            }

            @Override
            public void acquire() throws IOException {
            }

            @Override
            public void release() throws IOException {
            }
        }
    }

    @InterfaceAudience.Private
    public static interface TableLock {
        public void acquire() throws IOException;

        public void release() throws IOException;
    }
}

