/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.ClusterLoadState;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class StochasticLoadBalancer
extends BaseLoadBalancer {
    private static final String STEPS_PER_REGION_KEY = "hbase.master.balancer.stochastic.stepsPerRegion";
    private static final String MAX_STEPS_KEY = "hbase.master.balancer.stochastic.maxSteps";
    private static final String MAX_RUNNING_TIME_KEY = "hbase.master.balancer.stochastic.maxRunningTime";
    private static final String KEEP_REGION_LOADS = "hbase.master.balancer.stochastic.numRegionLoadsToRemember";
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final Log LOG = LogFactory.getLog(StochasticLoadBalancer.class);
    private final RegionLocationFinder regionFinder = new RegionLocationFinder();
    private ClusterStatus clusterStatus = null;
    Map<String, Deque<RegionLoad>> loads = new HashMap<String, Deque<RegionLoad>>();
    private int maxSteps = 1000000;
    private int stepsPerRegion = 800;
    private long maxRunningTime = 30000L;
    private int numRegionLoadsToRemember = 15;
    private RegionPicker[] pickers;
    private CostFromRegionLoadFunction[] regionLoadFunctions;
    private CostFunction[] costFunctions;
    private LocalityBasedPicker localityPicker;
    private LocalityCostFunction localityCost;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.regionFinder.setConf(conf);
        this.maxSteps = conf.getInt(MAX_STEPS_KEY, this.maxSteps);
        this.stepsPerRegion = conf.getInt(STEPS_PER_REGION_KEY, this.stepsPerRegion);
        this.maxRunningTime = conf.getLong(MAX_RUNNING_TIME_KEY, this.maxRunningTime);
        this.numRegionLoadsToRemember = conf.getInt(KEEP_REGION_LOADS, this.numRegionLoadsToRemember);
        this.localityPicker = new LocalityBasedPicker(this.services);
        this.localityCost = new LocalityCostFunction(conf, this.services);
        this.pickers = new RegionPicker[]{new RandomRegionPicker(), new LoadPicker(), this.localityPicker};
        this.regionLoadFunctions = new CostFromRegionLoadFunction[]{new ReadRequestCostFunction(conf), new WriteRequestCostFunction(conf), new MemstoreSizeCostFunction(conf), new StoreFileCostFunction(conf)};
        this.costFunctions = new CostFunction[]{new RegionCountSkewCostFunction(conf), new MoveCostFunction(conf), this.localityCost, new TableSkewCostFunction(conf), this.regionLoadFunctions[0], this.regionLoadFunctions[1], this.regionLoadFunctions[2], this.regionLoadFunctions[3]};
    }

    @Override
    protected void setSlop(Configuration conf) {
        this.slop = conf.getFloat("hbase.regions.slop", 0.001f);
    }

    @Override
    public void setClusterStatus(ClusterStatus st) {
        super.setClusterStatus(st);
        this.regionFinder.setClusterStatus(st);
        this.clusterStatus = st;
        this.updateRegionLoad();
        for (CostFromRegionLoadFunction cost : this.regionLoadFunctions) {
            cost.setClusterStatus(st);
        }
    }

    @Override
    public void setMasterServices(MasterServices masterServices) {
        super.setMasterServices(masterServices);
        this.regionFinder.setServices(masterServices);
        this.localityCost.setServices(masterServices);
        this.localityPicker.setServices(masterServices);
    }

    @Override
    public List<RegionPlan> balanceCluster(Map<ServerName, List<HRegionInfo>> clusterState) {
        long step;
        double currentCost;
        if (!this.needsBalance(new ClusterLoadState(clusterState))) {
            return null;
        }
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, this.loads, this.regionFinder);
        double initCost = currentCost = this.computeCost(cluster, Double.MAX_VALUE);
        double newCost = currentCost;
        long computedMaxSteps = Math.min((long)this.maxSteps, (long)cluster.numRegions * (long)this.stepsPerRegion * (long)cluster.numServers);
        for (step = 0L; step < computedMaxSteps; ++step) {
            int pickerIdx = RANDOM.nextInt(this.pickers.length);
            RegionPicker p = this.pickers[pickerIdx];
            Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> picks = p.pick(cluster);
            int leftServer = (Integer)((Pair)picks.getFirst()).getFirst();
            int leftRegion = (Integer)((Pair)picks.getFirst()).getSecond();
            int rightServer = (Integer)((Pair)picks.getSecond()).getFirst();
            int rightRegion = (Integer)((Pair)picks.getSecond()).getSecond();
            if (rightServer < 0 || leftServer < 0 || leftRegion < 0 && rightRegion < 0) continue;
            cluster.moveOrSwapRegion(leftServer, rightServer, leftRegion, rightRegion);
            newCost = this.computeCost(cluster, currentCost);
            if (newCost < currentCost) {
                currentCost = newCost;
            } else {
                cluster.moveOrSwapRegion(leftServer, rightServer, rightRegion, leftRegion);
            }
            if (EnvironmentEdgeManager.currentTimeMillis() - startTime > this.maxRunningTime) break;
        }
        long endTime = EnvironmentEdgeManager.currentTimeMillis();
        this.metricsBalancer.balanceCluster(endTime - startTime);
        if (initCost > currentCost) {
            List<RegionPlan> plans = this.createRegionPlans(cluster);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Finished computing new load balance plan.  Computation took " + (endTime - startTime) + "ms to try " + step + " different iterations.  Found a solution that moves " + plans.size() + " regions; Going from a computed cost of " + initCost + " to a new cost of " + currentCost));
            }
            return plans;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Could not find a better load balance plan.  Tried " + step + " different configurations in " + (endTime - startTime) + "ms, and did not find anything with a computed cost less than " + initCost));
        }
        return null;
    }

    private List<RegionPlan> createRegionPlans(BaseLoadBalancer.Cluster cluster) {
        LinkedList<RegionPlan> plans = new LinkedList<RegionPlan>();
        for (int regionIndex = 0; regionIndex < cluster.regionIndexToServerIndex.length; ++regionIndex) {
            int initialServerIndex = cluster.initialRegionIndexToServerIndex[regionIndex];
            int newServerIndex = cluster.regionIndexToServerIndex[regionIndex];
            if (initialServerIndex == newServerIndex) continue;
            HRegionInfo region = cluster.regions[regionIndex];
            ServerName initialServer = cluster.servers[initialServerIndex];
            ServerName newServer = cluster.servers[newServerIndex];
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Moving Region " + region.getEncodedName() + " from server " + initialServer.getHostname() + " to " + newServer.getHostname()));
            }
            RegionPlan rp = new RegionPlan(region, initialServer, newServer);
            plans.add(rp);
        }
        return plans;
    }

    private synchronized void updateRegionLoad() {
        Map<String, Deque<RegionLoad>> oldLoads = this.loads;
        this.loads = new HashMap<String, Deque<RegionLoad>>();
        for (ServerName sn : this.clusterStatus.getServers()) {
            ServerLoad sl = this.clusterStatus.getLoad(sn);
            if (sl == null) continue;
            for (Map.Entry entry : sl.getRegionsLoad().entrySet()) {
                Deque<RegionLoad> rLoads = oldLoads.get(Bytes.toString((byte[])((byte[])entry.getKey())));
                if (rLoads == null) {
                    rLoads = new ArrayDeque<RegionLoad>();
                } else if (rLoads.size() >= 15) {
                    rLoads.remove();
                }
                rLoads.add((RegionLoad)entry.getValue());
                this.loads.put(Bytes.toString((byte[])((byte[])entry.getKey())), rLoads);
            }
        }
        for (CostFromRegionLoadFunction cost : this.regionLoadFunctions) {
            cost.setLoads(this.loads);
        }
    }

    protected double computeCost(BaseLoadBalancer.Cluster cluster, double previousCost) {
        double total = 0.0;
        for (CostFunction c : this.costFunctions) {
            if (c.getMultiplier() <= 0.0f || !((total += (double)c.getMultiplier() * c.cost(cluster)) > previousCost)) continue;
            return total;
        }
        return total;
    }

    public static class StoreFileCostFunction
    extends CostFromRegionLoadFunction {
        private static final String STOREFILE_SIZE_COST_KEY = "hbase.master.balancer.stochastic.storefileSizeCost";
        private static final float DEFAULT_STOREFILE_SIZE_COST = 5.0f;

        StoreFileCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(STOREFILE_SIZE_COST_KEY, 5.0f));
        }

        @Override
        protected double getCostFromRl(RegionLoad rl) {
            return rl.getStorefileSizeMB();
        }
    }

    public static class MemstoreSizeCostFunction
    extends CostFromRegionLoadFunction {
        private static final String MEMSTORE_SIZE_COST_KEY = "hbase.master.balancer.stochastic.memstoreSizeCost";
        private static final float DEFAULT_MEMSTORE_SIZE_COST = 5.0f;

        MemstoreSizeCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(MEMSTORE_SIZE_COST_KEY, 5.0f));
        }

        @Override
        protected double getCostFromRl(RegionLoad rl) {
            return rl.getMemStoreSizeMB();
        }
    }

    public static class WriteRequestCostFunction
    extends CostFromRegionLoadFunction {
        private static final String WRITE_REQUEST_COST_KEY = "hbase.master.balancer.stochastic.writeRequestCost";
        private static final float DEFAULT_WRITE_REQUEST_COST = 5.0f;

        WriteRequestCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(WRITE_REQUEST_COST_KEY, 5.0f));
        }

        @Override
        protected double getCostFromRl(RegionLoad rl) {
            return rl.getWriteRequestsCount();
        }
    }

    public static class ReadRequestCostFunction
    extends CostFromRegionLoadFunction {
        private static final String READ_REQUEST_COST_KEY = "hbase.master.balancer.stochastic.readRequestCost";
        private static final float DEFAULT_READ_REQUEST_COST = 5.0f;

        ReadRequestCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(READ_REQUEST_COST_KEY, 5.0f));
        }

        @Override
        protected double getCostFromRl(RegionLoad rl) {
            return rl.getReadRequestsCount();
        }
    }

    public static abstract class CostFromRegionLoadFunction
    extends CostFunction {
        private ClusterStatus clusterStatus = null;
        private Map<String, Deque<RegionLoad>> loads = null;
        private double[] stats = null;

        CostFromRegionLoadFunction(Configuration conf) {
            super(conf);
        }

        void setClusterStatus(ClusterStatus status) {
            this.clusterStatus = status;
        }

        void setLoads(Map<String, Deque<RegionLoad>> l) {
            this.loads = l;
        }

        @Override
        double cost(BaseLoadBalancer.Cluster cluster) {
            if (this.clusterStatus == null || this.loads == null) {
                return 0.0;
            }
            if (this.stats == null || this.stats.length != cluster.numServers) {
                this.stats = new double[cluster.numServers];
            }
            for (int i = 0; i < this.stats.length; ++i) {
                long cost = 0L;
                for (int regionIndex : cluster.regionsPerServer[i]) {
                    Deque<RegionLoad> regionLoadList = cluster.regionLoads[regionIndex];
                    if (regionLoadList == null) continue;
                    cost = (long)((double)cost + this.getRegionLoadCost(regionLoadList));
                }
                this.stats[i] = cost;
            }
            return this.costFromArray(this.stats);
        }

        protected double getRegionLoadCost(Collection<RegionLoad> regionLoadList) {
            double cost = 0.0;
            for (RegionLoad rl : regionLoadList) {
                double toAdd = this.getCostFromRl(rl);
                if (cost == 0.0) {
                    cost = toAdd;
                    continue;
                }
                cost = 0.5 * cost + 0.5 * toAdd;
            }
            return cost;
        }

        protected abstract double getCostFromRl(RegionLoad var1);
    }

    public static class LocalityCostFunction
    extends CostFunction {
        private static final String LOCALITY_COST_KEY = "hbase.master.balancer.stochastic.localityCost";
        private static final float DEFAULT_LOCALITY_COST = 25.0f;
        private MasterServices services;

        LocalityCostFunction(Configuration conf, MasterServices srv) {
            super(conf);
            this.setMultiplier(conf.getFloat(LOCALITY_COST_KEY, 25.0f));
            this.services = srv;
        }

        void setServices(MasterServices srvc) {
            this.services = srvc;
        }

        @Override
        double cost(BaseLoadBalancer.Cluster cluster) {
            double max = 0.0;
            double cost = 0.0;
            if (this.services == null) {
                return cost;
            }
            for (int i = 0; i < cluster.regionLocations.length; ++i) {
                max += 1.0;
                int serverIndex = cluster.regionIndexToServerIndex[i];
                int[] regionLocations = cluster.regionLocations[i];
                if (regionLocations == null) continue;
                int index = -1;
                for (int j = 0; j < regionLocations.length; ++j) {
                    if (regionLocations[j] < 0 || regionLocations[j] != serverIndex) continue;
                    index = j;
                    break;
                }
                if (index < 0) {
                    cost += 1.0;
                    continue;
                }
                cost += (double)index / (double)regionLocations.length;
            }
            return this.scale(0.0, max, cost);
        }
    }

    public static class TableSkewCostFunction
    extends CostFunction {
        private static final String TABLE_SKEW_COST_KEY = "hbase.master.balancer.stochastic.tableSkewCost";
        private static final float DEFAULT_TABLE_SKEW_COST = 35.0f;

        TableSkewCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(TABLE_SKEW_COST_KEY, 35.0f));
        }

        @Override
        double cost(BaseLoadBalancer.Cluster cluster) {
            double max = cluster.numRegions;
            double min = cluster.numRegions / cluster.numServers;
            double value = 0.0;
            for (int i = 0; i < cluster.numMaxRegionsPerTable.length; ++i) {
                value += (double)cluster.numMaxRegionsPerTable[i];
            }
            return this.scale(min, max, value);
        }
    }

    public static class RegionCountSkewCostFunction
    extends CostFunction {
        private static final String REGION_COUNT_SKEW_COST_KEY = "hbase.master.balancer.stochastic.regionCountCost";
        private static final float DEFAULT_REGION_COUNT_SKEW_COST = 500.0f;
        private double[] stats = null;

        RegionCountSkewCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(REGION_COUNT_SKEW_COST_KEY, 500.0f));
        }

        @Override
        double cost(BaseLoadBalancer.Cluster cluster) {
            if (this.stats == null || this.stats.length != cluster.numServers) {
                this.stats = new double[cluster.numServers];
            }
            for (int i = 0; i < cluster.numServers; ++i) {
                this.stats[i] = cluster.regionsPerServer[i].length;
            }
            return this.costFromArray(this.stats);
        }
    }

    public static class MoveCostFunction
    extends CostFunction {
        private static final String MOVE_COST_KEY = "hbase.master.balancer.stochastic.moveCost";
        private static final String MAX_MOVES_PERCENT_KEY = "hbase.master.balancer.stochastic.maxMovePercent";
        private static final float DEFAULT_MOVE_COST = 100.0f;
        private static final int DEFAULT_MAX_MOVES = 600;
        private static final float DEFAULT_MAX_MOVE_PERCENT = 0.25f;
        private static final int META_MOVE_COST_MULT = 10;
        private final float maxMovesPercent;

        MoveCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(MOVE_COST_KEY, 100.0f));
            this.maxMovesPercent = conf.getFloat(MAX_MOVES_PERCENT_KEY, 0.25f);
        }

        @Override
        double cost(BaseLoadBalancer.Cluster cluster) {
            double moveCost = cluster.numMovedRegions;
            int maxMoves = Math.max((int)((float)cluster.numRegions * this.maxMovesPercent), 600);
            if (moveCost > (double)maxMoves) {
                return 1000000.0;
            }
            if (cluster.numMovedMetaRegions > 0) {
                moveCost += (double)(10 * cluster.numMovedMetaRegions);
            }
            return this.scale(0.0, cluster.numRegions + 10, moveCost);
        }
    }

    public static abstract class CostFunction {
        private float multiplier = 0.0f;
        private Configuration conf;

        CostFunction(Configuration c) {
            this.conf = c;
        }

        float getMultiplier() {
            return this.multiplier;
        }

        void setMultiplier(float m) {
            this.multiplier = m;
        }

        abstract double cost(BaseLoadBalancer.Cluster var1);

        protected double costFromArray(double[] stats) {
            double totalCost = 0.0;
            double total = this.getSum(stats);
            double mean = total / (double)stats.length;
            double count = stats.length;
            double max = (count - 1.0) * mean + (total - mean);
            for (double n : stats) {
                double diff = Math.abs(mean - n);
                totalCost += diff;
            }
            double scaled = this.scale(0.0, max, totalCost);
            return scaled;
        }

        private double getSum(double[] stats) {
            double total = 0.0;
            for (double s : stats) {
                total += s;
            }
            return total;
        }

        protected double scale(double min, double max, double value) {
            if (max == 0.0 || value == 0.0) {
                return 0.0;
            }
            return Math.max(0.0, Math.min(1.0, (value - min) / max));
        }
    }

    static class LocalityBasedPicker
    extends RegionPicker {
        private MasterServices masterServices;

        LocalityBasedPicker(MasterServices masterServices) {
            this.masterServices = masterServices;
        }

        @Override
        Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> pick(BaseLoadBalancer.Cluster cluster) {
            if (this.masterServices == null) {
                return new Pair((Object)new Pair((Object)-1, (Object)-1), (Object)new Pair((Object)-1, (Object)-1));
            }
            int thisServer = this.pickRandomServer(cluster);
            int thisRegion = this.pickRandomRegion(cluster, thisServer, 0.0);
            if (thisRegion == -1) {
                return new Pair((Object)new Pair((Object)-1, (Object)-1), (Object)new Pair((Object)-1, (Object)-1));
            }
            int otherServer = this.pickHighestLocalityServer(cluster, thisServer, thisRegion);
            int otherRegion = this.pickRandomRegion(cluster, otherServer, 0.5);
            return new Pair((Object)new Pair((Object)thisServer, (Object)thisRegion), (Object)new Pair((Object)otherServer, (Object)otherRegion));
        }

        private int pickHighestLocalityServer(BaseLoadBalancer.Cluster cluster, int thisServer, int thisRegion) {
            int idx;
            int[] regionLocations = cluster.regionLocations[thisRegion];
            if (regionLocations == null || regionLocations.length <= 1) {
                return this.pickOtherRandomServer(cluster, thisServer);
            }
            for (idx = 0; idx < regionLocations.length && regionLocations[idx] == thisServer; ++idx) {
            }
            return idx;
        }

        void setServices(MasterServices services) {
            this.masterServices = services;
        }
    }

    public static class LoadPicker
    extends RegionPicker {
        @Override
        Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> pick(BaseLoadBalancer.Cluster cluster) {
            cluster.sortServersByRegionCount();
            int thisServer = this.pickMostLoadedServer(cluster, -1);
            int otherServer = this.pickLeastLoadedServer(cluster, thisServer);
            Pair<Integer, Integer> regions = this.pickRandomRegions(cluster, thisServer, otherServer);
            return new Pair((Object)new Pair((Object)thisServer, regions.getFirst()), (Object)new Pair((Object)otherServer, regions.getSecond()));
        }

        private int pickLeastLoadedServer(BaseLoadBalancer.Cluster cluster, int thisServer) {
            Integer[] servers = cluster.serverIndicesSortedByRegionCount;
            int index = 0;
            while (servers[index] == null || servers[index] == thisServer) {
                if (++index != servers.length) continue;
                return -1;
            }
            return servers[index];
        }

        private int pickMostLoadedServer(BaseLoadBalancer.Cluster cluster, int thisServer) {
            Integer[] servers = cluster.serverIndicesSortedByRegionCount;
            int index = servers.length - 1;
            while (servers[index] == null || servers[index] == thisServer) {
                if (--index >= 0) continue;
                return -1;
            }
            return servers[index];
        }
    }

    static class RandomRegionPicker
    extends RegionPicker {
        RandomRegionPicker() {
        }

        @Override
        Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> pick(BaseLoadBalancer.Cluster cluster) {
            int thisServer = this.pickRandomServer(cluster);
            int otherServer = this.pickOtherRandomServer(cluster, thisServer);
            Pair<Integer, Integer> regions = this.pickRandomRegions(cluster, thisServer, otherServer);
            return new Pair((Object)new Pair((Object)thisServer, regions.getFirst()), (Object)new Pair((Object)otherServer, regions.getSecond()));
        }
    }

    static abstract class RegionPicker {
        RegionPicker() {
        }

        abstract Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> pick(BaseLoadBalancer.Cluster var1);

        protected int pickRandomRegion(BaseLoadBalancer.Cluster cluster, int server, double chanceOfNoSwap) {
            if (cluster.regionsPerServer[server].length == 0 || (double)RANDOM.nextFloat() < chanceOfNoSwap) {
                return -1;
            }
            int rand = RANDOM.nextInt(cluster.regionsPerServer[server].length);
            return cluster.regionsPerServer[server][rand];
        }

        protected int pickRandomServer(BaseLoadBalancer.Cluster cluster) {
            if (cluster.numServers < 1) {
                return -1;
            }
            return RANDOM.nextInt(cluster.numServers);
        }

        protected int pickOtherRandomServer(BaseLoadBalancer.Cluster cluster, int serverIndex) {
            int otherServerIndex;
            if (cluster.numServers < 2) {
                return -1;
            }
            while ((otherServerIndex = this.pickRandomServer(cluster)) == serverIndex) {
            }
            return otherServerIndex;
        }

        protected Pair<Integer, Integer> pickRandomRegions(BaseLoadBalancer.Cluster cluster, int thisServer, int otherServer) {
            int otherRegionCount;
            if (thisServer < 0 || otherServer < 0) {
                return new Pair((Object)-1, (Object)-1);
            }
            int thisRegionCount = cluster.getNumRegions(thisServer);
            double thisChance = thisRegionCount > (otherRegionCount = cluster.getNumRegions(otherServer)) ? 0.0 : 0.5;
            double otherChance = thisRegionCount <= otherRegionCount ? 0.0 : 0.5;
            int thisRegion = this.pickRandomRegion(cluster, thisServer, thisChance);
            int otherRegion = this.pickRandomRegion(cluster, otherServer, otherChance);
            return new Pair((Object)thisRegion, (Object)otherRegion);
        }
    }
}

