/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.LRUDictionary;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public abstract class WriterBase
implements HLog.Writer {
    protected CompressionContext compressionContext;

    public boolean initializeCompressionContext(Configuration conf, Path path) throws IOException {
        boolean doCompress = conf.getBoolean("hbase.regionserver.wal.enablecompression", false);
        if (doCompress) {
            try {
                this.compressionContext = new CompressionContext(LRUDictionary.class, FSUtils.isRecoveredEdits(path));
            }
            catch (Exception e) {
                throw new IOException("Failed to initiate CompressionContext", e);
            }
        }
        return doCompress;
    }
}

