/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.FSVisitor;

@InterfaceAudience.Private
public final class SnapshotReferenceUtil {
    private SnapshotReferenceUtil() {
    }

    public static Path getLogsDir(Path snapshotDir, String serverName) {
        return new Path(snapshotDir, HLogUtil.getHLogDirectoryName(serverName));
    }

    public static Path getRecoveredEditsDir(Path snapshotDir, String regionName) {
        return HLogUtil.getRegionDirRecoveredEditsDir(new Path(snapshotDir, regionName));
    }

    public static Path getRecoveredEdits(Path snapshotDir, String regionName, String logfile) {
        return new Path(SnapshotReferenceUtil.getRecoveredEditsDir(snapshotDir, regionName), logfile);
    }

    public static void visitReferencedFiles(FileSystem fs, Path snapshotDir, FileVisitor visitor) throws IOException {
        SnapshotReferenceUtil.visitTableStoreFiles(fs, snapshotDir, visitor);
        SnapshotReferenceUtil.visitRecoveredEdits(fs, snapshotDir, visitor);
        SnapshotReferenceUtil.visitLogFiles(fs, snapshotDir, visitor);
    }

    public static void visitTableStoreFiles(FileSystem fs, Path snapshotDir, FSVisitor.StoreFileVisitor visitor) throws IOException {
        FSVisitor.visitTableStoreFiles(fs, snapshotDir, visitor);
    }

    public static void visitRegionStoreFiles(FileSystem fs, Path regionDir, FSVisitor.StoreFileVisitor visitor) throws IOException {
        FSVisitor.visitRegionStoreFiles(fs, regionDir, visitor);
    }

    public static void visitRecoveredEdits(FileSystem fs, Path snapshotDir, FSVisitor.RecoveredEditsVisitor visitor) throws IOException {
        FSVisitor.visitTableRecoveredEdits(fs, snapshotDir, visitor);
    }

    public static void visitLogFiles(FileSystem fs, Path snapshotDir, FSVisitor.LogFileVisitor visitor) throws IOException {
        FSVisitor.visitLogFiles(fs, snapshotDir, visitor);
    }

    public static Set<String> getSnapshotRegionNames(FileSystem fs, Path snapshotDir) throws IOException {
        FileStatus[] regionDirs = FSUtils.listStatus(fs, snapshotDir, new FSUtils.RegionDirFilter(fs));
        if (regionDirs == null) {
            return null;
        }
        HashSet<String> regions = new HashSet<String>();
        for (FileStatus regionDir : regionDirs) {
            regions.add(regionDir.getPath().getName());
        }
        return regions;
    }

    public static Map<String, List<String>> getRegionHFileReferences(FileSystem fs, Path snapshotRegionDir) throws IOException {
        final TreeMap<String, List<String>> familyFiles = new TreeMap<String, List<String>>();
        SnapshotReferenceUtil.visitRegionStoreFiles(fs, snapshotRegionDir, new FSVisitor.StoreFileVisitor(){

            @Override
            public void storeFile(String region, String family, String hfile) throws IOException {
                LinkedList<String> hfiles = (LinkedList<String>)familyFiles.get(family);
                if (hfiles == null) {
                    hfiles = new LinkedList<String>();
                    familyFiles.put(family, hfiles);
                }
                hfiles.add(hfile);
            }
        });
        return familyFiles;
    }

    public static Set<String> getHFileNames(FileSystem fs, Path snapshotDir) throws IOException {
        final HashSet<String> names = new HashSet<String>();
        SnapshotReferenceUtil.visitTableStoreFiles(fs, snapshotDir, new FSVisitor.StoreFileVisitor(){

            @Override
            public void storeFile(String region, String family, String hfile) throws IOException {
                if (HFileLink.isHFileLink(hfile)) {
                    names.add(HFileLink.getReferencedHFileName(hfile));
                } else {
                    names.add(hfile);
                }
            }
        });
        return names;
    }

    public static Set<String> getHLogNames(FileSystem fs, Path snapshotDir) throws IOException {
        final HashSet<String> names = new HashSet<String>();
        SnapshotReferenceUtil.visitLogFiles(fs, snapshotDir, new FSVisitor.LogFileVisitor(){

            @Override
            public void logFile(String server, String logfile) throws IOException {
                names.add(logfile);
            }
        });
        return names;
    }

    public static interface FileVisitor
    extends FSVisitor.StoreFileVisitor,
    FSVisitor.RecoveredEditsVisitor,
    FSVisitor.LogFileVisitor {
    }
}

