/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.KeyValueCompression;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public class WALEdit
implements Writable,
HeapSize {
    public static final Log LOG = LogFactory.getLog(WALEdit.class);
    public static final byte[] METAFAMILY = Bytes.toBytes((String)"METAFAMILY");
    static final byte[] METAROW = Bytes.toBytes((String)"METAROW");
    static final byte[] COMPLETE_CACHE_FLUSH = Bytes.toBytes((String)"HBASE::CACHEFLUSH");
    static final byte[] COMPACTION = Bytes.toBytes((String)"HBASE::COMPACTION");
    private final int VERSION_2 = -1;
    private final boolean isReplay;
    private final ArrayList<KeyValue> kvs = new ArrayList(1);
    @Deprecated
    private NavigableMap<byte[], Integer> scopes;
    private CompressionContext compressionContext;

    public WALEdit() {
        this(false);
    }

    public WALEdit(boolean isReplay) {
        this.isReplay = isReplay;
    }

    public static boolean isMetaEditFamily(byte[] f) {
        return Bytes.equals((byte[])METAFAMILY, (byte[])f);
    }

    public boolean isReplay() {
        return this.isReplay;
    }

    public void setCompressionContext(CompressionContext compressionContext) {
        this.compressionContext = compressionContext;
    }

    public WALEdit add(KeyValue kv) {
        this.kvs.add(kv);
        return this;
    }

    public boolean isEmpty() {
        return this.kvs.isEmpty();
    }

    public int size() {
        return this.kvs.size();
    }

    public ArrayList<KeyValue> getKeyValues() {
        return this.kvs;
    }

    public NavigableMap<byte[], Integer> getAndRemoveScopes() {
        NavigableMap<byte[], Integer> result = this.scopes;
        this.scopes = null;
        return result;
    }

    public void readFields(DataInput in) throws IOException {
        int versionOrLength;
        this.kvs.clear();
        if (this.scopes != null) {
            this.scopes.clear();
        }
        if ((versionOrLength = in.readInt()) == -1) {
            int numEdits = in.readInt();
            for (int idx = 0; idx < numEdits; ++idx) {
                if (this.compressionContext != null) {
                    this.add(KeyValueCompression.readKV(in, this.compressionContext));
                    continue;
                }
                this.add(KeyValue.create((DataInput)in));
            }
            int numFamilies = in.readInt();
            if (numFamilies > 0) {
                if (this.scopes == null) {
                    this.scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
                }
                for (int i = 0; i < numFamilies; ++i) {
                    byte[] fam = Bytes.readByteArray((DataInput)in);
                    int scope = in.readInt();
                    this.scopes.put(fam, scope);
                }
            }
        } else {
            this.add(KeyValue.create((int)versionOrLength, (DataInput)in));
        }
    }

    public void write(DataOutput out) throws IOException {
        LOG.warn((Object)"WALEdit is being serialized to writable - only expected in test code");
        out.writeInt(-1);
        out.writeInt(this.kvs.size());
        for (KeyValue kv : this.kvs) {
            if (this.compressionContext != null) {
                KeyValueCompression.writeKV(out, kv, this.compressionContext);
                continue;
            }
            KeyValue.write((KeyValue)kv, (DataOutput)out);
        }
        if (this.scopes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.scopes.size());
            for (byte[] key : this.scopes.keySet()) {
                Bytes.writeByteArray((DataOutput)out, (byte[])key);
                out.writeInt((Integer)this.scopes.get(key));
            }
        }
    }

    public int readFromCells(Codec.Decoder cellDecoder, int expectedCount) throws IOException {
        this.kvs.clear();
        this.kvs.ensureCapacity(expectedCount);
        while (this.kvs.size() < expectedCount && cellDecoder.advance()) {
            Cell cell = cellDecoder.current();
            if (!(cell instanceof KeyValue)) {
                throw new IOException("WAL edit only supports KVs as cells");
            }
            this.kvs.add((KeyValue)cell);
        }
        return this.kvs.size();
    }

    public long heapSize() {
        long ret = ClassSize.ARRAYLIST;
        for (KeyValue kv : this.kvs) {
            ret += kv.heapSize();
        }
        if (this.scopes != null) {
            ret += (long)ClassSize.TREEMAP;
            ret += (long)ClassSize.align((int)(this.scopes.size() * ClassSize.MAP_ENTRY));
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[#edits: " + this.kvs.size() + " = <");
        for (KeyValue kv : this.kvs) {
            sb.append(kv.toString());
            sb.append("; ");
        }
        if (this.scopes != null) {
            sb.append(" scopes: " + this.scopes.toString());
        }
        sb.append(">]");
        return sb.toString();
    }

    public static WALEdit createCompaction(WALProtos.CompactionDescriptor c) {
        byte[] pbbytes = c.toByteArray();
        KeyValue kv = new KeyValue(METAROW, METAFAMILY, COMPACTION, System.currentTimeMillis(), pbbytes);
        return new WALEdit().add(kv);
    }

    public static WALProtos.CompactionDescriptor getCompaction(KeyValue kv) throws IOException {
        if (kv.matchingRow(METAROW) && kv.matchingColumn(METAFAMILY, COMPACTION)) {
            return WALProtos.CompactionDescriptor.parseFrom((byte[])kv.getValue());
        }
        return null;
    }
}

